/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.detection;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1262
extends BaseIC {
    public MC1262(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "LIGHT SENSOR";
        this.MCName = "[MC1262]";
        this.MCGroup = "detection";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output: High if threshold is reached", "", "");
        this.chipState.setLines("Minimum light level, 0 to 15.", "");
        this.ICDescription = "The MC1262 checks to see if the light level of the block above the block behind the IC sign is greater than or equal to a configurable threshold whenever the input goes from low to high.<br /><br />The <a href=\"MC0262.html\">MC0262</a> is the selftriggered version.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1262.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC1262.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(3, "");
        if (event.getLine(2).length() < 1) {
            event.setLine(2, "15");
        }
        String minLight = event.getLine(2);
        try {
            if (minLight.length() > 0) {
                Integer.parseInt(minLight);
            }
        }
        catch (NumberFormatException e) {
            MC1262.cancelCreation(event, "The third line must indicate the minimum light level.");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1262.getBlockPositions(signBlock);
        if (MC1262.isPowered(positions.get(0))) {
            byte minLight = 5;
            try {
                minLight = Integer.valueOf(signBlock.getLine(2)).intValue();
            }
            catch (Exception e) {
                minLight = 5;
            }
            if (MC1262.getICBlock(signBlock).getBlock().getRelative(0, 1, 0).getLightLevel() >= minLight) {
                MC1262.switchLever(signBlock, true);
            } else {
                MC1262.switchLever(signBlock, false);
            }
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

