/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC0262
extends SelftriggeredBaseIC {
    private boolean oldStatus;
    private Block myBlock = null;
    private boolean result;
    private int minLight = 15;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 9;
        this.Name = "LIGHT SENSOR";
        this.MCName = "[MC0262]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Output: High if the threshold is reached", "", "");
        this.chipState.setLines("Minimum light level, 0 to 15.", "");
        this.ICDescription = "The MC0262 checks to see if the light level of the block above the block behind the IC sign is greater than or equal to a configurable threshold.";
    }

    public MC0262(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0262(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC0262.isActivated(this.signBlock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0262.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC0262.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(3, "");
        if (event.getLine(2).length() < 1) {
            event.setLine(2, "15");
        }
        String minLight = event.getLine(2);
        try {
            if (minLight.length() > 0) {
                Integer.parseInt(minLight);
            }
        }
        catch (NumberFormatException e) {
            MC0262.cancelCreation(event, "The third line must indicate the minimum light level.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            try {
                this.myBlock = MC0262.getICBlock(this.signBlock).getBlock().getRelative(0, 1, 0);
                this.minLight = Integer.valueOf(this.signBlock.getLine(2));
                if (this.minLight < 1 || this.minLight > 15) {
                    this.minLight = 15;
                }
            }
            catch (Exception e) {
                this.myBlock = null;
            }
            this.startUp = false;
        }
        if (this.myBlock == null) {
            return;
        }
        boolean bl = this.result = this.myBlock.getLightLevel() >= this.minLight;
        if (this.result != this.oldStatus) {
            this.oldStatus = this.result;
            MC0262.switchLever(this.signBlock, this.result);
        }
    }
}

