/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import com.gemo.utils.BlockUtils;
import com.gemo.utils.UtilPermissions;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC0272
extends SelftriggeredBaseIC {
    private boolean oldStatus;
    private boolean result;
    private int detectionRange = -1;
    private String detectedString = null;
    private String detectionMode = null;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 13;
        this.Name = "P-DETECTION";
        this.MCName = "[MC0272]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "", "", "");
        this.chipState.setOutputs("Output", "", "");
        this.chipState.setLines("distance of detection around the IC block", "p:<part of a playername> OR g:<groupname>");
        this.ICDescription = "The MC0272 outputs high if a specified player is detected in the given distance around the ic.";
    }

    public MC0272(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC0272(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC0272.isActivated(this.signBlock);
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC0272.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            if (event.getLine(2).length() > 0) {
                try {
                    Integer.valueOf(event.getLine(2));
                }
                catch (Exception e) {
                    MC0272.cancelCreation(event, "Line 3 must be a number.");
                    return;
                }
            } else {
                MC0272.cancelCreation(event, "Line 3 must be a number.");
                return;
            }
            if (event.getLine(3).length() < 0) {
                MC0272.cancelCreation(event, "Please enter a Playername in Line 4");
                return;
            }
            String[] split = event.getLine(3).split(":");
            if (split.length < 2) {
                MC0272.cancelCreation(event, "Wrong syntax in Line 4. Use p:<playername> or g:<groupname>");
                return;
            }
            if (!split[0].equalsIgnoreCase("p") && !split[0].equalsIgnoreCase("g")) {
                MC0272.cancelCreation(event, "Wrong syntax in Line 4. Use p:<playername> or g:<groupname>");
                return;
            }
        } else {
            MC0272.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            try {
                this.detectionRange = Integer.valueOf(this.signBlock.getLine(2));
                String[] split = this.signBlock.getLine(3).split(":");
                if (split.length < 2) {
                    return;
                }
                this.detectionMode = split[0];
                this.detectedString = split[1];
            }
            catch (Exception e) {
                this.detectionRange = -1;
                this.detectionMode = null;
                this.detectedString = null;
            }
            this.startUp = false;
        }
        if (this.detectedString == null) {
            return;
        }
        this.result = false;
        Location blockLoc = MC0272.getICBlock(this.signBlock);
        if (this.detectionMode.equalsIgnoreCase("p")) {
            Player[] playerList;
            Player[] playerArray = playerList = FalseBookICCore.server.getOnlinePlayers();
            int n = playerList.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                if (player.getName().toLowerCase().indexOf(this.detectedString.toLowerCase()) > -1) {
                    this.result = BlockUtils.isInRange((Location)player.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                }
                ++n2;
            }
            playerList = null;
        } else if (this.detectionMode.equalsIgnoreCase("g")) {
            Player[] playerList;
            Player[] playerArray = playerList = FalseBookICCore.server.getOnlinePlayers();
            int n = playerList.length;
            int n3 = 0;
            while (n3 < n) {
                Player player = playerArray[n3];
                if (UtilPermissions.isPlayerInGroup((Player)player, (String)this.detectedString, (String)this.signBlock.getWorld().getName())) {
                    this.result = BlockUtils.isInRange((Location)player.getLocation(), (Location)blockLoc, (int)this.detectionRange);
                }
                ++n3;
            }
            Player[] playerArray2 = null;
        }
        blockLoc = null;
        if (this.result != this.oldStatus) {
            this.oldStatus = this.result;
            MC0272.switchLever(this.signBlock, this.result);
        }
    }
}

