/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;

public class MC2101
extends BaseIC {
    public HashMap<String, SchedulerClass> TaskList = new HashMap();

    public MC2101(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "NOT-DELAYER";
        this.MCName = "[MC2101]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, false, "Clock", "Reset", "");
        this.chipState.setOutputs("Output", "", "");
        this.chipState.setLines("delay in seconds", "");
        this.ICDescription = "The MC2101 delays a high signal for [x] seconds (Line 3) and inverts it, if the signal is stable.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC2101.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC2101.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        try {
            int val = Integer.valueOf(event.getLine(2));
            if (val < 0) {
                val = -val;
                event.setLine(2, "" + val);
            }
        }
        catch (Exception e) {
            MC2101.cancelCreation(event, "Enter the delay in seconds in line 3.");
            return;
        }
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC2101.getBlockPositions(signBlock);
        if (MC2101.isPowered(positions.get(0)) && MC2101.isLow(positions.get(1))) {
            for (SchedulerClass sched : this.TaskList.values()) {
                if (!sched.equalsLoc(signBlock.getBlock().getLocation())) continue;
                plugin.getServer().getScheduler().cancelTask(sched.TaskID);
                this.TaskList.remove(signBlock.getBlock().getLocation().toString());
                break;
            }
            int secs = 1;
            try {
                secs = Integer.valueOf(signBlock.getLine(2));
            }
            catch (Exception e) {
                return;
            }
            SchedulerClass newSched = new SchedulerClass(this, signBlock.getBlock().getLocation());
            newSched.TaskID = plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)newSched, (long)(20 * secs));
            this.TaskList.put(signBlock.getBlock().getLocation().toString(), newSched);
        } else if (MC2101.isPowered(positions.get(1)) || MC2101.isLow(positions.get(0))) {
            for (SchedulerClass sched : this.TaskList.values()) {
                if (!sched.equalsLoc(signBlock.getBlock().getLocation())) continue;
                plugin.getServer().getScheduler().cancelTask(sched.TaskID);
                this.TaskList.remove(signBlock.getBlock().getLocation().toString());
                break;
            }
            MC2101.switchLever(signBlock, true);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }

    public class SchedulerClass
    implements Runnable {
        public int TaskID = -1;
        public MC2101 father;
        public Location signLoc;

        public SchedulerClass(MC2101 father, Location signLoc) {
            this.father = father;
            this.signLoc = signLoc;
        }

        @Override
        public void run() {
            BaseIC.switchLever((Sign)this.signLoc.getBlock().getState(), false);
            this.father.TaskList.remove(this.signLoc.getBlock().getLocation().toString());
            plugin.getServer().getScheduler().cancelTask(this.TaskID);
        }

        public boolean equalsLoc(Location loc) {
            return this.signLoc.equals((Object)loc);
        }
    }
}

