/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;

public class MC2501
extends BaseIC {
    public HashMap<String, SchedulerClass> TaskList = new HashMap();

    public MC2501(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "NOT PULSER";
        this.MCName = "[MC2501]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Pulsing output", "", "");
        this.chipState.setLines("[pulselength[:startdelay]]", "[[pulsecount][:pauselength in serverticks]]");
        this.ICDescription = "The MC2501 fires a (choosable) pulse of low-signals with a choosable length of the signal and the pause between the pulses when the input goes from low to high.<br /><br />Standard is one pulse with a length of 5 ticks.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC2501.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            int val;
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            try {
                String[] lines = event.getLine(2).split(":");
                if (lines.length == 1) {
                    val = Integer.valueOf(lines[0]);
                    if (val < 0 && (val = -val) < 1) {
                        val = 1;
                    }
                    event.setLine(2, "" + val);
                } else if (lines.length > 1) {
                    int valDelay;
                    val = Integer.valueOf(lines[0]);
                    if (val < 0 && (val = -val) < 1) {
                        val = 1;
                    }
                    if ((valDelay = Integer.valueOf(lines[1]).intValue()) < 0 && (valDelay = -valDelay) < 1) {
                        valDelay = 1;
                    }
                    event.setLine(2, String.valueOf(val) + ":" + valDelay);
                }
            }
            catch (Exception e) {
                event.setLine(2, "5");
                return;
            }
            if (event.getLine(3).length() > 1) {
                String[] split = event.getLine(3).split(":");
                if (split.length < 2) {
                    try {
                        val = Integer.valueOf(split[0]);
                        if (val < 0 && (val = -val) < 1) {
                            val = 1;
                        }
                        event.setLine(3, "" + val);
                    }
                    catch (Exception e) {
                        MC2501.cancelCreation(event, "Wrong syntax in Line 4. Use: Pulsecount[:Pauselength] (Integer only)");
                        return;
                    }
                } else {
                    try {
                        int val2;
                        val = Integer.valueOf(split[0]);
                        if (val < 0 && (val = -val) < 1) {
                            val = 1;
                        }
                        if ((val2 = Integer.valueOf(split[1]).intValue()) < 0) {
                            val2 = -val2;
                        }
                        event.setLine(3, String.valueOf(val) + ":" + val2);
                    }
                    catch (Exception e) {
                        MC2501.cancelCreation(event, "Wrong syntax in Line 4. Use: Pulsecount[:Pauselength] (Integer only)");
                        return;
                    }
                }
            }
        } else {
            MC2501.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC2501.getBlockPositions(signBlock);
        if (MC2501.isPowered(positions.get(0))) {
            for (SchedulerClass sched : this.TaskList.values()) {
                if (!sched.equalsLoc(signBlock.getBlock().getLocation())) continue;
                return;
            }
            int pulseLength = 5;
            int pulseCount = 1;
            int pauseLength = 5;
            int pulseDelay = 1;
            try {
                String[] lines = signBlock.getLine(2).split(":");
                pulseDelay = 1;
                if (lines.length == 1) {
                    pulseLength = Integer.valueOf(lines[0]);
                    if (pulseLength < 0 && (pulseLength = -pulseLength) < 1) {
                        pulseLength = 5;
                    }
                } else if (lines.length > 1) {
                    pulseLength = Integer.valueOf(lines[0]);
                    if (pulseLength < 0 && (pulseLength = -pulseLength) < 1) {
                        pulseLength = 5;
                    }
                    if ((pulseDelay = Integer.valueOf(lines[1]).intValue()) < 0) {
                        pulseDelay = -pulseDelay;
                    }
                }
                if (signBlock.getLine(3).length() > 0) {
                    String[] split = signBlock.getLine(3).split(":");
                    if (split.length < 2) {
                        pulseCount = Integer.valueOf(split[0]);
                        pauseLength = pulseLength;
                    } else {
                        pulseCount = Integer.valueOf(split[0]);
                        pauseLength = Integer.valueOf(split[1]);
                    }
                }
            }
            catch (Exception e) {
                pulseLength = 5;
                pulseCount = 1;
                pauseLength = 5;
                pulseDelay = 1;
            }
            SchedulerClass newSched = new SchedulerClass(this, signBlock.getBlock().getLocation(), pulseLength, pulseCount, pauseLength);
            newSched.TaskID = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)newSched, (long)pulseDelay, 1L);
            this.TaskList.put(signBlock.getBlock().getLocation().toString(), newSched);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }

    public class SchedulerClass
    implements Runnable {
        public int TaskID = -1;
        public MC2501 father;
        public Location signLoc;
        public int countedTicks = 0;
        public int pulseLength = 5;
        public int pulseCount = 1;
        public int pauseLength = 5;
        public int curPulse = 0;
        public boolean first = true;
        public boolean curState = false;
        public Sign signBlock = null;

        public SchedulerClass(MC2501 father, Location signLoc, int pulseLength, int pulseCount, int pauseLength) {
            this.father = father;
            this.signLoc = signLoc;
            this.pulseLength = pulseLength;
            this.pulseCount = pulseCount;
            this.pauseLength = pauseLength;
            this.signBlock = (Sign)signLoc.getBlock().getState();
        }

        @Override
        public void run() {
            if (this.first) {
                MC2501.switchLever(this.signBlock, false);
                this.first = false;
            }
            ++this.countedTicks;
            if (this.curState && this.pauseLength == this.countedTicks || !this.curState && this.pulseLength == this.countedTicks) {
                this.countedTicks = 0;
                if (this.countedTicks == 0 && !this.curState) {
                    --this.pulseCount;
                }
                this.curState = !this.curState;
                try {
                    BaseIC.switchLever((Sign)this.signLoc.getBlock().getState(), this.curState);
                }
                catch (Exception e) {
                    this.father.TaskList.remove(this.signLoc.getBlock().getLocation().toString());
                    plugin.getServer().getScheduler().cancelTask(this.TaskID);
                }
            }
            if (this.pulseCount < 1) {
                this.father.TaskList.remove(this.signLoc.getBlock().getLocation().toString());
                plugin.getServer().getScheduler().cancelTask(this.TaskID);
            }
        }

        public boolean equalsLoc(Location loc) {
            return this.signLoc.equals((Object)loc);
        }
    }
}

