/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC3033
extends BaseIC {
    public MC3033(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "RS NAND LATCH";
        this.MCName = "[MC3033]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, false, "Set", "Reset", "");
        this.chipState.setOutputs("Output", "", "");
        this.ICDescription = "The MC3033 implements a RS NAND latch. Only the Q output is available. When the S (inverse \"set\") input exclusively goes high, the output (Q) goes high and stays high even if S goes low again. When the R (inverse \"reset\") input exclusively goes high, the output (Q) goes low and stays low even if R goes low again. If both go low at the same time, the output goes high. If both go high at the same time, the output does not change.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC3033.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC3033.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC3033.getBlockPositions(signBlock);
        boolean inputA = MC3033.isLow(positions.get(0));
        boolean inputB = MC3033.isLow(positions.get(1));
        if (inputA && !inputB || !inputA && !inputB) {
            MC3033.switchLever(signBlock, true);
        } else if (!inputA && inputB) {
            MC3033.switchLever(signBlock, false);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

