/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.utils.BlockUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1200
extends BaseIC {
    public MC1200(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "MOB SPAWNER";
        this.MCName = "[MC1200]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("<b>Mobname to spawn:</b><ul><li>AngryWolf</li><li>Chicken</li><li>Cow</li><li>Creeper</li><li>Dog</li><li>Ghast</li><li>Giant</li><li>Monster (hostile human)</li><li>Pig</li><li>PigZombie</li><li>Sheep</li><li>Skeleton</li><li>Slime</li><li>Spider</li><li>Zombie</li><li>Wolf</li></ul>", "");
        this.ICDescription = "The MC1200 spawns a mob in the first free space above the block behind the IC sign when the input (the \"clock\") goes from low to high.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1200.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup) || BaseIC.hasPermission(player, "mc1200." + event.getLine(2).toLowerCase())) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            CreatureType[] creatures = CreatureType.values();
            if (event.getLine(2) == null) {
                MC1200.cancelCreation(event, "Mob not found.");
                return;
            }
            boolean found = false;
            int i = 0;
            while (i < creatures.length) {
                if (event.getLine(2).equalsIgnoreCase(creatures[i].getName()) || event.getLine(2).equalsIgnoreCase("pig_zombie") || event.getLine(2).equalsIgnoreCase("DOG") || event.getLine(2).equalsIgnoreCase("ANGRYWOLF")) {
                    event.setLine(2, event.getLine(2).toUpperCase());
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                MC1200.cancelCreation(event, "Mob not found.");
                return;
            }
        } else {
            MC1200.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1200.getBlockPositions(signBlock);
        if (MC1200.isPowered(positions.get(0))) {
            World w = signBlock.getWorld();
            Location loc = MC1200.getICBlock(signBlock);
            int maxY = Math.min(128, loc.getBlockY() + 10);
            int y = loc.getBlockY() + 1;
            while (y <= maxY) {
                if (BlockUtils.canPassThrough((int)w.getBlockAt(loc.getBlockX(), y, loc.getBlockZ()).getTypeId()) && BlockUtils.canPassThrough((int)w.getBlockAt(loc.getBlockX(), y + 1, loc.getBlockZ()).getTypeId())) {
                    Location sPos = loc;
                    sPos.setX(sPos.getX() + 0.5);
                    sPos.setZ(sPos.getZ() + 0.5);
                    sPos.setY((double)y);
                    MC1200.switchLever(signBlock, true);
                    int i = 0;
                    while (i < CreatureType.values().length) {
                        if (CreatureType.values()[i].name().equalsIgnoreCase(signBlock.getLine(2))) {
                            w.spawnCreature(loc, CreatureType.values()[i]);
                            break;
                        }
                        ++i;
                    }
                    if (signBlock.getLine(2).equalsIgnoreCase("pigzombie")) {
                        w.spawnCreature(loc, CreatureType.PIG_ZOMBIE);
                    } else if (signBlock.getLine(2).equalsIgnoreCase("dog")) {
                        LivingEntity dog = w.spawnCreature(loc, CreatureType.WOLF);
                        ((Wolf)dog).setSitting(true);
                    } else if (signBlock.getLine(2).equalsIgnoreCase("angrywolf")) {
                        LivingEntity dog = w.spawnCreature(loc, CreatureType.WOLF);
                        ((Wolf)dog).setAngry(true);
                    }
                    return;
                }
                ++y;
            }
        } else {
            MC1200.switchLever(signBlock, false);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

