/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.MessageHandler;
import com.mysticx.bukkit.backupplugin.PluginUnit;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.World;

public final class BackupUnit
extends PluginUnit {
    public BackupUnit(Server instance, File workdir) {
        super(instance, workdir);
        this.name = "BackupUnit";
    }

    public BackupUnit(Server instance, File workdir, boolean force) {
        super(instance, workdir, force);
        this.name = "BackupUnit";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isEnabled) {
            MessageHandler.log(Level.WARNING, " is disabled. Thread goes to sleep.");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                MessageHandler.log(Level.WARNING, "woke up from sleep unexpectedly!", e);
            }
        }
        MessageHandler.log(Level.INFO, "Starting backup process..");
        this.server.savePlayers();
        try {
            String worldname = this.cc.getWorld().getName();
            World world = this.server.getWorld(worldname);
            if (world == null) {
                MessageHandler.warning(String.format("World %s don't exist", worldname));
            } else {
                world.save();
                String filename = this.generateFilename(".zip");
                File outputFile = new File(this.getWorkDir(), filename);
                if (this.cc.persistCache(outputFile, this.isForce())) {
                    MessageHandler.log(Level.INFO, "Backup sucessfull");
                } else {
                    MessageHandler.log(Level.WARNING, "Backup failed");
                }
            }
        }
        catch (Exception e) {
            MessageHandler.log(Level.SEVERE, "Error during backup: ", e);
        }
        finally {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

