/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.IOHelper;
import com.mysticx.bukkit.backupplugin.MessageHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public final class CacheControl {
    private static final CacheControl cc = new CacheControl();
    private IOHelper iohelper = IOHelper.getInstance();
    private File cache = null;
    private File world = null;
    private int cacheLifetime = 30;
    private int cacheHistory = 5;
    private TimeUnit tu = TimeUnit.MINUTES;
    private Timer timer = new Timer();
    private Lock lock = new ReentrantLock();

    private CacheControl() {
    }

    public static CacheControl getInstance() {
        return cc;
    }

    public void setTimeUnit(TimeUnit tu) {
        this.tu = tu;
    }

    public void setTimeUnit(String tu) {
        try {
            TimeUnit timeunit = TimeUnit.valueOf(tu);
            this.setTimeUnit(timeunit);
        }
        catch (Exception e) {
            MessageHandler.warning("Failed to parse time-unit, using default.");
        }
    }

    public void setTempDir(File tempdir) {
        this.cache = tempdir;
    }

    public void setWorld(String worldname) {
        this.world = new File(worldname);
    }

    public File getWorld() {
        return this.world;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setCacheLifetime(int lifetime) {
        this.cacheLifetime = lifetime;
    }

    public void setCacheHistory(int history) {
        this.cacheHistory = history;
    }

    private boolean isCacheObsolete() {
        return !this.cache.exists() || System.currentTimeMillis() - this.cache.lastModified() > this.tu.toMillis(this.cacheLifetime);
    }

    private void scheduleTimer() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CacheCleanerTask(), this.tu.toMillis(this.cacheLifetime));
        MessageHandler.log(Level.FINEST, "CacheCleaner was scheduled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteCache() {
        if (!this.cache.exists()) {
            return true;
        }
        MessageHandler.log(Level.FINEST, "deleteCache() obtaining lock..");
        this.lock.lock();
        MessageHandler.log(Level.INFO, "Deleting cache, might be obsolete.");
        try {
            if (!this.iohelper.deleteDirectory(this.cache)) {
                MessageHandler.log(Level.WARNING, "Failed to delete temp folder.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
            MessageHandler.log(Level.FINEST, "deleteCache() unlocked..");
        }
        return true;
    }

    public synchronized File getCache(boolean force) {
        if (!force && !this.isCacheObsolete()) {
            MessageHandler.log(Level.FINEST, "Cache still up to date!");
            return this.cache;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.rebuildCache()) {
            this.scheduleTimer();
            return this.cache;
        }
        MessageHandler.log(Level.WARNING, "Cache couldn't be rebuilt!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rebuildCache() {
        if (!this.world.exists()) {
            MessageHandler.log(Level.WARNING, "World path doesn't exist!");
            return false;
        }
        MessageHandler.log(Level.INFO, "Rebuilding Cache. This can take several minutes, depending on the world size.");
        if (this.cache.exists() && !this.deleteCache()) {
            return false;
        }
        try {
            MessageHandler.log(Level.FINEST, "rebuildCache() obtaining lock..");
            this.lock.lock();
            MessageHandler.log(Level.FINEST, "rebuildCache() got lock, copy dir..");
            this.iohelper.copyDir(this.world, this.cache);
        }
        catch (FileNotFoundException e) {
            MessageHandler.log(Level.SEVERE, "Error rebuilding cache: ", e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            MessageHandler.log(Level.SEVERE, "Error rebuilding cache: ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            MessageHandler.log(Level.FINEST, "rebuildCache() unlocked..");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistCache(File outputFile, boolean force) {
        MessageHandler.log(Level.FINE, "Persisting cache / creating zip file..");
        try {
            File currentCache = this.getCache(force);
            MessageHandler.log(Level.FINEST, "persistCache() got cache, obtaining lock..");
            this.lock.lock();
            MessageHandler.log(Level.FINEST, "persistCache() got lock, starting zip operation..");
            this.iohelper.zipDirectory(currentCache, outputFile);
            MessageHandler.log(Level.FINEST, "persistCache() finished zip operation..");
            if (this.cacheHistory > 0) {
                this.iohelper.deleteOldFiles(outputFile.getParentFile(), this.world.getName(), this.cacheHistory);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            MessageHandler.log(Level.SEVERE, "Error while zipping temp folder!", e);
        }
        finally {
            this.lock.unlock();
            MessageHandler.log(Level.FINEST, "persistCache() unlocked..");
        }
        return false;
    }

    private class CacheCleanerTask
    extends TimerTask {
        private CacheCleanerTask() {
        }

        @Override
        public void run() {
            CacheControl.this.deleteCache();
            CacheControl.this.timer.cancel();
            MessageHandler.log(Level.INFO, "Cache lifetime ended.");
        }
    }
}

