/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.BackupFilter;
import com.mysticx.bukkit.backupplugin.MessageHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class IOHelper {
    private static IOHelper instance = new IOHelper();
    private static final int BUFFER = 8192;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;

    public static IOHelper getInstance() {
        return instance;
    }

    private IOHelper() {
    }

    public void zipDirectory(File directory, File zip) throws IOException {
        zip.getParentFile().mkdirs();
        if (!zip.exists()) {
            zip.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(zip);
        ZipOutputStream zos = new ZipOutputStream(fileOutputStream);
        try {
            this.zip(directory, directory, zos);
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            zos.close();
            fileOutputStream.close();
        }
    }

    private void zip(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                this.zip(files[i], base, zos);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(files[i]);
            try {
                ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1));
                zos.putNextEntry(entry);
                while (-1 != (read = fileInputStream.read(buffer))) {
                    zos.write(buffer, 0, read);
                }
                continue;
            }
            catch (IOException ioex) {
                throw ioex;
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    public void copyDir(File source, File target) throws IOException {
        File[] files = source.listFiles();
        target.mkdirs();
        for (File file : files) {
            if (file.isDirectory()) {
                this.copyDir(file, new File(target.getAbsolutePath() + System.getProperty("file.separator") + file.getName()));
                continue;
            }
            this.copyFile(file, new File(target.getAbsolutePath() + System.getProperty("file.separator") + file.getName()));
        }
    }

    public void copyFile(File file, File target) throws IOException {
        this.in = new BufferedInputStream(new FileInputStream(file));
        this.out = new BufferedOutputStream(new FileOutputStream(target, true));
        int bytes = 0;
        while ((bytes = this.in.read()) != -1) {
            this.out.write(bytes);
        }
        this.in.close();
        this.out.close();
    }

    public void copyFile(File file, File target, boolean append) throws IOException {
        MessageHandler.log(Level.FINEST, "copy operation: " + file + " to " + target + " (" + append + ")");
        this.in = new BufferedInputStream(new FileInputStream(file));
        this.out = new BufferedOutputStream(new FileOutputStream(target, append));
        int bytes = 0;
        while ((bytes = this.in.read()) != -1) {
            this.out.write(bytes);
        }
        this.in.close();
        this.out.close();
    }

    public boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public boolean deleteFile(File path) {
        MessageHandler.log(Level.FINE, "deleting file: " + path);
        return path.delete();
    }

    public boolean deleteOldFiles(File path, String world, int number) {
        File[] files;
        boolean success = true;
        if (path.exists() && (files = path.listFiles(new BackupFilter(world))).length > number) {
            Arrays.sort(files, new FileComparator());
            for (int i = 0; i < files.length - number; ++i) {
                MessageHandler.log(Level.INFO, "deleting old backup file: " + files[i]);
                if (files[i].delete()) continue;
                success = false;
            }
        }
        return success;
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.lastModified() == o2.lastModified()) {
                return 0;
            }
            if (o1.lastModified() < o2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }
}

