/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class MessageHandler {
    private static Server server;
    private static Logger l;
    private static final ChatColor BROADCAST_COLOR;
    private static final String PLUGIN_PREFIX = "[BackupPlugin] ";
    private static Level logLevel;

    protected static void log(Level level, String message, Throwable thrown) {
        if (MessageHandler.compareLevel(level)) {
            l.log(level, MessageHandler.addPrefix(message), thrown);
        }
    }

    protected static void log(Level level, String message) {
        if ((level == Level.FINE || level == Level.FINEST) && MessageHandler.compareLevel(level)) {
            l.log(Level.INFO, MessageHandler.addPrefix("[DEBUG] " + message));
        }
        if (MessageHandler.compareLevel(level)) {
            l.log(level, MessageHandler.addPrefix(message));
        }
    }

    protected static void info(String message) {
        if (MessageHandler.compareLevel(Level.INFO)) {
            l.info(MessageHandler.addPrefix(message));
        }
    }

    protected static void warning(String message) {
        if (MessageHandler.compareLevel(Level.WARNING)) {
            l.warning(MessageHandler.addPrefix(message));
        }
    }

    protected static void broadcast(String message) {
        server.broadcastMessage(MessageHandler.addPrefix(BROADCAST_COLOR + message));
    }

    protected static void broadcast(Player p, String message) {
        p.sendMessage(MessageHandler.addPrefix(BROADCAST_COLOR + message));
    }

    public static String addPrefix(String prefix, String message) {
        return prefix + message;
    }

    public static void setLogLevel(Level loglevel) {
        logLevel = loglevel;
    }

    public static boolean setLogLevel(String loglevel) {
        try {
            Level level = Level.parse(loglevel);
            MessageHandler.setLogLevel(level);
            return true;
        }
        catch (Exception e) {
            MessageHandler.warning("Failed to parse log-level, using default.");
            return false;
        }
    }

    private static String addPrefix(String message) {
        if (logLevel == Level.FINEST) {
            return "[BackupPlugin] (" + MessageHandler.getCallingClassName(4) + ") " + message;
        }
        return "[BackupPlugin]  " + message;
    }

    private static boolean compareLevel(Level arg0) {
        return arg0.intValue() >= logLevel.intValue();
    }

    private static String getCallingClassName(int grade) {
        String className = Thread.currentThread().getStackTrace()[grade].getClassName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    protected static void setServer(Server instance) {
        server = instance;
    }

    static {
        l = Logger.getLogger("Minecraft");
        BROADCAST_COLOR = ChatColor.GREEN;
        logLevel = Level.INFO;
    }
}

