/*
 * Decompiled with CFR 0.152.
 */
package com.mysticx.bukkit.backupplugin;

import com.mysticx.bukkit.backupplugin.CacheControl;
import com.mysticx.bukkit.backupplugin.IOHelper;
import com.mysticx.bukkit.backupplugin.MessageHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.logging.Level;
import org.bukkit.Server;

public abstract class PluginUnit
extends Observable
implements Runnable {
    protected String name;
    protected CacheControl cc = CacheControl.getInstance();
    protected Server server;
    protected IOHelper iohelper;
    protected File workPath;
    protected boolean isEnabled;
    protected boolean isForce;
    protected boolean initialForce;

    public PluginUnit(Server instance, File workdir) {
        this.server = instance;
        this.iohelper = IOHelper.getInstance();
        this.isEnabled = true;
        this.isForce = false;
        this.initialForce = false;
        this.workPath = workdir;
    }

    public PluginUnit(Server instance, File workdir, boolean force) {
        this.server = instance;
        this.iohelper = IOHelper.getInstance();
        this.isEnabled = true;
        this.isForce = force;
        this.initialForce = force;
        this.workPath = workdir;
    }

    public final String getName() {
        return this.name;
    }

    public final void setWorkDir(File workPath) {
        this.workPath = workPath;
    }

    protected final File getWorkDir() {
        return this.workPath;
    }

    protected final int calculateTimeDifference(long start, long end) {
        Long time = (end - start) / 1000L;
        return time.intValue();
    }

    public final String generateFilename(String suffix) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmssSSSS");
        String time = sdf.format(new Date(System.currentTimeMillis()));
        String worldname = this.cc.getWorld().getName().replaceAll(" ", "");
        String filename = worldname + "_" + time + suffix;
        MessageHandler.log(Level.FINEST, "Generated filename: " + filename);
        return filename;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean isForce() {
        return this.isForce;
    }

    public final void setEnabled(boolean bool) {
        this.isEnabled = bool;
        if (bool) {
            this.notifyAll();
        }
    }

    public final void setForce(boolean bool) {
        this.isForce = bool;
    }

    protected final void sleepaWhile(long millis) {
        try {
            MessageHandler.log(Level.FINE, this.getName() + " going to sleep for " + millis / 1000L + " seconds..");
            Thread.sleep(millis);
            MessageHandler.log(Level.FINE, this.getName() + " woke up from sleep as expected.");
        }
        catch (InterruptedException e) {
            MessageHandler.log(Level.WARNING, this.getName() + "woke up too early!", e);
        }
    }

    public final void resetForce() {
        MessageHandler.log(Level.FINE, "Resetting force to " + this.initialForce);
        this.isForce = this.initialForce;
    }

    @Override
    public abstract void run();

    public final void run(boolean force) {
        boolean oldforce = this.isForce();
        this.setForce(force);
        this.run();
        this.setForce(oldforce);
    }
}

