/*
 * Decompiled with CFR 0.152.
 */
package fr.crafter.tickleman.RealPlugin;

import fr.crafter.tickleman.RealPlugin.RealTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class RealTranslationFile {
    private final String fileName;
    private HashMap<String, String> translations = new HashMap();
    private final JavaPlugin plugin;

    public RealTranslationFile(JavaPlugin plugin) {
        this(plugin, "en");
    }

    public RealTranslationFile(JavaPlugin plugin, String fileName) {
        this.plugin = plugin;
        this.fileName = fileName;
    }

    public RealTranslationFile load() {
        this.translations.clear();
        RealTools.renameFile("plugins/" + this.plugin.getDescription().getName() + "/" + this.fileName + ".lang", "plugins/" + this.plugin.getDescription().getName() + "/" + this.fileName + ".lang.txt");
        if (!RealTools.fileExists("plugins/" + this.plugin.getDescription().getName() + "/" + this.fileName + ".lang.txt")) {
            RealTools.extractDefaultFile(this.plugin, String.valueOf(this.fileName) + ".lang.txt");
        }
        try {
            String buffer;
            BufferedReader reader = new BufferedReader(new FileReader("plugins/" + this.plugin.getDescription().getName() + "/" + this.fileName + ".lang.txt"));
            while ((buffer = reader.readLine()) != null) {
                StringTokenizer line;
                if (buffer.length() <= 0 || buffer.charAt(0) == '#' || (line = new StringTokenizer(buffer, "=")).countTokens() < 2) continue;
                String key = line.nextToken();
                String value = line.nextToken();
                if (key.equals("") || value.equals("")) continue;
                this.translations.put(key, value);
            }
            reader.close();
        }
        catch (Exception e) {
            if (this.fileName.equals("en")) {
                this.plugin.getServer().getLogger().log(Level.INFO, "You can create plugins/" + this.plugin.getDescription().getName() + "/" + this.fileName + ".lang.txt file" + " to change texts");
            }
            this.plugin.getServer().getLogger().log(Level.WARNING, "Needs plugins/" + this.plugin.getDescription().getName() + "/" + this.fileName + ".lang.txt file" + " (check your language configuration)");
        }
        return this;
    }

    public String tr(String text) {
        String translated = this.translations.get(text);
        if (translated == null || translated.equals("")) {
            return text;
        }
        return translated;
    }
}

