/*
 * Decompiled with CFR 0.152.
 */
package fr.crafter.tickleman.RealTeleporter;

public class RealTeleporter {
    public String name;
    public String worldName;
    public long x;
    public long y;
    public long z;
    public String targetName;
    public char direction;
    public RealTeleporter target = null;

    public RealTeleporter(String name, String worldName, long x, long y, long z, float yaml) {
        this.name = name;
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.targetName = "";
        this.direction = RealTeleporter.yamlToDirection(yaml);
    }

    public RealTeleporter(String name, String worldName, long x, long y, long z, String targetName, char direction) {
        this.name = name;
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.targetName = targetName;
        this.direction = direction;
    }

    public String getLocationKey() {
        return String.valueOf(this.worldName) + ";" + this.x + ";" + this.y + ";" + this.z;
    }

    public void setTarget(RealTeleporter target) {
        this.targetName = target == null ? "" : target.name;
        this.target = target;
    }

    public String toString() {
        String targetText = this.target != null ? " target " + this.target.name : "";
        return String.valueOf(this.name) + " (" + this.worldName + "," + this.x + "," + this.y + "," + this.z + ")" + " target name " + this.targetName + targetText;
    }

    public static char yamlToDirection(float yaml) {
        int direction = (yaml = (float)Math.round((yaml % 360.0f + 360.0f) % 360.0f)) < 45.0f ? 87 : (yaml < 135.0f ? 78 : (yaml < 225.0f ? 69 : (yaml < 315.0f ? 83 : 87)));
        return (char)direction;
    }
}

