/*
 * Decompiled with CFR 0.152.
 */
package fr.crafter.tickleman.RealTeleporter;

import fr.crafter.tickleman.RealTeleporter.RealTeleporter;
import fr.crafter.tickleman.RealTeleporter.RealTeleporterPlugin;
import java.util.Date;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerMoveEvent;

public class RealTeleporterPlayerListener
extends PlayerListener {
    private final RealTeleporterPlugin plugin;
    private long nextCheck = 0L;

    public RealTeleporterPlayerListener(RealTeleporterPlugin instance) {
        this.plugin = instance;
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        long time = new Date().getTime();
        if (time > this.nextCheck) {
            this.nextCheck = time + 100L;
            Player player = event.getPlayer();
            String playerName = player.getName();
            RealTeleporter teleporter = this.plugin.teleporters.teleporterAt(player);
            if (teleporter != null && teleporter.target != null) {
                Location playerLocation = player.getLocation();
                String key = String.valueOf(playerLocation.getWorld().getName()) + ";" + Math.round(Math.floor(playerLocation.getX())) + ";" + Math.round(Math.floor(playerLocation.getY())) + ";" + Math.round(Math.floor(playerLocation.getZ()));
                if (!key.equals(this.plugin.playerLocation.get(playerName))) {
                    this.plugin.playerLocation.put(playerName, key);
                    RealTeleporter target = teleporter.target;
                    for (World world : this.plugin.getServer().getWorlds()) {
                        float yaw;
                        if (!world.getName().equals(target.worldName)) continue;
                        switch (target.direction) {
                            case 'E': {
                                yaw = 180.0f;
                                break;
                            }
                            case 'S': {
                                yaw = 270.0f;
                                break;
                            }
                            case 'W': {
                                yaw = 0.0f;
                                break;
                            }
                            default: {
                                yaw = 90.0f;
                            }
                        }
                        Location location = new Location(world, (double)target.x + 0.5, (double)target.y, (double)target.z + 0.5, yaw, 0.0f);
                        this.plugin.log.info("<" + playerName + "> from " + teleporter.name + " to " + target.name + " (" + target.worldName + "," + target.x + "," + target.y + "," + target.z + "," + yaw + ")");
                        player.teleport(location);
                        event.setTo(location);
                        this.plugin.playerLocation.put(playerName, String.valueOf(target.worldName) + ";" + target.x + ";" + target.y + ";" + target.z);
                    }
                }
            } else if (this.plugin.playerLocation.get(playerName) != null) {
                this.plugin.playerLocation.remove(playerName);
            }
        }
    }
}

