/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BetterConfig;
import me.taylorkelly.bigbrother.PropertiesFile;
import me.taylorkelly.bigbrother.Watcher;
import me.taylorkelly.util.TimeParser;
import org.bukkit.Server;

public class BBSettings {
    public static boolean blockBreak;
    public static boolean blockPlace;
    public static boolean teleport;
    public static boolean chestChanges;
    public static boolean commands;
    public static boolean chat;
    public static boolean disconnect;
    public static boolean login;
    public static boolean doorOpen;
    public static boolean buttonPress;
    public static boolean leverSwitch;
    public static boolean leafDrops;
    public static boolean fire;
    public static boolean tntExplosions;
    public static boolean creeperExplosions;
    public static boolean miscExplosions;
    public static boolean ipPlayer;
    public static boolean lavaFlow;
    public static boolean libraryAutoDownload;
    public static boolean debugMode;
    public static boolean restoreFire;
    public static boolean autoWatch;
    public static boolean flatLog;
    public static boolean mysqlLowPrioInserts;
    public static int defaultSearchRadius;
    public static DBMS databaseSystem;
    public static String mysqlUser;
    public static String mysqlPass;
    public static String mysqlHost;
    public static int mysqlPort;
    public static String mysqlEngine;
    public static String mysqlPrefix;
    public static String mysqlDatabase;
    public static String mysqlDSN;
    public static boolean mysqlPersistant;
    public static int sendDelay;
    public static int stickItem;
    public static long cleanseAge;
    public static long maxRecords;
    public static long deletesPerCleansing;
    private static ArrayList<String> watchList;
    private static ArrayList<String> seenList;
    public static int rollbacksPerTick;

    public static void initialize(File dataFolder) {
        watchList = new ArrayList();
        seenList = new ArrayList();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        File yml = new File(dataFolder, "BigBrother.yml");
        BBLogging.debug("Path to BigBrother.yml: " + yml.getPath());
        File bbprops = new File(dataFolder, "BigBrother.properties");
        if (!yml.exists() && bbprops.exists()) {
            BBLogging.info("Importing properties files to new configuration file!");
            File watching = new File(dataFolder, "watching.properties");
            BBSettings.convertPropFile(bbprops, watching, yml);
            bbprops.delete();
            watching.delete();
        }
        BBSettings.loadLists(dataFolder);
        BBSettings.loadYaml(yml);
        BBLogging.debug("Loaded Settings");
    }

    private static void loadYaml(File yamlfile) {
        BetterConfig yml = new BetterConfig(yamlfile);
        yml.load();
        BBSettings.loadDBSettings(yml);
        BBSettings.loadWatchSettings(yml);
        stickItem = yml.getInt("general.stick-item", 280);
        restoreFire = yml.getBoolean("general.restore-fire", false);
        autoWatch = yml.getBoolean("general.auto-watch", true);
        defaultSearchRadius = yml.getInt("general.default-search-radius", 2);
        flatLog = yml.getBoolean("general.personal-log-files", false);
        rollbacksPerTick = yml.getInt("general.rollbacks-per-tick", 2000);
        debugMode = yml.getBoolean("general.debug-mode", false);
        libraryAutoDownload = yml.getBoolean("general.library-autodownload", true);
        yml.save();
    }

    private static void loadWatchSettings(BetterConfig watched) {
        blockBreak = watched.getBoolean("watched.blocks.block-break", true);
        blockPlace = watched.getBoolean("watched.blocks.block-place", true);
        teleport = watched.getBoolean("watched.player.teleport", true);
        chestChanges = watched.getBoolean("watched.blocks.chest-changes", true);
        commands = watched.getBoolean("watched.chat.commands", true);
        chat = watched.getBoolean("watched.chat.chat", true);
        login = watched.getBoolean("watched.player.login", true);
        disconnect = watched.getBoolean("watched.player.disconnect", true);
        doorOpen = watched.getBoolean("watched.misc.door-open", false);
        buttonPress = watched.getBoolean("watched.misc.button-press", false);
        leverSwitch = watched.getBoolean("watched.misc.lever-switch", false);
        fire = watched.getBoolean("watched.misc.flint-logging", true);
        leafDrops = watched.getBoolean("watched.environment.leaf-decay", false);
        tntExplosions = watched.getBoolean("watched.explosions.tnt", true);
        creeperExplosions = watched.getBoolean("watched.explosions.creeper", true);
        miscExplosions = watched.getBoolean("watched.explosions.misc", true);
        ipPlayer = watched.getBoolean("watched.player.ip-player", true);
        lavaFlow = watched.getBoolean("watched.environment.lava-flow", false);
    }

    private static void loadDBSettings(BetterConfig yml) {
        String dbms = yml.getString("database.type", DBMS.MYSQL.name());
        BBSettings.setDBMS(dbms);
        deletesPerCleansing = Long.valueOf(yml.getString("database.deletes-per-cleansing", Long.toString(deletesPerCleansing)));
        cleanseAge = TimeParser.parseInterval(yml.getString("database.cleanse-age", "3d"));
        maxRecords = Long.valueOf(yml.getString("database.max-records", Long.toString(maxRecords)));
        sendDelay = yml.getInt("database.send-delay", sendDelay);
        if (databaseSystem == DBMS.MYSQL) {
            mysqlUser = yml.getString("database.mysql.username", mysqlUser);
            mysqlPass = yml.getString("database.mysql.password", mysqlPass);
            mysqlHost = yml.getString("database.mysql.hostname", mysqlHost);
            mysqlDatabase = yml.getString("database.mysql.database", mysqlDatabase);
            mysqlPort = yml.getInt("database.mysql.port", mysqlPort);
            mysqlEngine = yml.getString("database.mysql.engine", mysqlEngine);
            mysqlPrefix = yml.getString("database.mysql.prefix", mysqlPrefix);
            mysqlLowPrioInserts = yml.getBoolean("database.mysql.low-priority-insert", mysqlLowPrioInserts);
        } else if (databaseSystem == DBMS.SQLITE) {
            // empty if block
        }
    }

    private static void setDBMS(String name) {
        databaseSystem = DBMS.valueOf(name.toUpperCase());
    }

    private static void convertPropFile(File props, File watching, File yamlfile) {
        String dbms;
        PropertiesFile watchingPf = new PropertiesFile(watching);
        PropertiesFile propsPf = new PropertiesFile(props);
        BetterConfig yml = new BetterConfig(yamlfile);
        yml.load();
        stickItem = yml.getInt("general.stick-item", propsPf.getInt("stickItem", 280, "The item used for /bb stick"));
        restoreFire = yml.getBoolean("general.restore-fire", propsPf.getBoolean("restoreFire", false, "Restore fire when rolling back"));
        autoWatch = yml.getBoolean("general.auto-watch", propsPf.getBoolean("autoWatch", true, "Automatically start watching players"));
        defaultSearchRadius = yml.getInt("general.default-search-radius", propsPf.getInt("defaultSearchRadius", 2, "Default search radius for bbhere and bbfind"));
        flatLog = yml.getBoolean("general.personal-log-files", propsPf.getBoolean("flatFileLogs", false, "If true, will also log actions to .logs (one for each player)"));
        if (propsPf.getBoolean("MySQL", true, "If true, uses MySQL. If false, uses Sqlite")) {
            dbms = yml.getString("database.type", DBMS.MYSQL.name());
            BBSettings.setDBMS(dbms);
        } else {
            dbms = yml.getString("database.type", DBMS.SQLITE.name());
            BBSettings.setDBMS(dbms);
        }
        deletesPerCleansing = Long.valueOf(yml.getString("database.deletes-per-cleansing", Long.toString(propsPf.getLong("deletesPerCleansing", 1000L, "The maximum number of records to delete per cleansing (0 to disable)."))));
        cleanseAge = TimeParser.parseInterval(yml.getString("database.cleanse-age", "3d"));
        maxRecords = Long.valueOf(yml.getString("database.max-records", Long.toString(3000000L)));
        sendDelay = yml.getInt("database.send-delay", propsPf.getInt("send-delay", 4, "Delay in seconds to batch send updates to database (4-5 recommended)"));
        if (databaseSystem == DBMS.MYSQL) {
            mysqlUser = yml.getString("database.mysql.username", propsPf.getString("mysqlUser", "root", "Username for MySQL db (if applicable)"));
            mysqlPass = yml.getString("database.mysql.password", propsPf.getString("mysqlPass", "root", "Password for MySQL db (if applicable)"));
            String fullDSN = propsPf.getString("mysqlDB", "jdbc:mysql://localhost:3306/minecraft", "DB for MySQL (if applicable)");
            if ((fullDSN = fullDSN.substring(13)).split(":").length == 2) {
                mysqlHost = yml.getString("database.mysql.hostname", fullDSN.split(":")[0]);
                if (fullDSN.split(":")[1].split("/").length == 2) {
                    mysqlDatabase = yml.getString("database.mysql.database", fullDSN.split(":")[1].split("/")[1]);
                    mysqlPort = yml.getInt("database.mysql.port", Integer.parseInt(fullDSN.split(":")[1].split("/")[0]));
                } else {
                    mysqlDatabase = yml.getString("database.mysql.database", mysqlDatabase);
                    mysqlPort = yml.getInt("database.mysql.port", mysqlPort);
                }
            } else {
                mysqlHost = yml.getString("database.mysql.hostname", mysqlHost);
                mysqlDatabase = yml.getString("database.mysql.database", mysqlDatabase);
                mysqlPort = yml.getInt("database.mysql.port", mysqlPort);
            }
            mysqlEngine = yml.getString("database.mysql.engine", mysqlEngine);
            mysqlLowPrioInserts = yml.getBoolean("database.mysql.low-priority-insert", mysqlLowPrioInserts);
        }
        blockBreak = yml.getBoolean("watched.blocks.block-break", watchingPf.getBoolean("blockBreak", true, "Watch when players break blocks"));
        blockPlace = yml.getBoolean("watched.blocks.block-place", watchingPf.getBoolean("blockPlace", true, "Watch when players place blocks"));
        teleport = yml.getBoolean("watched.player.teleport", watchingPf.getBoolean("teleport", true, "Watch when players teleport around"));
        chestChanges = yml.getBoolean("watched.blocks.chest-changes", watchingPf.getBoolean("chestChanges", true, "Watch when players add/remove items from chests"));
        commands = yml.getBoolean("watched.chat.commands", watchingPf.getBoolean("commands", true, "Watch for all player commands"));
        chat = yml.getBoolean("watched.chat.chat", watchingPf.getBoolean("chat", true, "Watch for player chat"));
        login = yml.getBoolean("watched.player.login", watchingPf.getBoolean("login", true, "Watch for player logins"));
        disconnect = yml.getBoolean("watched.player.disconnect", watchingPf.getBoolean("disconnect", true, "Watch for player disconnects"));
        doorOpen = yml.getBoolean("watched.misc.door-open", watchingPf.getBoolean("doorOpen", false, "Watch for when player opens doors"));
        buttonPress = yml.getBoolean("watched.misc.button-press", watchingPf.getBoolean("buttonPress", false, "Watch for when player pushes buttons"));
        leverSwitch = yml.getBoolean("watched.misc.lever-switch", watchingPf.getBoolean("leverSwitch", false, "Watch for when player switches levers"));
        fire = yml.getBoolean("watched.misc.flint-logging", watchingPf.getBoolean("fireLogging", true, "Watch for when players start fires"));
        leafDrops = yml.getBoolean("watched.environment.leaf-decay", watchingPf.getBoolean("leafDrops", false, "Watch for when leaves drop"));
        tntExplosions = yml.getBoolean("watched.explosions.tnt", watchingPf.getBoolean("tntExplosions", true, "Watch for when TNT explodes"));
        creeperExplosions = yml.getBoolean("watched.explosions.creeper", watchingPf.getBoolean("creeperExplosions", true, "Watch for when Creepers explodes"));
        miscExplosions = yml.getBoolean("watched.explosions.misc", watchingPf.getBoolean("miscExplosions", true, "Watch for miscellaneous explosions"));
        ipPlayer = yml.getBoolean("watched.player.ip-player", watchingPf.getBoolean("ipPlayer", true, "Add player's IP when login"));
        lavaFlow = yml.getBoolean("watched.environment.lava-flow", watchingPf.getBoolean("lavaFlow", false, "Log lava flow (useful for rolling-back lava)"));
        yml.save();
    }

    private static void loadLists(File dataFolder) {
        String player;
        Scanner sc;
        File file = new File(dataFolder, "WatchedPlayers.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            sc = new Scanner(file);
            while (sc.hasNextLine()) {
                player = sc.nextLine();
                if (player.equals("") || player.contains(" ")) continue;
                watchList.add(player);
            }
        }
        catch (FileNotFoundException e) {
            BBLogging.severe("Cannot read file " + file.getName());
        }
        catch (IOException e) {
            BBLogging.severe("IO Exception with file " + file.getName());
        }
        file = new File(dataFolder, "SeenPlayers.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            sc = new Scanner(file);
            while (sc.hasNextLine()) {
                player = sc.nextLine();
                if (player.equals("") || player.contains(" ")) continue;
                seenList.add(player);
            }
        }
        catch (FileNotFoundException e) {
            BBLogging.severe("Cannot read file " + file.getName());
        }
        catch (IOException e) {
            BBLogging.severe("IO Exception with file " + file.getName());
        }
    }

    public static Watcher getWatcher(Server server, File dataFolder) {
        return new Watcher(watchList, seenList, server, dataFolder);
    }

    public static boolean usingDBMS(DBMS system) {
        return databaseSystem == system;
    }

    public static String getDSN() {
        if (BBSettings.usingDBMS(DBMS.MYSQL)) {
            return String.format("jdbc:mysql://%s:%d/%s", mysqlHost, mysqlPort, mysqlDatabase);
        }
        if (BBSettings.usingDBMS(DBMS.SQLITE)) {
            return "jdbc:sqlite:plugins" + File.separator + "BigBrother" + File.separator + "bigbrother.db";
        }
        return "";
    }

    static {
        restoreFire = false;
        autoWatch = true;
        flatLog = false;
        mysqlLowPrioInserts = true;
        defaultSearchRadius = 2;
        databaseSystem = DBMS.SQLITE;
        mysqlUser = "minecraft";
        mysqlPass = "";
        mysqlHost = "localhost";
        mysqlPort = 3306;
        mysqlEngine = "MyISAM";
        mysqlPrefix = "";
        mysqlDatabase = "minecraft";
        mysqlDSN = "jdbc:mysql://localhost:3306/minecraft";
        mysqlPersistant = true;
        sendDelay = 4;
        stickItem = 280;
        cleanseAge = TimeParser.parseInterval("3d");
        maxRecords = 3000000L;
        deletesPerCleansing = 20000L;
    }

    public static enum DBMS {
        SQLITE,
        MYSQL;

    }
}

