/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.BigBrother;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.util.Time;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Cleanser {
    private static CleanupThread cleanupThread = null;

    static boolean needsCleaning() {
        return BBSettings.cleanseAge != -1L || BBSettings.maxRecords != -1L;
    }

    public static void clean(Player player) {
        if (cleanupThread != null && cleanupThread.done) {
            cleanupThread = null;
        }
        if (cleanupThread == null || !cleanupThread.isAlive()) {
            cleanupThread = new CleanupThread(player);
            cleanupThread.start();
        } else if (player != null) {
            player.chat(BigBrother.premessage + " Cleaner already busy.  Try again later.");
        }
    }

    public static void initialize(BigBrother bigbrother) {
        bigbrother.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)bigbrother, (Runnable)new CleanupTask(), 50L, 26000L);
    }

    private static class CleanupThread
    extends Thread {
        private long cleanedSoFarAge = 0L;
        private long cleanedSoFarNumber = 0L;
        private boolean done = false;
        private final Player player;

        public CleanupThread(Player p) {
            this.player = p;
            this.setName("Cleanser");
        }

        @Override
        public void run() {
            BBLogging.info("Starting Cleanser thread...");
            if (BBSettings.cleanseAge != -1L) {
                this.cleanByAge();
            }
            if (BBSettings.maxRecords != -1L) {
                // empty if block
            }
            BBLogging.info("Ending Cleanser thread...");
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanByAge() {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = ConnectionManager.getConnection();
                stmt = conn.createStatement();
                long start = System.currentTimeMillis() / 1000L;
                String cleansql = "DELETE FROM `bbdata` WHERE date < " + Long.valueOf(Time.ago(BBSettings.cleanseAge));
                if (BBSettings.deletesPerCleansing > 0L && !BBSettings.usingDBMS(BBSettings.DBMS.SQLITE)) {
                    cleansql = cleansql + " LIMIT " + Long.valueOf(BBSettings.deletesPerCleansing);
                }
                cleansql = cleansql + ";";
                this.cleanedSoFarAge = stmt.executeUpdate(cleansql);
                String timespent = Time.formatDuration(System.currentTimeMillis() / 1000L - start);
                String words = String.format("Cleaned out %d records because of age in %s.", this.cleanedSoFarAge, timespent);
                if (this.player == null) {
                    BBLogging.info(words);
                } else {
                    Player player = this.player;
                    synchronized (player) {
                        this.player.sendMessage(ChatColor.BLUE + words);
                    }
                }
                conn.commit();
            }
            catch (SQLException ex) {
                BBLogging.severe("Cleanse SQL exception (by age)", ex);
            }
            finally {
                ConnectionManager.cleanup("Cleanse (by age)", conn, stmt, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanByNumber() {
            if (BBSettings.usingDBMS(BBSettings.DBMS.MYSQL)) {
                if (BBSettings.maxRecords < 0L) {
                    BBLogging.info("Skipping; max-records is negative.");
                    return;
                }
                Connection conn = null;
                Statement stmt = null;
                try {
                    conn = ConnectionManager.getConnection();
                    stmt = conn.createStatement();
                    long start = System.currentTimeMillis() / 1000L;
                    String cleansql = "DELETE FROM `bbdata` LEFT OUTER JOIN (SELECT `id` FROM `bbdata` ORDER BY `id` DESC LIMIT 0," + Long.valueOf(BBSettings.maxRecords) + ") AS `savedValues` ON `savedValues`.`id`=`bbdata`.`id` WHERE `savedValues`.`id` IS NULL";
                    System.out.println(cleansql);
                    if (BBSettings.deletesPerCleansing > 0L) {
                        cleansql = cleansql + " LIMIT " + Long.valueOf(BBSettings.deletesPerCleansing);
                    }
                    cleansql = cleansql + ";";
                    this.cleanedSoFarNumber = stmt.executeUpdate(cleansql);
                    String timespent = Time.formatDuration(System.currentTimeMillis() / 1000L - start);
                    String words = String.format("Cleaned out %d records because of number in %s.", this.cleanedSoFarNumber, timespent);
                    if (this.player == null) {
                        BBLogging.info(words);
                    } else {
                        Player player = this.player;
                        synchronized (player) {
                            this.player.sendMessage(ChatColor.BLUE + words);
                        }
                    }
                    conn.commit();
                    return;
                }
                catch (SQLException ex) {
                    BBLogging.severe("Cleanse SQL exception (by #)", ex);
                    if (this.player == null) return;
                    Player player = this.player;
                    synchronized (player) {
                        this.player.sendMessage(ChatColor.RED + "Action failed, read server log for the gory details.");
                        return;
                    }
                }
                finally {
                    ConnectionManager.cleanup("Cleanse (by #)", conn, stmt, null);
                }
            }
            String words = "SQLite can't cleanse by # of records.";
            if (this.player == null) {
                BBLogging.info(words);
                return;
            }
            Player player = this.player;
            synchronized (player) {
                this.player.sendMessage(ChatColor.RED + words);
                return;
            }
        }
    }

    private static class CleanupTask
    implements Runnable {
        private CleanupTask() {
        }

        @Override
        public void run() {
            Cleanser.clean(null);
        }
    }
}

