/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import me.taylorkelly.bigbrother.BBLogging;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class Watcher {
    private ArrayList<String> watchList;
    private ArrayList<String> seenList;
    private Server server;
    private File dataFolder;

    public Watcher(ArrayList<String> watchList, ArrayList<String> seenList, Server server, File dataFolder) {
        this.watchList = watchList;
        this.seenList = seenList;
        this.server = server;
        this.dataFolder = dataFolder;
    }

    public boolean watching(Player player) {
        return this.watchList.contains(player.getName());
    }

    public boolean toggleWatch(String player) {
        boolean watching = false;
        if (this.watchList.contains(player)) {
            this.watchList.remove(player);
            this.saveWatchList();
        } else {
            this.watchPlayer(player);
            watching = true;
        }
        return watching;
    }

    public String getWatchedPlayers() {
        StringBuilder list = new StringBuilder();
        for (String name : this.watchList) {
            list.append(name);
            list.append(", ");
        }
        if (list.toString().contains(",")) {
            list.delete(list.lastIndexOf(","), list.length());
        }
        return list.toString();
    }

    public boolean haveSeen(Player player) {
        return this.seenList.contains(player.getName());
    }

    public void markSeen(Player player) {
        if (!this.seenList.contains(player.getName())) {
            this.seenList.add(player.getName());
            this.saveSeenList();
        }
    }

    public void watchPlayer(Player player) {
        this.watchPlayer(player.getName());
    }

    public void watchPlayer(String player) {
        if (!this.watchList.contains(player)) {
            this.watchList.add(player);
            this.saveWatchList();
        }
    }

    public String getUnwatchedPlayers() {
        Player[] playerList = this.server.getOnlinePlayers();
        StringBuilder list = new StringBuilder();
        for (Player player : playerList) {
            if (this.watchList.contains(player.getName())) continue;
            list.append(player.getName());
            list.append(", ");
        }
        if (list.toString().contains(",")) {
            list.delete(list.lastIndexOf(","), list.length());
        }
        return list.toString();
    }

    private void saveWatchList() {
        this.store("WatchedPlayers.txt", this.watchList);
    }

    private void saveSeenList() {
        this.store("SeenPlayers.txt", this.seenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(String fileName, ArrayList<String> playerList) {
        File file = new File(this.dataFolder, fileName);
        BufferedWriter bwriter = null;
        FileWriter fwriter = null;
        try {
            fwriter = new FileWriter(file);
            bwriter = new BufferedWriter(fwriter);
            for (String name : playerList) {
                bwriter.write(name);
                bwriter.newLine();
            }
            bwriter.flush();
        }
        catch (IOException e) {
            BBLogging.severe("IO Exception (" + fileName + ")");
        }
        finally {
            try {
                if (bwriter != null) {
                    bwriter.flush();
                    bwriter.close();
                }
                if (fwriter != null) {
                    fwriter.close();
                }
            }
            catch (IOException e) {
                BBLogging.severe("IO Exception (on close) (" + fileName + ")");
            }
        }
    }
}

