/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.datablock;

import java.util.ArrayList;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;

public class PlacedBlock
extends BBDataBlock {
    private ArrayList<BBDataBlock> bystanders;

    public PlacedBlock(String player, Block block, String world) {
        super(player, BBDataBlock.Action.BLOCK_PLACED, world, block.getX(), block.getY(), block.getZ(), block.getTypeId(), Byte.toString(block.getData()));
        this.bystanders = new ArrayList();
    }

    public PlacedBlock(String player, String world, int x, int y, int z, int type, byte data) {
        super(player, BBDataBlock.Action.BLOCK_PLACED, world, x, y, z, type, Byte.toString(data));
        this.bystanders = new ArrayList();
    }

    @Override
    public void send() {
        for (BBDataBlock block : this.bystanders) {
            block.send();
        }
        super.send();
    }

    private PlacedBlock(String player, String world, int x, int y, int z, int type, String data) {
        super(player, BBDataBlock.Action.BLOCK_PLACED, world, x, y, z, type, data);
    }

    @Override
    public void rollback(Server server) {
        World currWorld = server.getWorld(this.world);
        if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
            currWorld.loadChunk(this.x >> 4, this.z >> 4);
        }
        currWorld.getBlockAt(this.x, this.y, this.z).setTypeId(0);
    }

    @Override
    public void redo(Server server) {
        if (this.type != 51 || BBSettings.restoreFire) {
            World currWorld = server.getWorld(this.world);
            if (!currWorld.isChunkLoaded(this.x >> 4, this.z >> 4)) {
                currWorld.loadChunk(this.x >> 4, this.z >> 4);
            }
            byte blockData = Byte.parseByte(this.data);
            currWorld.getBlockAt(this.x, this.y, this.z).setTypeId(this.type);
            currWorld.getBlockAt(this.x, this.y, this.z).setData(blockData);
        }
    }

    public static BBDataBlock getBBDataBlock(String player, String world, int x, int y, int z, int type, String data) {
        return new PlacedBlock(player, world, x, y, z, type, data);
    }
}

