/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.finder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.datablock.BBDataBlock;
import me.taylorkelly.bigbrother.datasource.DataBlockSender;
import me.taylorkelly.bigbrother.finder.BlockHistory;
import me.taylorkelly.bigbrother.finder.StickMode;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HistoryLog
extends StickMode {
    private ItemStack oldItem;
    private int slot;

    @Override
    public void initialize(Player player) {
        this.slot = player.getInventory().getHeldItemSlot();
        this.oldItem = player.getInventory().getItem(this.slot);
        if (this.oldItem != null && this.oldItem.getAmount() > 0) {
            player.sendMessage(ChatColor.AQUA + "Saving your " + this.oldItem.getType() + ".");
        }
        player.getInventory().setItem(this.slot, new ItemStack(Material.LOG, 1));
    }

    @Override
    public void disable(Player player) {
        if (this.oldItem != null && this.oldItem.getAmount() > 0) {
            player.sendMessage(ChatColor.AQUA + "Here's your " + this.oldItem.getType() + " back!");
            player.getInventory().setItem(this.slot, this.oldItem);
        } else {
            player.getInventory().clear(this.slot);
        }
    }

    @Override
    public ArrayList<String> getInfoOnBlock(Block block, WorldManager manager) {
        ArrayList<BBDataBlock> history = BlockHistory.hist(block, manager);
        ArrayList<String> msgs = new ArrayList<String>();
        if (history.isEmpty()) {
            msgs.add(ChatColor.RED + "No edits on this block");
        } else {
            msgs.add(ChatColor.AQUA.toString() + history.size() + " edits on this block");
            for (BBDataBlock dataBlock : history) {
                Calendar cal = Calendar.getInstance();
                String DATE_FORMAT = "MMM.d@'" + ChatColor.GRAY + "'kk.mm.ss";
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                cal.setTimeInMillis(dataBlock.date * 1000L);
                StringBuilder msg = new StringBuilder(sdf.format(cal.getTime()));
                msg.append(ChatColor.WHITE).append(" - ").append(ChatColor.YELLOW);
                msg.append(dataBlock.player);
                msg.append(ChatColor.WHITE);
                msg.append(" ");
                msg.append(DataBlockSender.getAction(dataBlock.action));
                if (dataBlock.type != 0) {
                    msg.append(" ");
                    msg.append(Material.getMaterial((int)dataBlock.type));
                }
                msgs.add(msg.toString());
            }
        }
        return msgs;
    }

    @Override
    public String getDescription() {
        return "History Log";
    }

    public boolean usesStick() {
        return false;
    }

    @Override
    public void update(Player player) {
        player.getInventory().setItem(this.slot, new ItemStack(Material.LOG, 1));
    }

    @Override
    public boolean usesStick(ItemStack itemStack) {
        return itemStack.getType() == Material.LOG;
    }

    @Override
    public boolean rightClickStick() {
        return false;
    }
}

