/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.fixes;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import me.taylorkelly.bigbrother.BBLogging;

public abstract class Fix {
    protected int currVersion = -1;
    protected File dataFolder;

    public Fix(File dataFolder) {
        this.dataFolder = dataFolder;
    }

    public abstract void apply();

    public boolean needsUpdate(int version) {
        if (this.currVersion == -1) {
            this.currVersion = this.getCurrVersion();
        }
        return this.currVersion < version;
    }

    private int getCurrVersion() {
        File file = new File(this.dataFolder, "VERSION");
        if (!file.exists()) {
            return 0;
        }
        try {
            Scanner scan = new Scanner(file);
            String version = scan.nextLine();
            try {
                int numVersion = Integer.parseInt(version);
                return numVersion;
            }
            catch (Exception e) {
                return 0;
            }
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateVersion(int version) {
        File file = new File(this.dataFolder, "VERSION");
        BufferedWriter bwriter = null;
        FileWriter fwriter = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fwriter = new FileWriter(file);
            bwriter = new BufferedWriter(fwriter);
            bwriter.write(version + "");
            bwriter.flush();
        }
        catch (IOException e) {
            BBLogging.severe("IO Exception with file " + file.getName());
        }
        finally {
            try {
                if (bwriter != null) {
                    bwriter.flush();
                    bwriter.close();
                }
                if (fwriter != null) {
                    fwriter.close();
                }
            }
            catch (IOException e) {
                BBLogging.severe("IO Exception with file " + file.getName() + " (on close)");
            }
        }
    }
}

