/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.fixes;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.fixes.Fix;

public class Fix3
extends Fix {
    protected int version = 3;
    public static final String UPDATE_MYSQL = "ALTER TABLE `bbdata` MODIFY `data` VARCHAR(500);";

    public Fix3(File dataFolder) {
        super(dataFolder);
    }

    @Override
    public void apply() {
        if (this.needsUpdate(this.version)) {
            boolean sqlite;
            BBLogging.info("Updating table for 1.6.2");
            boolean bl = sqlite = BBSettings.databaseSystem == BBSettings.DBMS.SQLITE;
            if (Fix3.updateTable(sqlite)) {
                this.updateVersion(this.version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateTable(boolean sqlite) {
        if (BBSettings.usingDBMS(BBSettings.DBMS.MYSQL)) {
            Connection conn = null;
            Statement st = null;
            try {
                conn = ConnectionManager.getConnection();
                st = conn.createStatement();
                st.executeUpdate(UPDATE_MYSQL);
                conn.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                BBLogging.severe("Update Table 1.6.2 Fail " + (sqlite ? " sqlite" : " mysql"), e);
                boolean bl = false;
                return bl;
            }
            finally {
                ConnectionManager.cleanup("Update Table 1.6.2", conn, st, null);
            }
        }
        return true;
    }
}

