/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.fixes;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.fixes.Fix;

public class Fix4
extends Fix {
    protected int version = 4;
    public static final String[] UPDATE_SQL = new String[]{"ALTER TABLE `bbdata` DROP INDEX `x`;", "ALTER TABLE `bbdata` DROP INDEX `y`;", "ALTER TABLE `bbdata` DROP INDEX `z`;", "ALTER TABLE `bbdata` ADD INDEX `posIndex` (`x`, `y`, `z`);"};

    public Fix4(File dataFolder) {
        super(dataFolder);
    }

    @Override
    public void apply() {
        if (this.needsUpdate(this.version)) {
            BBLogging.info("Updating table for 1.7");
            boolean sqlite = BBSettings.databaseSystem == BBSettings.DBMS.SQLITE;
            this.updateVersion(this.version);
            Fix4.updateTable(sqlite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateTable(boolean sqlite) {
        if (sqlite) {
            return true;
        }
        Connection conn = null;
        Statement st = null;
        try {
            conn = ConnectionManager.getConnection();
            st = conn.createStatement();
            for (String update : UPDATE_SQL) {
                st.executeUpdate(update);
            }
            conn.commit();
            boolean arr$ = true;
            return arr$;
        }
        catch (SQLException e) {
            BBLogging.severe("[Fix4] Unable to remove/create new indices.  However, this shouldn't be a problem except performance-wise.");
            boolean bl = false;
            return bl;
        }
        finally {
            ConnectionManager.cleanup("Fix 4", conn, st, null);
        }
    }
}

