/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.rollback;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import me.taylorkelly.bigbrother.WorldManager;
import me.taylorkelly.bigbrother.rollback.Rollback;
import me.taylorkelly.util.TimeParser;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RollbackInterpreter {
    private Rollback rollback;
    private Calendar dateSearch;
    private ArrayList<Integer> blockTypes;
    private ArrayList<String> playerList;
    private boolean all = false;
    private Server server;
    private Player player;
    private WorldManager manager;
    private int radius = 0;
    private Plugin plugin;

    public RollbackInterpreter(Player player, String[] split, Server server, WorldManager manager, Plugin plugin) {
        this.manager = manager;
        this.player = player;
        this.server = server;
        this.plugin = plugin;
        this.playerList = new ArrayList();
        this.blockTypes = new ArrayList();
        for (int i = 1; i < split.length; ++i) {
            String argument = split[i].trim();
            if (argument.equals("") || argument.equals(" ")) continue;
            if (argument.length() > 2 && argument.substring(0, 2).equalsIgnoreCase("t:")) {
                this.dateSearch = TimeParser.parseTime(argument.substring(2), player);
                continue;
            }
            if (argument.length() > 3 && argument.substring(0, 3).equalsIgnoreCase("id:")) {
                this.parseId(argument.substring(3));
                continue;
            }
            if (argument.length() > 2 && argument.substring(0, 2).equalsIgnoreCase("r:")) {
                this.parseRadius(argument.substring(2));
                continue;
            }
            if (argument.equalsIgnoreCase("*")) {
                this.all = true;
                continue;
            }
            List targets = server.matchPlayer(argument);
            Player findee = null;
            if (targets.size() == 1) {
                findee = (Player)targets.get(0);
            }
            this.playerList.add(findee == null ? argument : findee.getName());
        }
    }

    private void parseRadius(String radius) {
        try {
            int radInt = Integer.parseInt(radius);
            if (radInt <= 0) {
                this.player.sendMessage(ChatColor.RED + "Ignoring invalid radius: " + radius);
            } else {
                this.radius = radInt;
            }
        }
        catch (Exception e) {
            this.player.sendMessage(ChatColor.RED + "Ignoring invalid radius: " + radius);
        }
    }

    private void parseId(String id) {
        if (id.contains(",")) {
            String[] ids;
            for (String actId : ids = id.split(",")) {
                if (actId.equals("")) continue;
                try {
                    this.blockTypes.add(Integer.parseInt(actId));
                }
                catch (Exception e) {
                    this.player.sendMessage(ChatColor.RED + "Ignoring invalid block id: " + actId);
                }
            }
        } else {
            try {
                this.blockTypes.add(Integer.parseInt(id));
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.RED + "Ignoring invalid block id: " + id);
            }
        }
    }

    public Boolean interpret() {
        this.rollback = new Rollback(this.server, this.manager, this.plugin);
        this.rollback.addReciever(this.player);
        if (this.all) {
            this.rollback.rollbackAll();
        } else {
            if (this.playerList.isEmpty()) {
                this.player.sendMessage(ChatColor.RED + "No players marked for rollback. Cancelling rollback.");
                this.player.sendMessage(ChatColor.RED + "Use * for all players");
                return null;
            }
            this.rollback.addPlayers(this.playerList);
        }
        if (this.dateSearch != null) {
            this.rollback.setTime(this.dateSearch.getTimeInMillis() / 1000L);
        }
        if (!this.blockTypes.isEmpty()) {
            this.rollback.addTypes(this.blockTypes);
        }
        this.rollback.setRadius(this.radius, this.player.getLocation());
        if (this.radius == 0 && this.dateSearch == null) {
            return false;
        }
        return true;
    }

    public void send() {
        this.rollback.rollback();
    }
}

