/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.bigbrother.tablemgrs;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.taylorkelly.bigbrother.BBLogging;
import me.taylorkelly.bigbrother.BBSettings;
import me.taylorkelly.bigbrother.datasource.ConnectionManager;
import me.taylorkelly.bigbrother.tablemgrs.BBDataMySQL;
import me.taylorkelly.bigbrother.tablemgrs.BBDataSQLite;

public abstract class BBDataTable {
    private static BBDataTable instance = null;

    public static String getTableName() {
        return BBSettings.mysqlPrefix + "bbdata";
    }

    public static BBDataTable getInstance() {
        if (instance == null) {
            instance = BBSettings.usingDBMS(BBSettings.DBMS.MYSQL) ? new BBDataMySQL() : new BBDataSQLite();
        }
        return instance;
    }

    public BBDataTable() {
        if (!this.bbdataTableExists()) {
            BBLogging.info("Building `" + BBDataTable.getTableName() + "` table...");
            this.createBBDataTable();
        } else {
            BBLogging.debug("`" + BBDataTable.getTableName() + "` table already exists");
        }
        this.onLoad();
    }

    public abstract void onLoad();

    public abstract String getCreateSyntax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bbdataTableExists() {
        boolean bl;
        ResultSet rs;
        Connection conn;
        block5: {
            conn = null;
            rs = null;
            conn = ConnectionManager.getConnection();
            DatabaseMetaData dbm = conn.getMetaData();
            rs = dbm.getTables(null, null, BBDataTable.getTableName(), null);
            if (rs.next()) break block5;
            boolean bl2 = false;
            ConnectionManager.cleanup("Table Check", conn, null, rs);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (SQLException ex) {
            boolean bl3;
            try {
                BBLogging.severe("Couldn't check if " + BBDataTable.getTableName() + " exists!", ex);
                bl3 = false;
            }
            catch (Throwable throwable) {
                ConnectionManager.cleanup("Table Check", conn, null, rs);
                throw throwable;
            }
            ConnectionManager.cleanup("Table Check", conn, null, rs);
            return bl3;
        }
        ConnectionManager.cleanup("Table Check", conn, null, rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBBDataTable() {
        Connection conn = null;
        Statement st = null;
        try {
            conn = ConnectionManager.getConnection();
            st = conn.createStatement();
            st.executeUpdate(this.getCreateSyntax());
            conn.commit();
        }
        catch (SQLException e) {
            BBLogging.severe("Can't create the " + BBDataTable.getTableName() + " table", e);
        }
        finally {
            ConnectionManager.cleanup("Create Table", conn, st, null);
        }
    }

    public String getPreparedDataBlockStatement(Connection conn) throws SQLException {
        return "INSERT INTO " + BBDataTable.getTableName() + " (date, player, action, world, x, y, z, type, data, rbacked) VALUES (?,?,?,?,?,?,?,?,?,0)";
    }
}

