/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import me.taylorkelly.myhome.ConnectionManager;
import me.taylorkelly.myhome.Converter;
import me.taylorkelly.myhome.HomeHelp;
import me.taylorkelly.myhome.HomeList;
import me.taylorkelly.myhome.HomeLogger;
import me.taylorkelly.myhome.HomePermissions;
import me.taylorkelly.myhome.HomeSettings;
import me.taylorkelly.myhome.MHEntityListener;
import me.taylorkelly.myhome.MHPlayerListener;
import me.taylorkelly.myhome.MHPluginListener;
import me.taylorkelly.myhome.griefcraft.Updater;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MyHome
extends JavaPlugin {
    private MHPlayerListener playerListener;
    private MHEntityListener entityListener;
    private MHPluginListener pluginListener;
    private HomeList homeList;
    private boolean warning = false;
    public String name;
    public String version;
    private Updater updater;
    public PluginManager pm;

    public void onDisable() {
        this.name = this.getDescription().getName();
        this.version = this.getDescription().getVersion();
        ConnectionManager.closeConnection();
        HomeLogger.info(this.name + " " + this.version + " disabled");
    }

    public void onEnable() {
        this.pm = this.getServer().getPluginManager();
        this.name = this.getDescription().getName();
        this.version = this.getDescription().getVersion();
        HomeSettings.initialize(this.getDataFolder());
        this.libCheck();
        this.convertOldDB(this.getDataFolder());
        if (!this.sqlCheck()) {
            return;
        }
        this.homeList = new HomeList(this.getServer());
        this.playerListener = new MHPlayerListener(this.homeList, (Plugin)this);
        this.entityListener = new MHEntityListener((Plugin)this);
        this.pluginListener = new MHPluginListener();
        HomePermissions.initialize(this.getServer());
        HomeHelp.initialize((Plugin)this);
        this.pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)this.playerListener, Event.Priority.Highest, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)this.pluginListener, Event.Priority.Monitor, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLUGIN_DISABLE, (Listener)this.pluginListener, Event.Priority.Monitor, (Plugin)this);
        if (HomeSettings.loadChunks) {
            this.pm.registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (HomeSettings.abortOnDamage != 0) {
            this.pm.registerEvent(Event.Type.ENTITY_DAMAGE, (Listener)this.entityListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (HomeSettings.bedsDuringDay && HomeSettings.bedsCanSethome != 0) {
            this.pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        } else if (!HomeSettings.bedsDuringDay && HomeSettings.bedsCanSethome != 0) {
            this.pm.registerEvent(Event.Type.PLAYER_BED_LEAVE, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        }
        HomeLogger.info(this.name + " " + this.version + " enabled");
    }

    private void libCheck() {
        if (HomeSettings.downloadLibs) {
            this.updater = new Updater();
            try {
                this.updater.check();
                this.updater.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void convertOldDB(File df) {
        File newDatabase = new File(df, "homes.db");
        File oldDatabase = new File("homes-warps.db");
        if (!newDatabase.exists() && oldDatabase.exists()) {
            this.updateFiles(oldDatabase, newDatabase);
            oldDatabase.renameTo(new File("homes-warps.db.old"));
        } else if (newDatabase.exists() && oldDatabase.exists()) {
            oldDatabase.renameTo(new File("homes-warps.db.old"));
        }
    }

    private boolean sqlCheck() {
        Connection conn = ConnectionManager.initialize();
        if (conn == null) {
            HomeLogger.severe("Could not establish SQL connection. Disabling MyHome");
            this.pm.disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    private void updateFiles(File oldDatabase, File newDatabase) {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (newDatabase.exists()) {
            newDatabase.delete();
        }
        try {
            newDatabase.createNewFile();
        }
        catch (IOException ex) {
            HomeLogger.severe("Could not create new database file", ex);
        }
        MyHome.copyFile(oldDatabase, newDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File fromFile, File toFile) {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String[] split = args;
        String commandName = command.getName().toLowerCase();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (commandName.equals("sethome") && HomePermissions.set(player)) {
                if (HomeSettings.bedsCanSethome == 2 && !HomePermissions.bedBypass(player)) {
                    player.sendMessage(ChatColor.RED + "You can only set a home by sleeping in a bed");
                    return true;
                }
                if (HomeSettings.allowSetHome) {
                    this.homeList.addHome(player, (Plugin)this);
                } else {
                    player.sendMessage("Use: " + ChatColor.RED + "/home set" + ChatColor.WHITE + " to set a home");
                }
                return true;
            }
            if (commandName.equals("home") || commandName.equals("myhome") || commandName.equals("mh")) {
                if (split.length == 0 && HomePermissions.home(player)) {
                    if (this.homeList.playerHasHome(player)) {
                        this.homeList.sendPlayerHome(player, (Plugin)this);
                    } else {
                        player.sendMessage(ChatColor.RED + "You have no home :(");
                        if (HomeSettings.bedsCanSethome == 2) {
                            player.sendMessage("You need to sleep in a bed to set a home");
                        } else {
                            player.sendMessage("Use: " + ChatColor.RED + "/home set" + ChatColor.WHITE + " to set a home");
                        }
                    }
                } else if (split.length == 1 && split[0].equalsIgnoreCase("reload") && HomePermissions.adminReloadConfig(player)) {
                    HomeSettings.initialize(this.getDataFolder());
                    player.sendMessage("[MyHome] Reloading config");
                } else if (split.length == 1 && split[0].equalsIgnoreCase("convert") && HomePermissions.adminConvert(player)) {
                    if (!this.warning) {
                        player.sendMessage(ChatColor.RED + "Warning: " + ChatColor.WHITE + "Only use a copy of homes.txt.");
                        player.sendMessage("This will delete the homes.txt it uses");
                        player.sendMessage("Use " + ChatColor.RED + "'/home convert'" + ChatColor.WHITE + " again to confirm.");
                        this.warning = true;
                    } else {
                        Converter.convert(player, this.getServer(), this.homeList);
                        this.warning = false;
                    }
                } else if (split.length == 1 && split[0].equalsIgnoreCase("set") && HomePermissions.set(player)) {
                    if (HomeSettings.bedsCanSethome == 2 && !HomePermissions.bedBypass(player)) {
                        player.sendMessage("You can only set a home by sleeping in a bed");
                        return true;
                    }
                    this.homeList.addHome(player, (Plugin)this);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("delete") && HomePermissions.delete(player)) {
                    this.homeList.deleteHome(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("list") && HomePermissions.list(player)) {
                    this.homeList.list(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("ilist") && HomePermissions.list(player)) {
                    this.homeList.ilist(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("listall") && HomePermissions.adminListHome(player)) {
                    this.homeList.listall(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("private") && HomePermissions.canPrivate(player)) {
                    this.homeList.privatize(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("public") && HomePermissions.canPublic(player)) {
                    this.homeList.publicize(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("point") && HomeSettings.compassPointer) {
                    this.homeList.orientPlayer(player);
                } else if (split.length == 2 && split[0].equalsIgnoreCase("clear") && HomePermissions.adminDeleteHome(player)) {
                    this.homeList.clearHome(split[1], player);
                } else if (split.length == 2 && split[0].equalsIgnoreCase("invite") && HomePermissions.invite(player)) {
                    Player invitee = this.getServer().getPlayer(split[1]);
                    String inviteeName = invitee == null ? split[1] : invitee.getName();
                    this.homeList.invite(player, inviteeName);
                } else if (split.length == 2 && split[0].equalsIgnoreCase("uninvite") && HomePermissions.uninvite(player)) {
                    Player invitee = this.getServer().getPlayer(split[1]);
                    String inviteeName = invitee == null ? split[1] : invitee.getName();
                    this.homeList.uninvite(player, inviteeName);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("help")) {
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add(ChatColor.RED + "----- " + ChatColor.WHITE + "/HOME HELP" + ChatColor.RED + " -----");
                    if (HomePermissions.home(player)) {
                        messages.add(ChatColor.RED + "/home" + ChatColor.WHITE + "  -  Go home young chap!");
                    }
                    if (HomePermissions.set(player)) {
                        messages.add(ChatColor.RED + "/home set" + ChatColor.WHITE + "  -  Sets your home to your current position");
                    }
                    if (HomePermissions.delete(player)) {
                        messages.add(ChatColor.RED + "/home delete" + ChatColor.WHITE + "  -  Deletes your current home");
                    }
                    if (HomePermissions.homeOthers(player)) {
                        messages.add(ChatColor.RED + "/home [player]" + ChatColor.WHITE + "  -  Go to " + ChatColor.GRAY + "[player]" + ChatColor.WHITE + "'s house (if allowed)");
                    }
                    if (HomePermissions.list(player)) {
                        messages.add(ChatColor.RED + "/home list" + ChatColor.WHITE + "  -  List the homes that you are invited to");
                        messages.add(ChatColor.RED + "/home ilist" + ChatColor.WHITE + "  -  List the people invited to your home");
                    }
                    if (HomePermissions.invite(player)) {
                        messages.add(ChatColor.RED + "/home invite [player]" + ChatColor.WHITE + "  -  Invite " + ChatColor.GRAY + "[player]" + ChatColor.WHITE + " to your house");
                    }
                    if (HomePermissions.uninvite(player)) {
                        messages.add(ChatColor.RED + "/home uninvite [player]" + ChatColor.WHITE + "  -  Uninvite " + ChatColor.GRAY + "[player]" + ChatColor.WHITE + " to your house");
                    }
                    if (HomePermissions.canPublic(player)) {
                        messages.add(ChatColor.RED + "/home public" + ChatColor.WHITE + "  -  Makes your house public");
                    }
                    if (HomePermissions.canPrivate(player)) {
                        messages.add(ChatColor.RED + "/home private" + ChatColor.WHITE + "  -  Makes your house private");
                    }
                    if (HomeSettings.compassPointer) {
                        messages.add(ChatColor.RED + "/home point" + ChatColor.WHITE + "  -  Points your compass home");
                    }
                    if (HomePermissions.adminConvert(player)) {
                        messages.add(ChatColor.RED + "/home convert" + ChatColor.WHITE + "  -  Convert a homes.txt file.");
                    }
                    if (HomePermissions.adminDeleteHome(player)) {
                        messages.add(ChatColor.RED + "/home clear [playername]" + ChatColor.WHITE + "  -  Clear playername's home");
                    }
                    if (HomePermissions.adminListHome(player)) {
                        messages.add(ChatColor.RED + "/home listall" + ChatColor.WHITE + "  -  List all Homes");
                    }
                    for (String message : messages) {
                        player.sendMessage(message);
                    }
                } else if (split.length == 1 && HomePermissions.homeOthers(player)) {
                    String playerName = split[0];
                    this.homeList.warpTo(playerName, player, (Plugin)this);
                } else {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void setCompass(Player player, Location location) {
        if (HomeSettings.compassPointer) {
            player.setCompassTarget(location);
        }
    }
}

