/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import me.taylorkelly.myhome.ConnectionManager;
import me.taylorkelly.myhome.Home;
import me.taylorkelly.myhome.HomeLogger;
import me.taylorkelly.myhome.HomeSettings;

public class WarpDataSource {
    public static final String sqlitedb = "/homes.db";
    private static final String HOME_TABLE = "CREATE TABLE IF NOT EXISTS `homeTable` (`id` INTEGER PRIMARY KEY,`name` varchar(32) NOT NULL DEFAULT 'Player',`world` varchar(32) NOT NULL DEFAULT '0',`x` DOUBLE NOT NULL DEFAULT '0',`y` DOUBLE NOT NULL DEFAULT '0',`z` DOUBLE NOT NULL DEFAULT '0',`yaw` smallint NOT NULL DEFAULT '0',`pitch` smallint NOT NULL DEFAULT '0',`publicAll` boolean NOT NULL DEFAULT '0',`permissions` TEXT,`welcomeMessage` varchar(100) NOT NULL DEFAULT '');";

    public static void initialize() {
        if (!WarpDataSource.tableExists()) {
            WarpDataSource.createTable();
        }
        WarpDataSource.dbTblCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, Home> getMap() {
        HashMap<String, Home> ret = new HashMap<String, Home>();
        Statement statement = null;
        ResultSet set = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            statement = conn.createStatement();
            set = statement.executeQuery("SELECT * FROM homeTable");
            int size = 0;
            while (set.next()) {
                ++size;
                int index = set.getInt("id");
                String name = set.getString("name");
                String world = set.getString("world");
                double x = set.getDouble("x");
                double y = set.getDouble("y");
                double z = set.getDouble("z");
                int yaw = set.getInt("yaw");
                int pitch = set.getInt("pitch");
                int publicAll = set.getInt("publicAll");
                String permissions = set.getString("permissions");
                String welcomeMessage = set.getString("welcomeMessage");
                Home warp = new Home(index, name, world, x, y, z, yaw, pitch, publicAll, permissions, welcomeMessage);
                ret.put(name, warp);
            }
            HomeLogger.info(size + " homes loaded");
        }
        catch (SQLException ex) {
            HomeLogger.severe("Home Load Exception");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Home Load Exception (on close)");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists() {
        ResultSet rs = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            DatabaseMetaData dbm = conn.getMetaData();
            rs = dbm.getTables(null, null, "homeTable", null);
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            HomeLogger.severe("Table Check Exception", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Table Check SQL Exception (on closing)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTable() {
        Statement st = null;
        try {
            HomeLogger.info("Creating Database...");
            Connection conn = ConnectionManager.getConnection();
            st = conn.createStatement();
            st.executeUpdate(HOME_TABLE);
            conn.commit();
            if (HomeSettings.usemySQL) {
                String sql = "ALTER TABLE `homeTable` CHANGE `id` `id` INT NOT NULL AUTO_INCREMENT ";
                HomeLogger.info("Modifying database for MySQL support");
                st = conn.createStatement();
                st.executeUpdate(sql);
                conn.commit();
                File sqlitefile = new File(HomeSettings.dataDir.getAbsolutePath() + sqlitedb);
                if (!sqlitefile.exists()) {
                    HomeLogger.info("Could not find old /homes.db");
                    return;
                }
                HomeLogger.info("Trying to import homes from homes.db");
                Class.forName("org.sqlite.JDBC");
                Connection sqliteconn = DriverManager.getConnection("jdbc:sqlite:" + HomeSettings.dataDir.getAbsolutePath() + sqlitedb);
                sqliteconn.setAutoCommit(false);
                Statement slstatement = sqliteconn.createStatement();
                ResultSet slset = slstatement.executeQuery("SELECT * FROM homeTable");
                int size = 0;
                while (slset.next()) {
                    ++size;
                    int index = slset.getInt("id");
                    String name = slset.getString("name");
                    String world = slset.getString("world");
                    double x = slset.getDouble("x");
                    double y = slset.getInt("y");
                    double z = slset.getDouble("z");
                    int yaw = slset.getInt("yaw");
                    int pitch = slset.getInt("pitch");
                    int publicAll = slset.getInt("publicAll");
                    String permissions = slset.getString("permissions");
                    String welcomeMessage = slset.getString("welcomeMessage");
                    Home warp = new Home(index, name, world, x, y, z, yaw, pitch, publicAll, permissions, welcomeMessage);
                    WarpDataSource.addWarp(warp);
                }
                HomeLogger.info("Imported " + size + " homes from " + sqlitedb);
                HomeLogger.info("Renaming /homes.db to /homes.db.old");
                if (!sqlitefile.renameTo(new File(HomeSettings.dataDir.getAbsolutePath(), "/homes.db.old"))) {
                    HomeLogger.warning("Failed to rename /homes.db! Please rename this manually!");
                }
                if (slstatement != null) {
                    slstatement.close();
                }
                if (slset != null) {
                    slset.close();
                }
                if (sqliteconn != null) {
                    sqliteconn.close();
                }
            }
        }
        catch (SQLException e) {
            HomeLogger.severe("Create Table Exception", e);
        }
        catch (ClassNotFoundException e) {
            HomeLogger.severe("You need the SQLite library.", e);
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                HomeLogger.severe("Could not create the table (on close)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWarp(Home warp) {
        PreparedStatement ps = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("INSERT INTO homeTable (id, name, world, x, y, z, yaw, pitch, publicAll, permissions, welcomeMessage) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            ps.setInt(1, warp.index);
            ps.setString(2, warp.name);
            ps.setString(3, warp.world);
            ps.setDouble(4, warp.x);
            ps.setDouble(5, warp.y);
            ps.setDouble(6, warp.z);
            ps.setInt(7, warp.yaw);
            ps.setInt(8, warp.pitch);
            ps.setInt(9, warp.publicAll);
            ps.setString(10, warp.permissionsString());
            ps.setString(11, warp.welcomeMessage);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException ex) {
            HomeLogger.severe("Home Insert Exception", ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Home Insert Exception (on close)", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteWarp(Home warp) {
        PreparedStatement ps = null;
        ResultSet set = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("DELETE FROM homeTable WHERE id = ?");
            ps.setInt(1, warp.index);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException ex) {
            HomeLogger.severe("Home Delete Exception", ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Home Delete Exception (on close)", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publicizeWarp(Home warp, int publicAll) {
        PreparedStatement ps = null;
        ResultSet set = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("UPDATE homeTable SET publicAll = ? WHERE id = ?");
            ps.setInt(1, publicAll);
            ps.setInt(2, warp.index);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException ex) {
            HomeLogger.severe("Home Publicize Exception", ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Home Publicize Exception (on close)", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermissions(Home warp) {
        PreparedStatement ps = null;
        ResultSet set = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("UPDATE homeTable SET permissions = ? WHERE id = ?");
            ps.setString(1, warp.permissionsString());
            ps.setInt(2, warp.index);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException ex) {
            HomeLogger.severe("Home Permissions Exception", ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Home Permissions Exception (on close)", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveWarp(Home warp) {
        PreparedStatement ps = null;
        ResultSet set = null;
        try {
            Connection conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement("UPDATE homeTable SET x = ?, y = ?, z = ?, world = ?, yaw = ?, pitch = ? WHERE id = ?");
            ps.setDouble(1, warp.x);
            ps.setDouble(2, warp.y);
            ps.setDouble(3, warp.z);
            ps.setString(4, warp.world);
            ps.setInt(5, warp.yaw);
            ps.setDouble(6, warp.pitch);
            ps.setInt(7, warp.index);
            ps.executeUpdate();
            conn.commit();
        }
        catch (SQLException ex) {
            HomeLogger.severe("Home Move Exception", ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException ex) {
                HomeLogger.severe("Home Move Exception (on close)", ex);
            }
        }
    }

    public static void dbTblCheck() {
    }

    public static void updateDB(String test, String sql) {
        WarpDataSource.updateDB(test, sql, sql);
    }

    public static void updateDB(String test, String sqlite, String mysql) {
        try {
            Connection conn = ConnectionManager.getConnection();
            Statement statement = conn.createStatement();
            statement.executeQuery(test);
            statement.close();
        }
        catch (SQLException ex) {
            HomeLogger.info("Updating database");
            try {
                String[] query = HomeSettings.usemySQL ? mysql.split(";") : sqlite.split(";");
                Connection conn = ConnectionManager.getConnection();
                Statement sqlst = conn.createStatement();
                for (String qry : query) {
                    sqlst.executeUpdate(qry);
                }
                conn.commit();
                sqlst.close();
            }
            catch (SQLException exc) {
                HomeLogger.severe("Failed to update the database to the new version - ", exc);
                ex.printStackTrace();
            }
        }
    }

    public static void updateFieldType(String field, String type) {
        try {
            if (!HomeSettings.usemySQL) {
                return;
            }
            HomeLogger.info("Updating database");
            Connection conn = ConnectionManager.getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet colRS = null;
            colRS = meta.getColumns(null, null, "homeTable", null);
            while (colRS.next()) {
                String colName = colRS.getString("COLUMN_NAME");
                String colType = colRS.getString("TYPE_NAME");
                if (!colName.equals(field) || colType.equals(type)) continue;
                Statement stm = conn.createStatement();
                stm.executeUpdate("ALTER TABLE homeTable MODIFY " + field + " " + type + "; ");
                conn.commit();
                stm.close();
                break;
            }
            colRS.close();
        }
        catch (SQLException ex) {
            HomeLogger.severe("Failed to update the database to the new version - ", ex);
            ex.printStackTrace();
        }
    }
}

