/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.data;

import com.nijiko.data.GroupWorld;
import com.nijiko.data.UserStorage;
import com.nijiko.permissions.EntryType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.util.config.Configuration;
import org.bukkit.util.config.ConfigurationNode;

public class YamlUserStorage
implements UserStorage {
    protected final Configuration userConfig;
    private final ReentrantReadWriteLock rwl;
    private boolean modified;
    private final String world;
    private boolean saveOff;

    YamlUserStorage(Configuration userConfig, String world, int reloadDelay, boolean autoSave) {
        this.userConfig = userConfig;
        this.world = world;
        this.rwl = new ReentrantReadWriteLock(false);
        this.saveOff = !autoSave;
        this.performConversion();
        this.reload();
    }

    private void performConversion() {
        this.userConfig.load();
        boolean converting = false;
        for (String user : this.getEntries()) {
            ConfigurationNode node = this.userConfig.getNode("users." + user);
            if (node.getProperty("groups") != null) break;
            if (!converting) {
                System.out.println("[Permissions] Converting GM/2.x syntax files...");
                converting = true;
            }
            LinkedHashSet<String> groups = new LinkedHashSet<String>();
            String mainGroup = node.getString("group");
            if (mainGroup != null) {
                groups.add(mainGroup);
            }
            List subgroups = node.getStringList("subgroups", null);
            for (String subgroup : subgroups) {
                if (subgroup == null || subgroup.isEmpty()) continue;
                groups.add(subgroup);
            }
            node.removeProperty("group");
            node.removeProperty("subgroups");
            node.setProperty("groups", new LinkedList(groups));
            LinkedHashSet<String> perms = new LinkedHashSet<String>();
            List oldperms = node.getStringList("permissions", null);
            for (String oldperm : oldperms) {
                if (oldperm == null || oldperm.isEmpty()) continue;
                perms.add(oldperm.startsWith("+") ? oldperm.substring(1) : oldperm);
            }
            node.setProperty("permissions", new LinkedList(perms));
        }
        if (converting) {
            System.out.println("[Permissions] Conversion complete!");
        }
        this.userConfig.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPermissions(String name) {
        HashSet<String> permissions;
        name = name.replace('.', ',');
        this.rwl.readLock().lock();
        try {
            permissions = new HashSet<String>(this.userConfig.getStringList("users." + name + ".permissions", null));
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashSet<GroupWorld> getParents(String name) {
        List rawParents;
        name = name.replace('.', ',');
        this.rwl.readLock().lock();
        try {
            rawParents = this.userConfig.getStringList("users." + name + ".groups", null);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        LinkedHashSet<GroupWorld> parents = new LinkedHashSet<GroupWorld>(rawParents.size());
        for (String raw : rawParents) {
            String[] split = raw.split(",", 2);
            if (split.length == 0) continue;
            if (split.length == 1) {
                parents.add(new GroupWorld(this.world, split[0]));
                continue;
            }
            parents.add(new GroupWorld(split[0], split[1]));
        }
        return parents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermission(String name, String permission) {
        name = name.replace('.', ',');
        this.rwl.writeLock().lock();
        try {
            LinkedHashSet<String> permissions = new LinkedHashSet<String>(this.userConfig.getStringList("users." + name + ".permissions", null));
            permissions.add(permission);
            this.userConfig.setProperty("users." + name + ".permissions", new LinkedList(permissions));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(String name, String permission) {
        name = name.replace('.', ',');
        this.rwl.writeLock().lock();
        try {
            LinkedHashSet permissions = new LinkedHashSet(this.userConfig.getStringList("users." + name + ".permissions", null));
            permissions.remove(permission);
            this.userConfig.setProperty("users." + name + ".permissions", new LinkedList(permissions));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParent(String name, String groupWorld, String groupName) {
        name = name.replace('.', ',');
        this.rwl.writeLock().lock();
        try {
            LinkedHashSet<String> parents = new LinkedHashSet<String>(this.userConfig.getStringList("users." + name + ".groups", null));
            if (groupWorld == null || this.world.equalsIgnoreCase(groupWorld)) {
                parents.add(groupName);
            } else {
                parents.add(groupWorld + "," + groupName);
            }
            this.userConfig.setProperty("users." + name + ".groups", new LinkedList(parents));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParent(String name, String groupWorld, String groupName) {
        name = name.replace('.', ',');
        this.rwl.writeLock().lock();
        try {
            LinkedHashSet parents = new LinkedHashSet(this.userConfig.getStringList("users." + name + ".groups", null));
            if (groupWorld == null || this.world.equalsIgnoreCase(groupWorld)) {
                parents.remove(groupName);
            } else {
                parents.remove(groupWorld + "," + groupName);
            }
            this.userConfig.setProperty("users." + name + ".groups", new LinkedList(parents));
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getEntries() {
        this.rwl.readLock().lock();
        List rawUsers = null;
        try {
            rawUsers = this.userConfig.getKeys("users");
        }
        finally {
            this.rwl.readLock().unlock();
        }
        HashSet<String> users = new HashSet<String>();
        if (rawUsers != null) {
            for (String username : rawUsers) {
                if (username == null) continue;
                users.add(username.replace(',', '.'));
            }
        }
        return users;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceSave() {
        this.rwl.writeLock().lock();
        try {
            if (this.modified) {
                this.userConfig.save();
            }
            this.userConfig.load();
            this.modified = false;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        this.rwl.writeLock().lock();
        try {
            if (!this.saveOff) {
                this.forceSave();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        this.rwl.writeLock().lock();
        try {
            this.userConfig.load();
            this.modified = false;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoSave() {
        this.rwl.readLock().lock();
        boolean save = true;
        try {
            save = this.saveOff;
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return save;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoSave(boolean autoSave) {
        this.rwl.writeLock().lock();
        try {
            this.saveOff = autoSave;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String name) {
        boolean created = false;
        this.rwl.writeLock().lock();
        try {
            if (this.userConfig.getProperty("users." + name) == null) {
                HashMap<String, Object> template = new HashMap<String, Object>();
                template.put("groups", null);
                template.put("permissions", null);
                this.userConfig.setProperty("users." + name, template);
                this.modified = true;
                created = true;
                this.save();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String name) {
        this.rwl.writeLock().lock();
        boolean exists = false;
        try {
            exists = this.userConfig.getProperty("users." + name) != null;
            this.userConfig.removeProperty("users." + name);
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(String name, String path) {
        this.rwl.writeLock().lock();
        try {
            this.userConfig.removeProperty("users." + name + ".info." + path);
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String name, String path, Object data) {
        this.rwl.writeLock().lock();
        try {
            this.userConfig.setProperty("users." + name + ".info." + path, data);
            this.modified = true;
            this.save();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public String getString(String name, String path) {
        Object raw = this.getObj(name, path);
        if (raw instanceof String) {
            return (String)raw;
        }
        if (raw == null) {
            return null;
        }
        return raw.toString();
    }

    @Override
    public Integer getInt(String name, String path) {
        int val;
        Object raw = this.getObj(name, path);
        if (raw instanceof Integer) {
            return (Integer)raw;
        }
        if (raw == null) {
            return null;
        }
        try {
            val = Integer.valueOf(raw.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    @Override
    public Double getDouble(String name, String path) {
        double val;
        Object raw = this.getObj(name, path);
        if (raw instanceof Double) {
            return (Double)raw;
        }
        if (raw == null) {
            return null;
        }
        try {
            val = Double.valueOf(raw.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    @Override
    public Boolean getBool(String name, String path) {
        Object raw = this.getObj(name, path);
        if (raw instanceof Boolean) {
            return (Boolean)raw;
        }
        if (raw == null) {
            return null;
        }
        boolean val = Boolean.valueOf(raw.toString());
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObj(String name, String path) {
        this.rwl.readLock().lock();
        Object data = null;
        try {
            data = this.userConfig.getProperty("users." + name + ".info." + path);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return data;
    }

    @Override
    public EntryType getType() {
        return EntryType.USER;
    }
}

