/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.permissions.Entry;

class CheckResult {
    private final Entry source;
    private final String mostRelevantNode;
    private final Entry checked;
    private final String node;
    private final String world;
    private boolean valid;

    public CheckResult(Entry source, String mrn, Entry checked, String node, String world) {
        this.source = source;
        this.mostRelevantNode = mrn;
        this.checked = checked;
        this.node = node;
        this.valid = true;
        this.world = world;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public Entry getSource() {
        return this.source;
    }

    public String getMostRelevantNode() {
        return this.mostRelevantNode;
    }

    public Entry getChecked() {
        return this.checked;
    }

    public String getNode() {
        return this.node;
    }

    public boolean getResult() {
        return this.mostRelevantNode == null ? false : !this.mostRelevantNode.startsWith("-");
    }

    public CheckResult setChecked(Entry e) {
        if (!this.valid || e == null) {
            return null;
        }
        return new CheckResult(this.source, this.mostRelevantNode, e, this.node, this.world);
    }

    public String toString() {
        return "Checked: " + this.checked.toString() + " , Node: " + this.node + " , Source: " + this.source.toString() + " , MRN: " + this.mostRelevantNode + " World: " + this.world + ", Valid: " + this.valid;
    }

    public CheckResult setNode(String node) {
        if (!this.valid || node == null) {
            return null;
        }
        return new CheckResult(this.source, this.mostRelevantNode, this.checked, node, this.world);
    }

    public String getWorld() {
        return this.world;
    }
}

