/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.data.GroupWorld;
import com.nijiko.data.Storage;
import com.nijiko.permissions.CheckResult;
import com.nijiko.permissions.EntryType;
import com.nijiko.permissions.Group;
import com.nijiko.permissions.ModularControl;
import com.nijiko.permissions.PermissionWorld;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class Entry {
    protected ModularControl controller;
    protected PermissionWorld worldObj;
    protected String name;
    protected String world;
    protected Map<String, Map<String, CheckResult>> cache = new HashMap<String, Map<String, CheckResult>>();
    protected Set<String> transientPerms = new HashSet<String>();
    private final ConcurrentMap<String, Long> timedPerms = new ConcurrentHashMap<String, Long>();

    Entry(ModularControl controller, String name, PermissionWorld worldObj) {
        this.controller = controller;
        this.name = name;
        this.world = worldObj.getWorldName();
        this.worldObj = worldObj;
    }

    public boolean delete() {
        this.cache.clear();
        this.transientPerms.clear();
        this.timedPerms.clear();
        Storage store = this.getStorage();
        if (store != null) {
            return store.delete(this.name);
        }
        return false;
    }

    public void addTransientPermission(String node) {
        if (node == null) {
            return;
        }
        this.controller.cache.updatePerms(this, node);
        this.transientPerms.add(node);
    }

    public void removeTransientPermission(String node) {
        if (node == null) {
            return;
        }
        this.controller.cache.updatePerms(this, node);
        this.transientPerms.remove(node);
    }

    public void clearTransientPerms() {
        HashSet<String> cloned = new HashSet<String>(this.transientPerms);
        this.transientPerms.clear();
        for (String node : cloned) {
            this.controller.cache.updatePerms(this, node);
        }
    }

    public Long addTimedPermission(String node, long duration) {
        if (node == null) {
            throw new NullPointerException("Supplied node is null");
        }
        this.controller.cache.updatePerms(this, node);
        return this.timedPerms.put(node, duration);
    }

    public Long removeTimedPermission(String node) {
        if (node == null) {
            throw new NullPointerException("Supplied node is null");
        }
        this.controller.cache.updatePerms(this, node);
        return (Long)this.timedPerms.remove(node);
    }

    public Long getDuration(String node) {
        return (Long)this.timedPerms.get(node);
    }

    public void clearTimedPerms() {
        HashSet cloned = new HashSet(this.timedPerms.keySet());
        this.timedPerms.clear();
        for (String node : cloned) {
            this.controller.cache.updatePerms(this, node);
        }
    }

    void tick(long interval) {
        if (interval <= 0L) {
            return;
        }
        Iterator iter = this.timedPerms.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Long left = (Long)entry.getValue();
            if (left == null) {
                this.controller.cache.updatePerms(this, (String)entry.getKey());
                iter.remove();
                continue;
            }
            if (left < 0L) continue;
            long newLeft = left - interval;
            if (newLeft <= 0L) {
                this.controller.cache.updatePerms(this, (String)entry.getKey());
                iter.remove();
                continue;
            }
            entry.setValue(newLeft);
        }
    }

    void copyTimedMap(Entry e) {
        if (!this.equals(e)) {
            return;
        }
        this.timedPerms.putAll(e.timedPerms);
    }

    protected Set<String> getTimedPermissions() {
        return new HashSet<String>(this.timedPerms.keySet());
    }

    public Map<String, Map<String, CheckResult>> getCache() {
        return Collections.unmodifiableMap(this.cache);
    }

    protected abstract Storage getStorage();

    public Set<String> getPermissions() {
        HashSet<String> perms = new HashSet<String>();
        Storage store = this.getStorage();
        if (store != null) {
            perms.addAll(store.getPermissions(this.name));
        }
        Entry.resolvePerms(perms, this.transientPerms);
        Entry.resolvePerms(perms, this.getTimedPermissions());
        return perms;
    }

    public LinkedHashSet<GroupWorld> getRawParents() {
        Storage store = this.getStorage();
        if (store != null) {
            return store.getParents(this.name);
        }
        return null;
    }

    public void setPermission(String permission, boolean add) {
        if (add) {
            this.addPermission(permission);
        } else {
            this.removePermission(permission);
        }
    }

    public void addPermission(String permission) {
        this.controller.cache.updatePerms(this, permission);
        Storage store = this.getStorage();
        if (store != null) {
            store.addPermission(this.name, permission);
        }
    }

    public void removePermission(String permission) {
        this.controller.cache.updatePerms(this, permission);
        Storage store = this.getStorage();
        if (store != null) {
            store.removePermission(this.name, permission);
        }
    }

    public void addParent(Group group) {
        this.controller.cache.updateParent(this, group);
        Storage store = this.getStorage();
        if (store != null) {
            store.addParent(this.name, group.world, group.name);
        }
    }

    public void removeParent(Group group) {
        this.controller.cache.updateParent(this, group);
        Storage store = this.getStorage();
        if (store != null) {
            store.removeParent(this.name, group.world, group.name);
        }
    }

    public boolean hasPermission(String permission) {
        CheckResult cr = this.has(permission, Entry.relevantPerms(permission), new LinkedHashSet<Entry>(), this.world);
        return cr.getResult();
    }

    protected CheckResult has(String node, LinkedHashSet<String> relevant, LinkedHashSet<Entry> checked, String world) {
        if (checked.contains(this)) {
            return null;
        }
        checked.add(this);
        CheckResult cr = null;
        if (this.cache.get(world) != null) {
            this.cache.put(world, new HashMap());
            cr = this.cache.get(world).get(node);
            if (cr == null || !cr.isValid()) {
                this.cache.remove(node);
                cr = null;
            }
        }
        if (cr == null) {
            Set<String> perms = this.getPermissions();
            for (String mrn : relevant) {
                if (!perms.contains(mrn)) continue;
                cr = new CheckResult(this, mrn, this, node, world);
                break;
            }
            if (cr == null) {
                for (Entry e : this.getParents(world)) {
                    CheckResult parentCr = e.has(node, relevant, checked, world);
                    if (parentCr == null || parentCr.getMostRelevantNode() == null) continue;
                    cr = parentCr.setChecked(this);
                    break;
                }
                if (cr == null) {
                    cr = new CheckResult(this, null, this, node, world);
                }
            }
            this.cache(cr);
        }
        checked.remove(this);
        return cr;
    }

    protected void cache(CheckResult cr) {
        if (cr == null) {
            return;
        }
        if (this.cache.get(this.world) == null) {
            this.cache.put(this.world, new HashMap());
        }
        this.controller.cache.cacheResult(cr);
        this.cache.get(this.world).put(cr.getNode(), cr);
    }

    public boolean isChildOf(final Entry entry) {
        if (entry == null) {
            return false;
        }
        Boolean val = this.recursiveCheck(new EntryVisitor<Boolean>(){

            @Override
            public Boolean value(Entry e) {
                if (entry.equals(e)) {
                    return true;
                }
                return null;
            }
        });
        return val == null ? false : val;
    }

    boolean isChildOf(final GroupWorld gw) {
        Boolean val = this.recursiveCheck(new EntryVisitor<Boolean>(){

            @Override
            public Boolean value(Entry e) {
                if (e.getRawParents().contains(gw)) {
                    return true;
                }
                return null;
            }
        });
        return val == null ? false : val;
    }

    public Set<String> getAllPermissions() {
        return this.getAllPermissions(new LinkedHashSet<Entry>(), this.world);
    }

    protected Set<String> getAllPermissions(LinkedHashSet<Entry> chain, String world) {
        Set<String> perms = new HashSet<String>();
        if (chain == null) {
            return perms;
        }
        if (chain.contains(this)) {
            return perms;
        }
        chain.add(this);
        LinkedHashSet<Entry> rawParents = this.getParents(world);
        ArrayDeque<Entry> parents = new ArrayDeque<Entry>();
        for (Entry e : rawParents) {
            if (chain.contains(e)) continue;
            parents.push(e);
        }
        rawParents = null;
        for (Entry e : parents) {
            perms = Entry.resolvePerms(perms, e.getAllPermissions(chain, world));
        }
        if (chain.contains(this)) {
            chain.remove(this);
        }
        Entry.resolvePerms(perms, this.getPermissions());
        return perms;
    }

    protected static Set<String> resolvePerms(Set<String> perms, Set<String> rawPerms) {
        Iterator<String> rawIter = rawPerms.iterator();
        while (rawIter.hasNext()) {
            String perm = rawIter.next();
            if (perm.isEmpty()) {
                rawIter.remove();
                continue;
            }
            if (!perm.endsWith("*")) continue;
            String wild = perm.substring(0, perm.length() - 1);
            String oppWild = Entry.negationOf(perm).substring(0, perm.length() - 1);
            Iterator<String> itr = perms.iterator();
            while (itr.hasNext()) {
                String candidate = itr.next();
                if (!candidate.startsWith(oppWild) && !candidate.startsWith(wild)) continue;
                itr.remove();
            }
        }
        perms.addAll(rawPerms);
        return perms;
    }

    public LinkedHashSet<Entry> getParents() {
        return this.getParents(this.world);
    }

    protected LinkedHashSet<Entry> getUnspecialisedParents() {
        return this.getParents(null);
    }

    public LinkedHashSet<Entry> getParents(String world) {
        String parentWorld;
        LinkedHashSet<Group> groupParents = this.controller.stringToGroups(this.getRawParents(), world);
        LinkedHashSet<Entry> parents = new LinkedHashSet<Entry>();
        parents.addAll(groupParents);
        if (!this.world.equals("*")) {
            Entry global;
            Entry entry = global = this.getType() == EntryType.USER ? this.controller.getUserObject("*", this.name) : this.controller.getGroupObject("*", this.name);
            if (global != null) {
                parents.add(global);
            }
        }
        if ((parentWorld = this.controller.getWorldParent(world, this.getType() == EntryType.USER)) != null) {
            Entry inherited;
            Entry entry = inherited = this.getType() == EntryType.USER ? this.controller.getUserObject(parentWorld, this.name) : this.controller.getGroupObject(parentWorld, this.name);
            if (inherited != null) {
                parents.add(inherited);
            }
        }
        return parents;
    }

    public int getWeight() {
        Integer value = this.getInt("weight");
        return value == null ? -1 : value;
    }

    public LinkedHashSet<Entry> getAncestors() {
        LinkedHashSet<Entry> parentSet = new LinkedHashSet<Entry>();
        ArrayDeque<Entry> queue = new ArrayDeque<Entry>();
        LinkedHashSet<Entry> parents = this.getParents();
        if (parents != null && parents.size() > 0) {
            queue.addAll(parents);
        }
        while (queue.peek() != null) {
            Entry entry = (Entry)queue.poll();
            if (parentSet.contains(entry)) continue;
            parents = entry.getParents(this.world);
            if (parents != null && parents.size() > 0) {
                queue.addAll(parents);
            }
            parentSet.add(entry);
        }
        return parentSet;
    }

    public boolean inGroup(String world, String group) {
        if (this.getType() == EntryType.GROUP && this.world.equalsIgnoreCase(world) && this.name.equalsIgnoreCase(group)) {
            return true;
        }
        Boolean val = this.recursiveCheck(new GroupChecker(world, group));
        return val == null ? false : val;
    }

    public boolean canBuild() {
        Boolean value = this.recursiveCheck(new BooleanInfoVisitor("build"));
        return value == null ? false : value;
    }

    public <T> T recursiveCheck(EntryVisitor<T> visitor) {
        return this.recursiveCheck(new LinkedHashSet<Entry>(), visitor, this.world);
    }

    protected <T> T recursiveCheck(LinkedHashSet<Entry> checked, EntryVisitor<T> visitor, String overrideWorld) {
        if (checked.contains(this)) {
            return null;
        }
        T result = visitor.value(this);
        if (result != null) {
            return result;
        }
        LinkedHashSet<Entry> parents = this.getParents(overrideWorld);
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        checked.add(this);
        for (Entry entry : parents) {
            if (checked.contains(entry) || (result = entry.recursiveCheck(checked, visitor, overrideWorld)) == null) continue;
            return result;
        }
        checked.remove(this);
        return null;
    }

    public <T> T recursiveCompare(EntryVisitor<T> visitor, Comparator<T> comparator) {
        return this.recursiveCompare(new LinkedHashSet<Entry>(), visitor, comparator, this.world);
    }

    protected <T> T recursiveCompare(LinkedHashSet<Entry> checked, EntryVisitor<T> visitor, Comparator<T> comparator, String overrideWorld) {
        if (checked.contains(this)) {
            return null;
        }
        T result = visitor.value(this);
        if (result != null) {
            return result;
        }
        LinkedHashSet<Entry> parents = this.getParents(overrideWorld);
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        checked.add(this);
        Object currentValue = null;
        for (Entry e : parents) {
            if (checked.contains(e) || (result = e.recursiveCompare(checked, visitor, comparator, overrideWorld)) == null || comparator.compare(result, currentValue) <= 0) continue;
            currentValue = result;
        }
        checked.remove(this);
        return currentValue;
    }

    public abstract EntryType getType();

    public String getName() {
        return this.name;
    }

    public String getWorld() {
        return this.world;
    }

    public String toString() {
        return "Entry " + this.name + " in " + this.world;
    }

    public void setData(String path, Object data) {
        Storage store = this.getStorage();
        if (store != null) {
            store.setData(this.name, path, data);
        }
    }

    public String getRawString(String path) {
        Storage store = this.getStorage();
        if (store != null) {
            return store.getString(this.name, path);
        }
        return null;
    }

    public Integer getRawInt(String path) {
        Storage store = this.getStorage();
        if (store != null) {
            return store.getInt(this.name, path);
        }
        return null;
    }

    public Boolean getRawBool(String path) {
        Storage store = this.getStorage();
        if (store != null) {
            return store.getBool(this.name, path);
        }
        return null;
    }

    public Double getRawDouble(String path) {
        Storage store = this.getStorage();
        if (store != null) {
            return store.getDouble(this.name, path);
        }
        return null;
    }

    public void removeData(String path) {
        Storage store = this.getStorage();
        if (store != null) {
            store.removeData(this.name, path);
        }
    }

    public Integer getInt(String path) {
        return this.getInt(path, new SimpleComparator<Integer>());
    }

    public Integer getInt(String path, Comparator<Integer> comparator) {
        Integer value = this.recursiveCompare(new IntegerInfoVisitor(path), comparator);
        return value;
    }

    public Double getDouble(String path) {
        return this.getDouble(path, new SimpleComparator<Double>());
    }

    public Double getDouble(String path, Comparator<Double> comparator) {
        Double value = this.recursiveCompare(new DoubleInfoVisitor(path), comparator);
        return value;
    }

    public Boolean getBool(String path) {
        return this.getBool(path, new SimpleComparator<Boolean>());
    }

    public Boolean getBool(String path, Comparator<Boolean> comparator) {
        Boolean value = this.recursiveCompare(new BooleanInfoVisitor(path), comparator);
        return value;
    }

    public String getString(String path) {
        return this.getString(path, new SimpleComparator<String>());
    }

    public String getString(String path, Comparator<String> comparator) {
        String value = this.recursiveCompare(new StringInfoVisitor(path), comparator);
        return value;
    }

    public String getPrefix() {
        return this.recursiveCheck(new StringInfoVisitor("prefix"));
    }

    public String getSuffix() {
        return this.recursiveCheck(new StringInfoVisitor("suffix"));
    }

    public static LinkedHashSet<String> relevantPerms(String node) {
        if (node == null) {
            return null;
        }
        if (node.startsWith("-")) {
            return Entry.relevantPerms(Entry.negationOf(node));
        }
        LinkedHashSet<String> relevant = new LinkedHashSet<String>();
        if (!node.endsWith(".*")) {
            relevant.add(node);
            relevant.add(Entry.negationOf(node));
        }
        String[] split = node.split("\\.");
        ArrayList<String> rev = new ArrayList<String>(split.length);
        StringBuilder sb = new StringBuilder();
        sb.append("*");
        for (int i = 0; i < split.length; ++i) {
            String wild = sb.toString();
            String neg = Entry.negationOf(wild);
            rev.add(neg);
            rev.add(wild);
            sb.deleteCharAt(sb.length() - 1);
            sb.append(split[i]).append(".*");
        }
        ListIterator iter = rev.listIterator(rev.size());
        while (iter.hasPrevious()) {
            relevant.add((String)iter.previous());
        }
        return relevant;
    }

    public static String negationOf(String node) {
        return node == null ? null : (node.startsWith("-") ? node.substring(1) : "-" + node);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
        EntryType type = this.getType();
        result = 31 * result + (type == null ? 0 : type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.world == null ? other.world != null : !this.world.equals(other.world)) {
            return false;
        }
        EntryType type = this.getType();
        EntryType otherType = other.getType();
        return !(type == null ? otherType != null : !type.equals((Object)otherType));
    }

    public static class SimpleComparator<T extends Comparable<T>>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -2712787010868605898L;

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static interface EntryVisitor<T> {
        public T value(Entry var1);
    }

    public static final class StringInfoVisitor
    implements EntryVisitor<String> {
        private final String path;

        private StringInfoVisitor(String path) {
            this.path = path;
        }

        @Override
        public String value(Entry e) {
            return e.getRawString(this.path);
        }
    }

    public static final class IntegerInfoVisitor
    implements EntryVisitor<Integer> {
        private final String path;

        public IntegerInfoVisitor(String path) {
            this.path = path;
        }

        @Override
        public Integer value(Entry e) {
            return e.getRawInt(this.path);
        }
    }

    public static final class DoubleInfoVisitor
    implements EntryVisitor<Double> {
        private final String path;

        protected DoubleInfoVisitor(String path) {
            this.path = path;
        }

        @Override
        public Double value(Entry e) {
            return e.getRawDouble(this.path);
        }
    }

    public static final class BooleanInfoVisitor
    implements EntryVisitor<Boolean> {
        private final String path;

        public BooleanInfoVisitor(String path) {
            this.path = path;
        }

        @Override
        public Boolean value(Entry e) {
            return e.getRawBool(this.path);
        }
    }

    static class GroupChecker
    implements EntryVisitor<Boolean> {
        protected final String world;
        protected final String group;

        GroupChecker(String world, String group) {
            this.world = world;
            this.group = group;
        }

        @Override
        public Boolean value(Entry e) {
            if (e instanceof Group) {
                Group g = (Group)e;
                if (g.world != null && g.name != null && g.world.equals(this.world) && g.name.equalsIgnoreCase(this.group)) {
                    return true;
                }
            }
            return null;
        }
    }
}

