/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.GroupWorld;
import com.nijiko.data.Storage;
import com.nijiko.permissions.Entry;
import com.nijiko.permissions.EntryType;
import com.nijiko.permissions.ModularControl;
import com.nijiko.permissions.PermissionWorld;
import java.util.Set;

public class Group
extends Entry {
    private GroupStorage data;

    Group(ModularControl controller, GroupStorage data, String name, PermissionWorld worldObj, boolean create) {
        super(controller, name, worldObj);
        this.data = data;
        if (create && !this.world.equals("?")) {
            System.out.println("Creating group " + name);
            data.create(name);
        }
    }

    public boolean isDefault() {
        if (this.data == null) {
            return false;
        }
        return this.data.isDefault(this.name);
    }

    @Override
    public EntryType getType() {
        return EntryType.GROUP;
    }

    @Override
    public String toString() {
        return "Group " + this.name + " in " + this.world;
    }

    public Set<String> getTracks() {
        if (this.data == null) {
            return null;
        }
        return this.data.getTracks();
    }

    @Override
    protected Storage getStorage() {
        return this.data;
    }

    @Override
    public boolean delete() {
        this.worldObj.delGrp(this.name);
        return super.delete();
    }

    public GroupWorld toGroupWorld() {
        return new GroupWorld(this.world, this.name);
    }
}

