/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.GroupWorld;
import com.nijiko.data.NullGroupStorage;
import com.nijiko.data.NullUserStorage;
import com.nijiko.data.StorageFactory;
import com.nijiko.data.UserStorage;
import com.nijiko.permissions.ControlCloseEvent;
import com.nijiko.permissions.Entry;
import com.nijiko.permissions.Group;
import com.nijiko.permissions.PermissionCache;
import com.nijiko.permissions.PermissionHandler;
import com.nijiko.permissions.PermissionWorld;
import com.nijiko.permissions.StorageReloadEvent;
import com.nijiko.permissions.User;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.config.Configuration;

public class ModularControl
extends PermissionHandler {
    private Map<String, String> userStorageMirrorings = new HashMap<String, String>();
    private Map<String, String> groupStorageMirrorings = new HashMap<String, String>();
    private Map<String, String> userStorageInheritance = new HashMap<String, String>();
    private Map<String, String> groupStorageInheritance = new HashMap<String, String>();
    private Configuration storageConfig;
    private String defaultWorld = "";
    private Map<String, PermissionWorld> worlds = new HashMap<String, PermissionWorld>(1, 1.5f);
    public static final long tickInterval = 10L;
    PermissionCache cache = new PermissionCache();

    public ModularControl(Configuration storageConfig) {
        this.storageConfig = storageConfig;
        this.loadWorldInheritance();
        int period = storageConfig.getInt("permissions.storage.reload", 6000);
        Permissions.instance.getServer().getScheduler().scheduleAsyncRepeatingTask(Permissions.instance, (Runnable)new RefreshTask(), (long)period, (long)period);
        Permissions.instance.getServer().getScheduler().scheduleAsyncRepeatingTask(Permissions.instance, (Runnable)new TickTask(), 10L, 10L);
    }

    @Override
    public void setDefaultWorld(String world) {
        this.defaultWorld = world;
    }

    @Override
    public boolean reload(String world) {
        this.cache.reloadWorld(world);
        PermissionWorld w = this.getWorldObject(world);
        if (w == null) {
            return false;
        }
        return w.reload();
    }

    @Override
    public boolean loadWorld(String world) throws Exception {
        if (!this.checkWorld(world)) {
            this.forceLoadWorld(world);
            return true;
        }
        return false;
    }

    @Override
    public void forceLoadWorld(String world) throws Exception {
        boolean q = world.equals("?");
        UserStorage userStore = q ? new NullUserStorage(world) : StorageFactory.getUserStorage(world, this.storageConfig);
        GroupStorage groupStore = q ? new NullGroupStorage(world) : StorageFactory.getGroupStorage(world, this.storageConfig);
        PermissionWorld w = new PermissionWorld(world, this, userStore, groupStore);
        w.reload();
        this.worlds.put(world, w);
    }

    @Override
    public boolean checkWorld(String world) {
        return this.worlds.containsKey(world) || this.userStorageMirrorings.containsKey(world) || this.groupStorageMirrorings.containsKey(world);
    }

    @Override
    public void load() throws Exception {
        this.loadWorld("*");
        this.loadWorld("?");
        this.loadWorld(this.defaultWorld);
    }

    private void storageReload() {
        this.saveAll();
        this.cache.flushAll();
        for (PermissionWorld w : this.worlds.values()) {
            w.minorReload();
        }
        Permissions.instance.getServer().getPluginManager().callEvent((Event)new StorageReloadEvent());
    }

    @Override
    public void reload() {
        this.storageReload();
        for (PermissionWorld w : this.worlds.values()) {
            w.reload();
        }
    }

    private void tick() {
        for (PermissionWorld w : this.worlds.values()) {
            w.tick(10L);
        }
    }

    @Override
    public void closeAll() {
        this.cache.flushAll();
        this.saveAll();
        Permissions.instance.getServer().getPluginManager().callEvent((Event)new ControlCloseEvent());
    }

    @Override
    public void save(String world) {
        PermissionWorld w = this.getWorldObject(world);
        if (w != null) {
            w.save();
        }
    }

    @Override
    public void saveAll() {
        for (PermissionWorld w : this.worlds.values()) {
            w.save();
        }
    }

    public PermissionWorld getWorldObject(String world) {
        return this.worlds.get(world);
    }

    public PermissionWorld safeGetWorld(String world) throws Exception {
        this.loadWorld(world);
        return this.getWorldObject(world);
    }

    private void loadWorldInheritance() {
        List userWorlds;
        this.userStorageInheritance.clear();
        this.groupStorageInheritance.clear();
        this.storageConfig.load();
        List worlds = this.storageConfig.getKeys("permissions.storage.world-inheritance");
        HashMap<String, String> worldInheritance = new HashMap<String, String>();
        if (worlds != null) {
            for (String world : worlds) {
                String string = this.storageConfig.getString("permissions.storage.world-inheritance." + world);
                if (string == null || world.equals("*")) continue;
                worldInheritance.put(world, string);
            }
        }
        if ((userWorlds = this.storageConfig.getKeys("permissions.storage.user.world-inheritance")) != null) {
            for (String string : userWorlds) {
                String string2 = this.storageConfig.getString("permissions.storage.user.world-inheritance.users" + string);
                if (string2 == null || string.equals("*")) continue;
                this.userStorageInheritance.put(string, string2);
            }
        }
        for (Map.Entry entry : worldInheritance.entrySet()) {
            if (this.userStorageInheritance.containsKey(entry.getKey())) continue;
            this.userStorageInheritance.put((String)entry.getKey(), (String)entry.getValue());
        }
        List groupWorlds = this.storageConfig.getKeys("permissions.storage.group.world-inheritance");
        if (groupWorlds != null) {
            for (String string : groupWorlds) {
                String parentWorld = this.storageConfig.getString("permissions.storage.group.world-inheritance." + string);
                if (parentWorld == null || string.equals("*")) continue;
                this.userStorageInheritance.put(string, parentWorld);
            }
        }
        for (Map.Entry entry : worldInheritance.entrySet()) {
            if (this.groupStorageInheritance.containsKey(entry.getKey())) continue;
            this.groupStorageInheritance.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    String getWorldParent(String world, boolean user) {
        return user ? (this.userStorageInheritance.containsKey(world) ? this.userStorageInheritance.get(world) : null) : (this.groupStorageInheritance.containsKey(world) ? this.groupStorageInheritance.get(world) : null);
    }

    @Override
    public Set<String> getWorlds() {
        HashSet<String> worlds = new HashSet<String>();
        worlds.addAll(this.worlds.keySet());
        worlds.addAll(this.userStorageMirrorings.keySet());
        worlds.addAll(this.groupStorageMirrorings.keySet());
        return worlds;
    }

    public String getParentWorldGroup(String world) {
        if (!world.equals("*") && !world.equals("?") && this.groupStorageMirrorings.get(world) != null) {
            return this.groupStorageMirrorings.get(world);
        }
        return world;
    }

    public String getParentWorldUser(String world) {
        if (!world.equals("*") && !world.equals("?") && this.userStorageMirrorings.get(world) != null) {
            world = this.userStorageMirrorings.get(world);
        }
        return world;
    }

    @Override
    public boolean has(String world, String name, String permission) {
        return this.permission(world, name, permission);
    }

    @Override
    public boolean has(Player player, String permission) {
        return this.permission(player, permission);
    }

    @Override
    public boolean permission(Player player, String permission) {
        String name = player.getName();
        String worldName = player.getWorld().getName();
        return this.permission(worldName, name, permission);
    }

    @Override
    public boolean permission(String world, String name, String permission) {
        if (name == null || name.isEmpty() || world == null || world.isEmpty()) {
            return true;
        }
        User user = this.getUsr(world = this.getParentWorldUser(world), name);
        if (user == null) {
            return false;
        }
        return user.hasPermission(permission);
    }

    @Override
    public void addUserPermission(String world, String user, String node) {
        try {
            this.safeGetUser(world, user).addPermission(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeUserPermission(String world, String user, String node) {
        try {
            this.safeGetUser(world, user).removePermission(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addGroupPermission(String world, String group, String node) {
        try {
            this.safeGetGroup(world, group).addPermission(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeGroupPermission(String world, String group, String node) {
        try {
            this.safeGetGroup(world, group).removePermission(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getGroupProperName(String world, String group) {
        Group g = this.getGroupObject(world, group);
        if (g == null && (g = this.getDefaultGroup(world)) == null) {
            return "";
        }
        return g.getName();
    }

    @Override
    public String getUserPrefix(String world, String user) {
        User u = this.getUsr(world, user);
        if (u == null) {
            return "";
        }
        String prefix = u.getPrefix();
        return prefix == null ? "" : prefix;
    }

    @Override
    public String getUserSuffix(String world, String user) {
        User u = this.getUsr(world, user);
        if (u == null) {
            return "";
        }
        String suffix = u.getSuffix();
        return suffix == null ? "" : suffix;
    }

    @Override
    public String getPrimaryGroup(String world, String user) {
        Group g = this.getPrimaryGroupObject(world, user);
        if (g == null) {
            return "Default";
        }
        return g.getName();
    }

    @Override
    public Group getPrimaryGroupObject(String world, String user) {
        User u = this.getUsr(world, user);
        if (u == null) {
            return this.getDefaultGroup(world);
        }
        return u.getPrimaryGroup();
    }

    @Override
    public boolean canUserBuild(String world, String user) {
        User u = this.getUsr(world, user);
        if (u == null) {
            return false;
        }
        return u.canBuild();
    }

    @Override
    public String getGroupRawPrefix(String world, String group) {
        Group g = this.getGroupObject(world = this.getParentWorldGroup(world), group);
        if (g == null) {
            return "";
        }
        String prefix = g.getRawString("prefix");
        return prefix == null ? "" : prefix;
    }

    @Override
    public String getGroupRawSuffix(String world, String group) {
        Group g = this.getGroupObject(world = this.getParentWorldGroup(world), group);
        if (g == null) {
            return "";
        }
        String suffix = g.getRawString("suffix");
        return suffix == null ? "" : suffix;
    }

    @Override
    public boolean canGroupRawBuild(String world, String group) {
        Group g = this.getGroupObject(world = this.getParentWorldGroup(world), group);
        if (g == null) {
            return false;
        }
        return g.canBuild();
    }

    LinkedHashSet<Group> stringToGroups(LinkedHashSet<GroupWorld> raws, String overrideWorld) {
        if (overrideWorld == null) {
            overrideWorld = this.defaultWorld;
        }
        LinkedHashSet<Group> groupSet = new LinkedHashSet<Group>();
        if (raws == null) {
            return groupSet;
        }
        for (GroupWorld raw : raws) {
            String world;
            Group g;
            String rawWorld = raw.getWorld();
            if (rawWorld.equals("?") && overrideWorld != null) {
                rawWorld = overrideWorld;
            }
            if ((g = this.getGrp(world = this.getParentWorldGroup(rawWorld), raw.getName())) == null) continue;
            groupSet.add(g);
        }
        return groupSet;
    }

    public boolean deleteUser(String world, String name) {
        User u = this.getUserObject(world, name);
        if (u == null) {
            return false;
        }
        return u.delete();
    }

    public boolean deleteGroup(String world, String name) {
        Group g = this.getGroupObject(world, name);
        if (g == null) {
            return false;
        }
        return g.delete();
    }

    @Override
    public User safeGetUser(String world, String name) throws Exception {
        world = this.getParentWorldUser(world);
        try {
            this.loadWorld(world);
        }
        catch (Exception e) {
            throw new Exception("Error creating user " + name + " in world " + world + " due to storage problems!", e);
        }
        PermissionWorld w = this.getWorldObject(world);
        if (w == null) {
            throw new Exception("Freshly loaded world object does not exist!");
        }
        return w.safeGetUser(name);
    }

    @Override
    public Group safeGetGroup(String world, String name) throws Exception {
        PermissionWorld w;
        if (!world.equals("?")) {
            world = this.getParentWorldGroup(world);
            try {
                this.loadWorld(world);
            }
            catch (Exception e) {
                throw new Exception("Error creating group " + name + " in world " + world + " due to storage problems!", e);
            }
        }
        if ((w = this.getWorldObject(world)) == null) {
            throw new Exception("Freshly loaded world object does not exist!");
        }
        return w.safeGetGroup(name);
    }

    @Override
    public Group getDefaultGroup(String world) {
        PermissionWorld w = this.getWorldObject(world = this.getParentWorldGroup(world));
        if (w == null) {
            return null;
        }
        return w.getDefaultGroup();
    }

    @Override
    public Collection<User> getUsers(String world) {
        PermissionWorld w = this.getWorldObject(world = this.getParentWorldUser(world));
        if (w == null) {
            return null;
        }
        return w.getUsers();
    }

    @Override
    public Collection<Group> getGroups(String world) {
        PermissionWorld w = this.getWorldObject(world = this.getParentWorldGroup(world));
        if (w == null) {
            return null;
        }
        return w.getGroups();
    }

    @Override
    public User getUserObject(String world, String name) {
        PermissionWorld w = this.getWorldObject(world = this.getParentWorldUser(world));
        if (w == null) {
            return null;
        }
        return w.getUserObject(name);
    }

    @Override
    public Group getGroupObject(String world, String name) {
        PermissionWorld w = this.getWorldObject(world = this.getParentWorldGroup(world));
        if (w == null) {
            return null;
        }
        return w.getGroupObject(name);
    }

    User getUsr(String world, String name) {
        try {
            User u = this.safeGetUser(world, name);
            return u;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Group getGrp(String world, String name) {
        try {
            Group g = this.safeGetGroup(world, name);
            return g;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<String> getTracks(String world) {
        PermissionWorld w = this.getWorldObject(world);
        if (w == null) {
            return null;
        }
        return w.getTracks();
    }

    @Override
    public boolean inGroup(String world, String name, String groupWorld, String group) {
        world = this.getParentWorldUser(world);
        groupWorld = this.getParentWorldGroup(groupWorld);
        User u = this.getUsr(world, name);
        if (u == null) {
            return false;
        }
        return u.inGroup(groupWorld, group);
    }

    @Override
    public boolean inSingleGroup(String world, String name, String groupWorld, String group) {
        world = this.getParentWorldUser(world);
        groupWorld = this.getParentWorldGroup(groupWorld);
        User u = this.getUsr(world, name);
        if (u == null) {
            return false;
        }
        return u.getParents().contains(new GroupWorld(groupWorld, group));
    }

    @Override
    public String[] getGroups(String world, String name) {
        User u = this.getUsr(world = this.getParentWorldUser(world), name);
        if (u == null) {
            return new String[0];
        }
        LinkedHashSet<Entry> parents = u.getAncestors();
        LinkedList<String> groupList = new LinkedList<String>();
        for (Entry e : parents) {
            Group g;
            if (!(e instanceof Group) || !(g = (Group)e).getWorld().equalsIgnoreCase(world)) continue;
            groupList.add(g.getName());
        }
        return groupList.toArray(new String[0]);
    }

    @Override
    public boolean inGroup(String world, String name, String group) {
        return this.inGroup(world, name, world, group);
    }

    @Override
    public boolean inSingleGroup(String world, String name, String group) {
        return this.inSingleGroup(world, name, world, group);
    }

    @Override
    public Map<String, Set<String>> getAllGroups(String world, String name) {
        HashMap<String, Set<String>> groupMap = new HashMap<String, Set<String>>();
        User u = this.getUsr(world = this.getParentWorldGroup(world), name);
        if (u == null) {
            return groupMap;
        }
        LinkedHashSet<Entry> parents = u.getAncestors();
        for (Entry e : parents) {
            if (!(e instanceof Group)) continue;
            if (groupMap.get(e.getWorld()) == null) {
                groupMap.put(e.getWorld(), new HashSet());
            }
            ((Set)groupMap.get(e.getWorld())).add(e.getName());
        }
        return groupMap;
    }

    @Override
    public int compareWeights(String world, String first, String second) {
        return this.compareWeights(world, first, world, second);
    }

    @Override
    public int compareWeights(String firstWorld, String first, String secondWorld, String second) {
        User firstUser = this.getUsr(firstWorld, first);
        User secondUser = this.getUsr(secondWorld, second);
        if (firstUser == null) {
            if (secondUser == null) {
                return 0;
            }
            return -1;
        }
        if (secondUser == null) {
            return 1;
        }
        return Integer.signum(Integer.valueOf(firstUser.getWeight()).compareTo(secondUser.getWeight()));
    }

    @Override
    public String getRawInfoString(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getRawString(path);
    }

    @Override
    public Integer getRawInfoInteger(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getRawInt(path);
    }

    @Override
    public Double getRawInfoDouble(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getRawDouble(path);
    }

    @Override
    public Boolean getRawInfoBoolean(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getRawBool(path);
    }

    @Override
    public String getInfoString(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getString(path);
    }

    @Override
    public String getInfoString(String world, String entryName, String path, boolean isGroup, Comparator<String> comparator) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getString(path, comparator);
    }

    @Override
    public Integer getInfoInteger(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getInt(path);
    }

    @Override
    public Integer getInfoInteger(String world, String entryName, String path, boolean isGroup, Comparator<Integer> comparator) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getInt(path, comparator);
    }

    @Override
    public Double getInfoDouble(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getDouble(path);
    }

    @Override
    public Double getInfoDouble(String world, String entryName, String path, boolean isGroup, Comparator<Double> comparator) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getDouble(path, comparator);
    }

    @Override
    public Boolean getInfoBoolean(String world, String entryName, String path, boolean isGroup) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getBool(path);
    }

    @Override
    public Boolean getInfoBoolean(String world, String entryName, String path, boolean isGroup, Comparator<Boolean> comparator) {
        Entry e;
        Entry entry = e = isGroup ? this.getGrp(world, entryName) : this.getUsr(world, entryName);
        if (e == null) {
            return null;
        }
        return e.getBool(path, comparator);
    }

    @Override
    public void addUserInfo(String world, String name, String path, Object data) {
        User u = this.getUsr(world, name);
        if (u == null) {
            return;
        }
        u.setData(path, data);
    }

    @Override
    public void removeUserInfo(String world, String name, String path) {
        User u = this.getUsr(world, name);
        if (u == null) {
            return;
        }
        u.removeData(path);
    }

    @Override
    public void addGroupInfo(String world, String group, String path, Object data) {
        Group g = this.getGrp(world, group);
        if (g == null) {
            return;
        }
        g.setData(path, data);
    }

    @Override
    public void removeGroupInfo(String world, String group, String path) {
        Group g = this.getGrp(world, group);
        if (g == null) {
            return;
        }
        g.removeData(path);
    }

    @Override
    public String getGroupPermissionString(String world, String group, String path) {
        return this.getRawInfoString(world, group, path, true);
    }

    @Override
    public int getGroupPermissionInteger(String world, String group, String path) {
        Integer value = this.getRawInfoInteger(world, group, path, true);
        return value == null ? -1 : value;
    }

    @Override
    public boolean getGroupPermissionBoolean(String world, String group, String path) {
        Boolean value = this.getRawInfoBoolean(world, group, path, true);
        return value == null ? false : value;
    }

    @Override
    public double getGroupPermissionDouble(String world, String group, String path) {
        Double value = this.getRawInfoDouble(world, group, path, true);
        return value == null ? -1.0 : value;
    }

    @Override
    public String getUserPermissionString(String world, String name, String path) {
        return this.getRawInfoString(world, name, path, false);
    }

    @Override
    public int getUserPermissionInteger(String world, String name, String path) {
        Integer value = this.getRawInfoInteger(world, name, path, false);
        return value == null ? -1 : value;
    }

    @Override
    public boolean getUserPermissionBoolean(String world, String name, String path) {
        Boolean value = this.getRawInfoBoolean(world, name, path, false);
        return value == null ? false : value;
    }

    @Override
    public double getUserPermissionDouble(String world, String name, String path) {
        Double value = this.getRawInfoDouble(world, name, path, false);
        return value == null ? -1.0 : value;
    }

    @Override
    public String getPermissionString(String world, String name, String path) {
        return this.getInfoString(world, name, path, false);
    }

    @Override
    public int getPermissionInteger(String world, String name, String path) {
        Integer value = this.getInfoInteger(world, name, path, false);
        return value == null ? -1 : value;
    }

    @Override
    public boolean getPermissionBoolean(String world, String name, String path) {
        Boolean value = this.getInfoBoolean(world, name, path, false);
        return value == null ? false : value;
    }

    @Override
    public double getPermissionDouble(String world, String name, String path) {
        Double value = this.getInfoDouble(world, name, path, false);
        return value == null ? -1.0 : value;
    }

    @Override
    public String getGroup(String world, String user) {
        return this.getPrimaryGroup(world, user);
    }

    @Override
    public String getGroupPrefix(String world, String group) {
        return this.getGroupRawPrefix(world, group);
    }

    @Override
    public String getGroupSuffix(String world, String group) {
        return this.getGroupRawSuffix(world, group);
    }

    @Override
    public boolean canGroupBuild(String world, String group) {
        return this.canGroupRawBuild(world, group);
    }

    class TickTask
    implements Runnable {
        TickTask() {
        }

        @Override
        public void run() {
            ModularControl.this.tick();
        }
    }

    class RefreshTask
    implements Runnable {
        RefreshTask() {
        }

        @Override
        public void run() {
            ModularControl.this.storageReload();
        }
    }
}

