/*
 * Decompiled with CFR 0.152.
 */
package com.nijiko.permissions;

import com.nijiko.data.GroupStorage;
import com.nijiko.data.UserStorage;
import com.nijiko.permissions.Group;
import com.nijiko.permissions.ModularControl;
import com.nijiko.permissions.User;
import com.nijiko.permissions.WorldConfigLoadEvent;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.event.Event;

public class PermissionWorld {
    private final ModularControl controller;
    private final String world;
    private UserStorage userStore;
    private GroupStorage groupStore;
    private Map<String, User> users = new HashMap<String, User>();
    private Map<String, Group> groups = new HashMap<String, Group>();
    private Group defaultGroup;

    PermissionWorld(String world, ModularControl controller, UserStorage userStore, GroupStorage groupStore) {
        this.world = world;
        this.userStore = userStore;
        this.groupStore = groupStore;
        this.controller = controller;
    }

    public boolean reload() {
        if (this.world.equals("?") || this.userStore == null || this.groupStore == null || this.world.equals("?")) {
            return false;
        }
        if (this.userStore != null) {
            this.userStore.reload();
        }
        if (this.groupStore != null) {
            this.groupStore.reload();
        }
        this.defaultGroup = null;
        Map<String, Group> oldGroups = this.groups;
        HashMap<String, Group> newGroups = new HashMap<String, Group>();
        Set<String> groupNames = this.groupStore.getEntries();
        for (String groupName : groupNames) {
            Group group = new Group(this.controller, this.groupStore, groupName, this, false);
            Group oldGroup = oldGroups.get(groupName.toLowerCase());
            if (oldGroup != null) {
                group.copyTimedMap(oldGroup);
            }
            newGroups.put(groupName.toLowerCase(), group);
            if (!group.isDefault() || this.defaultGroup != null) continue;
            this.defaultGroup = group;
        }
        this.groups = newGroups;
        oldGroups = null;
        Map<String, User> oldUsers = this.users;
        HashMap<String, User> newUsers = new HashMap<String, User>();
        Set<String> userNames = this.userStore.getEntries();
        for (String userName : userNames) {
            User user = new User(this.controller, this.userStore, userName, this, false);
            User oldUser = oldUsers.get(userName.toLowerCase());
            if (oldUser != null) {
                user.copyTimedMap(oldUser);
            }
            newUsers.put(userName.toLowerCase(), user);
        }
        this.users = newUsers;
        oldUsers = null;
        Permissions.instance.getServer().getPluginManager().callEvent((Event)new WorldConfigLoadEvent(this.world));
        return true;
    }

    public void minorReload() {
        if (this.userStore != null) {
            this.userStore.reload();
        }
        if (this.groupStore != null) {
            this.groupStore.reload();
        }
        for (User u : this.users.values()) {
            u.clearTransientPerms();
        }
        for (Group g : this.groups.values()) {
            g.clearTransientPerms();
        }
    }

    public void save() {
        if (this.userStore != null) {
            this.userStore.forceSave();
        }
        if (this.groupStore != null) {
            this.groupStore.forceSave();
        }
    }

    public User getUserObject(String name) {
        return this.users.get(name.toLowerCase());
    }

    public Group getGroupObject(String name) {
        return this.groups.get(name.toLowerCase());
    }

    public User safeGetUser(String name) {
        User u = this.users.get(name.toLowerCase());
        if (u == null) {
            u = new User(this.controller, this.userStore, name, this, true);
            this.users.put(name.toLowerCase(), u);
        }
        return u;
    }

    public Group safeGetGroup(String name) {
        Group g = this.groups.get(name.toLowerCase());
        if (g == null) {
            g = new Group(this.controller, this.groupStore, name, this, true);
            this.groups.put(name.toLowerCase(), g);
        }
        return g;
    }

    public Group getDefaultGroup() {
        return this.defaultGroup;
    }

    public UserStorage getUserStorage() {
        return this.userStore;
    }

    public GroupStorage getGroupStorage() {
        return this.groupStore;
    }

    public boolean deleteUser(String name) {
        User u = this.getUserObject(name);
        if (u != null) {
            return u.delete();
        }
        return false;
    }

    void delUsr(String name) {
        this.users.remove(name.toLowerCase());
    }

    public boolean deleteGroup(String name) {
        Group g = this.getGroupObject(name);
        if (g != null) {
            return g.delete();
        }
        return false;
    }

    void delGrp(String name) {
        Group g = this.groups.remove(name.toLowerCase());
        if (g != null && g.equals(this.defaultGroup)) {
            this.defaultGroup = null;
        }
    }

    public Collection<User> getUsers() {
        return this.users.values();
    }

    public Collection<Group> getGroups() {
        return this.groups.values();
    }

    public Set<String> getTracks() {
        return this.groupStore.getTracks();
    }

    public String getWorldName() {
        return this.world;
    }

    void tick(long interval) {
        for (User u : this.users.values()) {
            u.tick(interval);
        }
    }
}

