/*
 * Decompiled with CFR 0.152.
 */
package com.nijikokun.bukkit.Permissions;

import com.nijiko.MessageHelper;
import com.nijiko.data.GroupWorld;
import com.nijiko.data.StorageFactory;
import com.nijiko.data.YamlCreator;
import com.nijiko.permissions.Entry;
import com.nijiko.permissions.Group;
import com.nijiko.permissions.ModularControl;
import com.nijiko.permissions.PermissionHandler;
import com.nijiko.permissions.User;
import com.nijikokun.bukkit.Permissions.Listener;
import com.nijikokun.bukkit.Permissions.PrWorldListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class Permissions
extends JavaPlugin {
    protected static final Logger log = Logger.getLogger("Minecraft.Permissions");
    public static Plugin instance;
    @Deprecated
    public static final String name = "Permissions";
    public static final String version = "3.1.6";
    public static final String codename = "Yeti";
    public Listener buildListener = new Listener(this);
    @Deprecated
    public static PermissionHandler Security;
    private String defaultWorld = "";
    private static final boolean autoComplete = true;
    private final YamlCreator yamlC;
    private int dist = 10;
    private final PrWorldListener wListener = new PrWorldListener();
    private boolean errorFlag = false;

    public Permissions() {
        this.yamlC = new YamlCreator();
        StorageFactory.registerDefaultCreator(this.yamlC);
        StorageFactory.registerCreator("YAML", this.yamlC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad() {
        instance = this;
        Properties prop = new Properties();
        FileInputStream in = null;
        this.getDataFolder().mkdirs();
        try {
            in = new FileInputStream(new File("server.properties"));
            prop.load(in);
            this.defaultWorld = prop.getProperty("level-name");
        }
        catch (IOException e) {
            System.err.println("[Permissions] Unable to read default world's name from server.properties.");
            e.printStackTrace();
            this.defaultWorld = "world";
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File storageOpt = new File("plugins" + File.separator + name + File.separator, "storageconfig.yml");
        storageOpt.getParentFile().mkdirs();
        if (!storageOpt.exists()) {
            try {
                System.out.println("[Permissions] Creating storageconfig.yml.");
                if (!storageOpt.createNewFile()) {
                    this.disable("[Permissions] Unable to create storageconfig.yml!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.disable("[Permissions] storageconfig.yml could not be created.");
                return;
            }
        }
        if (!storageOpt.isFile() || !storageOpt.canRead()) {
            this.disable("[Permissions] storageconfig.yml is not a file or is not readable.");
            return;
        }
        Configuration storageConfig = new Configuration(storageOpt);
        storageConfig.load();
        this.setupPermissions(storageConfig);
        log.info("[Permissions] (Yeti) was initialized.");
    }

    public void onDisable() {
        if (!this.errorFlag) {
            log.info("[Permissions] (Yeti) saving data...");
            this.getHandler().closeAll();
            log.info("[Permissions] (Yeti) saved all data.");
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        log.info("[Permissions] (Yeti) disabled successfully.");
    }

    private void disable(String error) {
        if (error != null) {
            log.severe(error);
        }
        log.severe("[Permissions] Shutting down Permissions due to error(s).");
        this.errorFlag = true;
    }

    public PermissionHandler getHandler() {
        return Security;
    }

    public void setupPermissions(Configuration storageConfig) {
        try {
            Security = new ModularControl(storageConfig);
            this.getHandler().setDefaultWorld(this.defaultWorld);
            this.getHandler().load();
            for (World w : this.getServer().getWorlds()) {
                this.getHandler().loadWorld(w.getName());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.disable("[Permissions] Unable to load permission data.");
            return;
        }
    }

    public void onEnable() {
        if (this.errorFlag) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        StorageFactory.registerDefaultCreator(this.yamlC);
        StorageFactory.registerCreator("YAML", this.yamlC);
        PluginDescriptionFile description = this.getDescription();
        log.info("[" + description.getName() + "] version [" + description.getVersion() + "] (" + codename + ")  loaded");
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_PLACE, (org.bukkit.event.Listener)this.buildListener, Event.Priority.High, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_BREAK, (org.bukkit.event.Listener)this.buildListener, Event.Priority.High, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.WORLD_LOAD, (org.bukkit.event.Listener)this.wListener, Event.Priority.Monitor, (Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        Entry entry;
        String world;
        Player player = null;
        PluginDescriptionFile pdfFile = this.getDescription();
        MessageHelper msg = new MessageHelper(sender);
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (Security == null) {
            msg.send("&4[Permissions] Permissions was unable to load data during server load.");
            msg.send("&4[Permissions] Please post the the portion of your server log since the server start/reload in the forums thread.");
            return true;
        }
        if (args.length == 0) {
            if (player != null) {
                msg.send("&7-------[ &fPermissions&7 ]-------");
                msg.send("&7Currently running version: &f[" + pdfFile.getVersion() + "] (" + codename + ")");
                if (this.getHandler().has(player.getWorld().getName(), player.getName(), "permissions.reload")) {
                    msg.send("&7Reload with: &f/permissions &a-reload &e<world>");
                    msg.send("&fLeave &e<world> blank to reload default world.");
                }
                msg.send("&7-------[ &fPermissions&7 ]-------");
                return true;
            }
            sender.sendMessage("[" + pdfFile.getName() + "] version [" + pdfFile.getVersion() + "] (" + codename + ")  loaded");
            return true;
        }
        if (args[0].equalsIgnoreCase("-reload")) {
            String world2;
            if (args.length > 1) {
                StringBuilder tempWorld = new StringBuilder();
                int val = this.extractQuoted(args, 1, tempWorld);
                switch (val) {
                    case -1: {
                        msg.send("&4[Permissions] Argument index error.");
                        return true;
                    }
                    case -2: {
                        msg.send("&4[Permissions] No ending quote found.");
                        return true;
                    }
                }
                world2 = tempWorld.toString();
            } else {
                world2 = "";
            }
            return this.reload(sender, world2);
        }
        if (args[0].equalsIgnoreCase("-load")) {
            String world3;
            if (args.length > 1) {
                StringBuilder tempWorld = new StringBuilder();
                int val = this.extractQuoted(args, 1, tempWorld);
                switch (val) {
                    case -1: {
                        msg.send("&4[Permissions] Argument index error.");
                        return true;
                    }
                    case -2: {
                        msg.send("&4[Permissions] No ending quote found.");
                        return true;
                    }
                }
                world3 = tempWorld.toString();
            } else {
                world3 = "";
            }
            if (player != null && !this.getHandler().has(player, "permissions.load." + world3)) {
                msg.send("&4[Permissions] You do not have permissions to use this command.");
                return true;
            }
            try {
                this.getHandler().forceLoadWorld(world3);
            }
            catch (Exception e) {
                msg.send("&4[Permissions] Error occured while loading world.");
                e.printStackTrace();
                return true;
            }
            msg.send("&7[Permissions] World loaded.");
            return true;
        }
        if (args[0].equalsIgnoreCase("-list")) {
            if (args.length > 1) {
                if (args[1].equalsIgnoreCase("worlds")) {
                    if (player != null && !this.getHandler().has(player, "permissions.list.worlds")) {
                        msg.send("&4[Permissions] You do not have permissions to use this command.");
                        return true;
                    }
                    Set<String> worlds = this.getHandler().getWorlds();
                    StringBuilder text = new StringBuilder();
                    if (worlds.isEmpty()) {
                        text.append("&4[Permissions] No worlds loaded.");
                    } else {
                        text.append("&a[Permissions] Loaded worlds: &b");
                        for (String world4 : worlds) {
                            text.append(world4).append(", ");
                        }
                        text.delete(text.length() - 2, text.length());
                    }
                    msg.send(text.toString());
                    return true;
                }
                if (args.length > 2) {
                    StringBuilder tempWorld = new StringBuilder();
                    int val = this.extractQuoted(args, 2, tempWorld);
                    switch (val) {
                        case -1: {
                            msg.send("&4[Permissions] Argument index error.");
                            return true;
                        }
                        case -2: {
                            msg.send("&4[Permissions] No ending quote found.");
                            return true;
                        }
                    }
                    String world5 = tempWorld.toString();
                    if (args[1].equalsIgnoreCase("users")) {
                        if (player != null && !this.getHandler().has(player, "permissions.list.users")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        Collection<User> users = this.getHandler().getUsers(world5);
                        msg.send(this.listEntries(users, "Users"));
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("groups")) {
                        if (player != null && !this.getHandler().has(player, "permissions.list.groups")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        Collection<Group> groups = this.getHandler().getGroups(world5);
                        msg.send(this.listEntries(groups, "Groups"));
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("tracks")) {
                        if (player != null && !this.getHandler().has(player, "permissions.list.tracks")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        Set<String> tracks = this.getHandler().getTracks(world5);
                        StringBuilder b = new StringBuilder();
                        b.append("&7[Permissions] &bTracks in world &c").append(world5).append("&b: &c");
                        for (String track : tracks) {
                            if (track == null) {
                                track = "<Default Track>";
                            }
                            b.append(track).append(", ");
                        }
                        int len = b.length();
                        b.delete(len - 2, len);
                        msg.send(b.toString());
                        return true;
                    }
                }
            }
            msg.send("&7[Permissions] Syntax: ");
            msg.send("&b/permissions &a-list &eworlds.");
            msg.send("&b/permissions &a-list &e[users|groups] &d<world>.");
            return true;
        }
        int currentArg = 0;
        boolean isGroup = args[0].startsWith("g:");
        String name = isGroup ? args[0].substring(2) : args[0];
        String string = world = sender instanceof Player ? ((Player)sender).getWorld().getName() : null;
        if (args.length > ++currentArg && args[currentArg].startsWith("w:")) {
            StringBuilder tempWorld = new StringBuilder();
            String[] tempArgs = new String[args.length];
            System.arraycopy(args, 0, tempArgs, 0, args.length);
            tempArgs[currentArg] = tempArgs[currentArg].substring(2);
            currentArg = this.extractQuoted(tempArgs, currentArg, tempWorld);
            switch (currentArg) {
                case -1: {
                    msg.send("&4[Permissions] Argument index error.");
                    return true;
                }
                case -2: {
                    msg.send("&4[Permissions] No ending quote found.");
                    return true;
                }
            }
            world = tempWorld.toString();
        }
        if (world == null) {
            msg.send("&4[Permissions] No world specified. Defaulting to default world.");
            world = this.defaultWorld;
        }
        Entry entry2 = entry = isGroup ? this.getHandler().getGroupObject(world, name) : this.getHandler().getUserObject(world, name);
        if (args.length > currentArg) {
            String text;
            String permNode;
            StringBuilder temp;
            String text2;
            if (args[currentArg].equalsIgnoreCase("create")) {
                if (player != null && !this.getHandler().has(player, "permissions.create")) {
                    msg.send("&4[Permissions] You do not have permissions to use this command.");
                    return true;
                }
                if (entry != null) {
                    msg.send("&4[Permissions] User/Group already exists.");
                    return true;
                }
                try {
                    entry = isGroup ? this.getHandler().safeGetGroup(world, name) : this.getHandler().safeGetUser(world, name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    msg.send("&4[Permissions] Error creating user/group.");
                    return true;
                }
                msg.send("&7[Permissions] User/Group created.");
                return true;
            }
            if (entry == null) {
                Player[] online;
                msg.send("&4[Permissions] User/Group does not exist.");
                Set<String> matches = this.getNames(isGroup ? this.getHandler().getGroups(world) : this.getHandler().getUsers(world));
                for (Player p : online = this.getServer().getOnlinePlayers()) {
                    matches.add(p.getName());
                }
                String closest = Permissions.getClosest(name, matches, this.dist);
                if (closest != null) {
                    msg.send("&7[Permissions]&b Using closest match &4" + closest + "&b.");
                    name = closest;
                    try {
                        entry = isGroup ? this.getHandler().safeGetGroup(world, name) : this.getHandler().safeGetUser(world, name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        msg.send("&4[Permissions] Error creating user/group.");
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (args[currentArg].equalsIgnoreCase("delete")) {
                if (player != null && !this.getHandler().has(player, "permissions.delete")) {
                    msg.send("&4[Permissions] You do not have permissions to use this command.");
                    return true;
                }
                String text3 = entry.delete() ? "&7[Permissions] User/Group deleted." : "&4[Permissions] Deletion failed.";
                msg.send(text3);
                return true;
            }
            if (args[currentArg].equalsIgnoreCase("has")) {
                ++currentArg;
                if (player != null && !this.getHandler().has(player, "permissions.has")) {
                    msg.send("&4[Permissions] You do not have permissions to use this command.");
                    return true;
                }
                if (args.length > currentArg) {
                    String permission = args[currentArg];
                    boolean has = entry.hasPermission(permission);
                    msg.send("&7[Permissions]&b User/Group " + (has ? "has" : "does not have") + " that permission.");
                    return true;
                }
                msg.send("&7[Permissions] Syntax: /pr (g:)<target> (w:<world>) has <permission>");
                return true;
            }
            if (args[currentArg].equalsIgnoreCase("perms")) {
                if (args.length > ++currentArg) {
                    Set<String> perms;
                    if (args[currentArg].equalsIgnoreCase("list")) {
                        if (player != null && !this.getHandler().has(player, "permissions.perms.list")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        perms = entry.getPermissions();
                        text2 = "";
                        if (perms == null || perms.isEmpty()) {
                            text2 = "&4[Permissions] User/Group has no non-inherited permissions.";
                        } else {
                            temp = new StringBuilder("&7[Permissions]&b Permissions: &c");
                            for (String perm : perms) {
                                temp.append(perm).append("&b,&c ");
                            }
                            text2 = temp.substring(0, temp.length() - 6);
                        }
                        msg.send(text2);
                        return true;
                    }
                    if (args[currentArg].equalsIgnoreCase("listall")) {
                        if (player != null && !this.getHandler().has(player, "permissions.perms.listall")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        perms = entry.getAllPermissions();
                        text2 = "&7[Permissions]&b Permissions: &c";
                        if (perms == null || perms.isEmpty()) {
                            text2 = "&4[Permissions] User/Group has no permissions.";
                        } else {
                            temp = new StringBuilder("&7[Permissions]&b Permissions: &c");
                            for (String perm : perms) {
                                temp.append(perm).append("&b,&c ");
                            }
                            text2 = temp.substring(0, temp.length() - 6);
                        }
                        msg.send(text2);
                        return true;
                    }
                    if (args[currentArg].equalsIgnoreCase("add") || args[currentArg].equalsIgnoreCase("remove")) {
                        boolean add = args[currentArg].equalsIgnoreCase("add");
                        String string2 = permNode = add ? "permissions.perms.add" : "permissions.perms.remove";
                        if (player != null && !this.getHandler().has(player, permNode)) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        String string3 = text = add ? "&7[Permissions]&b Permission added successfully." : "&7[Permissions]&b Permission removed successfully.";
                        if (args.length > ++currentArg) {
                            String permission = args[currentArg];
                            Set<String> perms2 = entry.getPermissions();
                            if (!(perms2.contains(permission) ^ add)) {
                                text = "&4[Permissions] User/Group already has that permission.";
                            } else {
                                entry.setPermission(permission, add);
                            }
                        }
                        msg.send(text);
                        return true;
                    }
                }
                msg.send("&7[Permissions] Syntax: ");
                msg.send("&b/permissions &a(g:)<target> (w:<world>) perms list");
                msg.send("&b/permissions &a(g:)<target> (w:<world>) perms [add|remove] <node>");
                return true;
            }
            if (args[currentArg].equalsIgnoreCase("parents")) {
                if (args.length > ++currentArg) {
                    LinkedHashSet<Entry> parents;
                    if (args[currentArg].equalsIgnoreCase("list")) {
                        if (player != null && !this.getHandler().has(player, "permissions.parents.list")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        parents = entry.getParents();
                        text2 = "&7[Permissions]&b Parents: &c";
                        if (parents == null || parents.isEmpty()) {
                            text2 = "&4[Permissions] User/Group has no parents.";
                        } else {
                            temp = new StringBuilder("&7[Permissions]&b Parents: &c");
                            for (Entry parent : parents) {
                                temp.append(parent.toString()).append("&b,&c ");
                            }
                            text2 = temp.substring(0, temp.length() - 6);
                        }
                        msg.send(text2);
                        return true;
                    }
                    if (args[currentArg].equalsIgnoreCase("listall")) {
                        if (player != null && !this.getHandler().has(player, "permissions.parents.listall")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        parents = entry.getAncestors();
                        text2 = "&7[Permissions]&b All parents: &c";
                        if (parents == null || parents.isEmpty()) {
                            text2 = "&4[Permissions] User/Group has no parents.";
                        } else {
                            temp = new StringBuilder("&7[Permissions]&b Parents: &c");
                            for (Entry parent : parents) {
                                temp.append(parent.toString()).append("&b,&c ");
                            }
                            text2 = temp.substring(0, temp.length() - 6);
                        }
                        msg.send(text2);
                        return true;
                    }
                    if (args[currentArg].equalsIgnoreCase("add") || args[currentArg].equalsIgnoreCase("remove")) {
                        boolean add = args[currentArg].equalsIgnoreCase("add");
                        String string4 = permNode = add ? "permissions.parents.add" : "permissions.parents.remove";
                        if (player != null && !this.getHandler().has(player, permNode)) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        String string5 = text = add ? "&7[Permissions]&b Parent added successfully." : "&7[Permissions]&b Parent removed successfully.";
                        if (args.length > ++currentArg) {
                            String parentName = args[currentArg];
                            String parentWorld = world;
                            if (args.length > ++currentArg) {
                                StringBuilder tempWorld = new StringBuilder();
                                currentArg = this.extractQuoted(args, currentArg, tempWorld);
                                switch (currentArg) {
                                    case -1: {
                                        msg.send("&4[Permissions] Argument index error.");
                                        return true;
                                    }
                                    case -2: {
                                        msg.send("&4[Permissions] No ending quote found.");
                                        return true;
                                    }
                                }
                                parentWorld = tempWorld.toString();
                            }
                            LinkedHashSet<GroupWorld> parents2 = entry.getRawParents();
                            if (add && parents2.contains(new GroupWorld(parentWorld, parentName))) {
                                text = "&4[Permissions] User/Group already has that parent.";
                            }
                            if (!add && !parents2.contains(new GroupWorld(parentWorld, parentName))) {
                                text = "&4[Permissions] User/Group does not have such a parent.";
                            } else {
                                Group parent = this.getHandler().getGroupObject(parentWorld, parentName);
                                if (parent == null) {
                                    text = "&4[Permissions] No such group exists.";
                                } else if (add) {
                                    entry.addParent(parent);
                                } else {
                                    entry.removeParent(parent);
                                }
                            }
                        }
                        msg.send(text);
                        return true;
                    }
                }
                msg.send("&7[Permissions] Syntax: ");
                msg.send("&b/permissions &a(g:)<target> (w:<world>) parents list");
                msg.send("&b/permissions &a(g:)<target> (w:<world>) parents [add|remove] <parentname> (parentworld)");
                return true;
            }
            if (args[currentArg].equalsIgnoreCase("info")) {
                if (args.length > ++currentArg) {
                    String path;
                    String choice = args[currentArg];
                    if (choice.equalsIgnoreCase("get")) {
                        ++currentArg;
                        if (player != null && !this.getHandler().has(player, "permissions.info.get")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        if (args.length > currentArg) {
                            path = args[currentArg];
                            msg.send("&7[Permissions]&b " + entry.getString(path));
                            return true;
                        }
                    } else if (choice.equalsIgnoreCase("set")) {
                        ++currentArg;
                        if (player != null && !this.getHandler().has(player, "permissions.info.set")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        if (args.length > currentArg) {
                            path = args[currentArg];
                            if (args.length > ++currentArg) {
                                Object newValue;
                                String newValueString = args[currentArg];
                                String type = "";
                                try {
                                    if (newValueString.startsWith("b:")) {
                                        newValue = Boolean.valueOf(newValueString.substring(2));
                                        type = "Boolean";
                                    } else if (newValueString.startsWith("d:")) {
                                        newValue = Double.valueOf(newValueString.substring(2));
                                        type = "Double";
                                    } else if (newValueString.startsWith("i:")) {
                                        newValue = Integer.valueOf(newValueString.substring(2));
                                        type = "Integer";
                                    } else {
                                        newValue = newValueString;
                                        type = "String";
                                    }
                                }
                                catch (NumberFormatException e) {
                                    msg.send("&4[Permissions]&b Error encountered when parsing value.");
                                    return true;
                                }
                                entry.setData(path, newValue);
                                msg.send("&7[Permissions]&b &a" + path + "&b set to &a" + type + " &c" + newValue.toString());
                                return true;
                            }
                        }
                    } else if (choice.equalsIgnoreCase("remove")) {
                        ++currentArg;
                        if (player != null && !this.getHandler().has(player, "permissions.info.remove")) {
                            msg.send("&4[Permissions] You do not have permissions to use this command.");
                            return true;
                        }
                        if (args.length > currentArg) {
                            path = args[currentArg];
                            entry.removeData(path);
                            msg.send("&7[Permissions]&b &a" + path + "&b cleared.");
                            return true;
                        }
                    }
                }
                msg.send("&7[Permissions] Syntax: ");
                msg.send("&b/permissions &a(g:)<target> (w:<world>) info get <path>");
                msg.send("&b/permissions &a(g:)<target> (w:<world>) info set <path> (i:|d:|b:)<data>");
                return true;
            }
            if (args[currentArg].equalsIgnoreCase("dumpcache")) {
                if (player != null && !this.getHandler().has(player, "permissions.debug.dumpcache")) {
                    msg.send("&4[Permissions] You do not have permissions to use this command.");
                    return true;
                }
                msg.send("&7[Permissions]&b Cache: &f");
                msg.send(entry.getCache().toString());
                return true;
            }
            if (entry instanceof User) {
                User user = (User)entry;
                if (args[currentArg].equalsIgnoreCase("promote") || args[currentArg].equalsIgnoreCase("demote")) {
                    Set<String> tracks;
                    boolean isPromote = args[currentArg].equalsIgnoreCase("promote");
                    if (player != null && !this.getHandler().has(player, isPromote ? "permissions.promote" : "permissions.demote")) {
                        msg.send("&4[Permissions] You do not have permissions to use this command.");
                        return true;
                    }
                    String trackName = null;
                    String parentName = null;
                    String parentWorld = world;
                    if (args.length > ++currentArg) {
                        String temp2 = args[currentArg];
                        if (temp2.startsWith("t:")) {
                            trackName = temp2.substring(2);
                        } else {
                            parentName = temp2;
                        }
                        ++currentArg;
                    }
                    if ((tracks = this.getHandler().getTracks(world)) == null || tracks.isEmpty()) {
                        msg.send("&4[Permissions] No tracks in specified world.");
                        return true;
                    }
                    if (!tracks.contains(trackName)) {
                        msg.send("&4[Permissions] Specified track does not exist.");
                        return true;
                    }
                    Group parent = null;
                    if (args.length > currentArg) {
                        if (parentName == null) {
                            parentName = args[currentArg];
                            if (args.length > ++currentArg) {
                                parentWorld = args[currentArg];
                            }
                        } else {
                            parentWorld = args[currentArg];
                            ++currentArg;
                        }
                        parent = this.getHandler().getGroupObject(parentWorld, parentName);
                    } else {
                        parent = user.getPrimaryGroup();
                    }
                    if (parent == null) {
                        msg.send("&4[Permissions] Specified parent group does not exist.");
                        return true;
                    }
                    if (!user.getParents(null).contains(parent)) {
                        msg.send("&4[Permissions] User is not a child of the specified parent group.");
                        return true;
                    }
                    boolean result = false;
                    result = isPromote ? user.promote(parent, trackName) : user.demote(parent, trackName);
                    if (result) {
                        msg.send("&7[Permissions] Promotion/demotion successful.");
                    } else {
                        msg.send("&7[Permissions] Promotion/demotion failed.");
                    }
                    return true;
                }
                msg.send("&7[Permissions] Syntax: /permissions <target> (w:<world>) [promote|demote] (t:<track>) (<parent>) (w:<parentworld>)");
            }
            msg.send("&b/permissions &a(g:)<target> (w:<world>) [perms|parents] [list|add|remove] ...");
            msg.send("&b/permissions &a(g:)<target> (w:<world>) info [get|set|remove] ...");
        }
        return false;
    }

    private boolean reload(CommandSender sender, String arg) {
        Player p = null;
        if (sender instanceof Player) {
            p = (Player)sender;
        }
        if (arg == null || arg.equals("")) {
            if (p != null && !this.getHandler().has(p.getWorld().getName(), p.getName(), "permissions.reload.default")) {
                p.sendMessage(ChatColor.RED + "[Permissions] You lack the necessary permissions to perform this action.");
                return true;
            }
            this.getHandler().reload(this.defaultWorld);
            sender.sendMessage(ChatColor.GRAY + "[Permissions] Default world reloaded.");
            return true;
        }
        if (arg.equalsIgnoreCase("all")) {
            if (p != null && !this.getHandler().has(p.getWorld().getName(), p.getName(), "permissions.reload.all")) {
                p.sendMessage(ChatColor.RED + "[Permissions] You lack the necessary permissions to perform this action.");
                return true;
            }
            this.getHandler().reload();
            sender.sendMessage(ChatColor.GRAY + "[Permissions] All worlds reloaded.");
            return true;
        }
        if (p != null && !this.getHandler().has(p.getWorld().getName(), p.getName(), "permissions.reload." + arg)) {
            p.sendMessage(ChatColor.RED + "[Permissions] You lack the necessary permissions to perform this action.");
            return true;
        }
        if (this.getHandler().reload(arg)) {
            sender.sendMessage(ChatColor.GRAY + "[Permissions] Reload of World " + arg + " completed.");
        } else {
            sender.sendMessage(ChatColor.GRAY + "[Permissions] World " + arg + " does not exist.");
        }
        return true;
    }

    public String toString() {
        PluginDescriptionFile pdf = this.getDescription();
        return pdf.getName() + " version " + pdf.getVersion() + " (" + codename + ")";
    }

    private String listEntries(Collection<? extends Entry> entries, String type) {
        StringBuilder text = new StringBuilder();
        if (entries == null) {
            text.append("&4[Permissions] World does not exist.");
        } else if (entries.isEmpty()) {
            text.append("&4[Permissions] No ").append(type.toLowerCase()).append(" in that world.");
        } else {
            text.append("&a[Permissions] " + type + ": &b");
            for (Entry entry : entries) {
                text.append(entry.getName()).append(", ");
            }
            text.delete(text.length() - 2, text.length());
        }
        return text.toString();
    }

    private int extractQuoted(String[] args, int currentArg, StringBuilder target) {
        if (args.length <= currentArg) {
            return -1;
        }
        target.append(args[currentArg]);
        ++currentArg;
        if (target.charAt(0) != '\"') {
            return currentArg;
        }
        target.deleteCharAt(0);
        while (args.length > currentArg) {
            target.append(" ").append(args[currentArg]);
            ++currentArg;
            if (target.charAt(target.length() - 1) != '\"') continue;
            target.deleteCharAt(target.length() - 1);
            return currentArg;
        }
        return -2;
    }

    private Set<String> getNames(Collection<? extends Entry> entries) {
        HashSet<String> names = new HashSet<String>();
        for (Entry entry : entries) {
            if (entry == null) continue;
            names.add(entry.getName());
        }
        return names;
    }

    public static String getClosest(String word, Set<String> dict, int threshold) {
        if (word == null || word.isEmpty() || dict == null || dict.isEmpty()) {
            return null;
        }
        if (dict.contains(word)) {
            return word;
        }
        String result = null;
        int currentDist = threshold;
        String lw = word.toLowerCase();
        for (String s : dict) {
            int dist;
            String ls;
            if (s == null || !(ls = s.toLowerCase()).startsWith(lw) || currentDist <= (dist = s.length() - word.length())) continue;
            result = s;
            currentDist = dist;
        }
        return result;
    }
}

