/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.converters;

import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.sql.PhysDB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.bukkit.command.CommandSender;

public class ChastityChest
implements Runnable {
    private String[] CHESTS_FILES = new String[]{"ChastityChest.chests", "ChastityChest/ChastityChest.chests"};
    private int converted = 0;
    private PhysDB physicalDatabase;
    private CommandSender player;

    public ChastityChest() {
        new Thread(this).start();
        this.physicalDatabase = new PhysDB();
    }

    public ChastityChest(CommandSender player) {
        this();
        this.player = player;
    }

    public void convertChests() throws FileNotFoundException, IOException {
        String line;
        String path;
        File file = null;
        String[] arr$ = this.CHESTS_FILES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(file = new File(path = arr$[i$])).exists(); ++i$) {
        }
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("No Chastity Chest database found");
        }
        int lineNumber = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] split;
            line = line.trim();
            ++lineNumber;
            if (line.startsWith("#") || (split = line.split("=")).length < 2) continue;
            int[] coords = this.splitCoordinates(split[0]);
            int x = coords[0];
            int y = coords[1];
            int z = coords[2];
            String owner = split[1];
            int type = 2;
            this.log(String.format("Registering chest to %s at location {%d,%d,%d}", owner, x, y, z));
            this.physicalDatabase.registerProtection(0, type, "", owner, "", x, y, z);
            ++this.converted;
        }
        reader.close();
    }

    public void log(String str) {
        System.out.println(str);
        if (this.player != null) {
            this.player.sendMessage(str);
        }
    }

    @Override
    public void run() {
        try {
            this.log("LWC Conversion tool for Chastity Chest chests");
            this.log("");
            LWCPlugin plugin = new LWCPlugin();
            plugin.loadDatabase();
            this.physicalDatabase = new PhysDB();
            this.physicalDatabase.connect();
            this.physicalDatabase.load();
            this.convertChests();
            this.log("Done.");
            this.log("");
            this.log("Converted >" + this.converted + "< Chest Protect chests to LWC");
            this.log("LWC database now holds " + this.physicalDatabase.getProtectionCount() + " protected chests!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int[] splitCoordinates(String str) {
        int[] coords = new int[3];
        String[] split = str.split("-");
        int index = 0;
        boolean _neg = false;
        for (String string : split) {
            if (string.isEmpty()) {
                _neg = true;
                continue;
            }
            coords[index] = Integer.parseInt((_neg ? "-" : "") + string);
            _neg = false;
            ++index;
        }
        return coords;
    }

    public static void main(String[] args) throws Exception {
        new ChastityChest();
    }
}

