/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.integration.currency;

import com.griefcraft.integration.ICurrency;
import com.griefcraft.util.config.Configuration;
import com.iConomy.iConomy;
import com.iConomy.system.Account;
import com.iConomy.system.Holdings;
import com.iConomy.util.Constants;
import org.bukkit.entity.Player;

public class iConomy5Currency
implements ICurrency {
    private Configuration configuration = Configuration.load("iconomy.yml");
    private String serverAccount = this.configuration.getString("iConomy.serverBankAccount", "");

    public iConomy5Currency() {
        if (!this.serverAccount.isEmpty()) {
            iConomy.getAccount((String)this.serverAccount);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean usingCentralBank() {
        return !this.serverAccount.isEmpty();
    }

    @Override
    public String format(double money) {
        return iConomy.format((double)money);
    }

    @Override
    public String getMoneyName() {
        return (String)Constants.Major.get(1);
    }

    @Override
    public double getBalance(Player player) {
        if (player == null) {
            return 0.0;
        }
        Account account = iConomy.getAccount((String)player.getName());
        if (account == null) {
            return 0.0;
        }
        return account.getHoldings().balance();
    }

    @Override
    public boolean canAfford(Player player, double money) {
        if (player == null) {
            return false;
        }
        Account account = iConomy.getAccount((String)player.getName());
        return account != null && account.getHoldings().hasEnough(money);
    }

    public boolean canCentralBankAfford(double money) {
        if (!this.usingCentralBank()) {
            return true;
        }
        Account account = iConomy.getAccount((String)this.serverAccount);
        return account != null && account.getHoldings().hasEnough(money);
    }

    @Override
    public double addMoney(Player player, double money) {
        Account account;
        if (player == null) {
            return 0.0;
        }
        if (this.usingCentralBank()) {
            if (!this.canCentralBankAfford(money)) {
                return 0.0;
            }
            Account central = iConomy.getAccount((String)this.serverAccount);
            if (central == null) {
                return 0.0;
            }
            central.getHoldings().subtract(money);
        }
        if ((account = iConomy.getAccount((String)player.getName())) == null) {
            return 0.0;
        }
        Holdings holdings = account.getHoldings();
        holdings.add(money);
        return holdings.balance();
    }

    @Override
    public double removeMoney(Player player, double money) {
        Account account;
        if (player == null) {
            return 0.0;
        }
        if (money < 0.0) {
            money = -money;
        }
        if (this.usingCentralBank()) {
            Account central = iConomy.getAccount((String)this.serverAccount);
            if (central == null) {
                return 0.0;
            }
            central.getHoldings().add(money);
        }
        if ((account = iConomy.getAccount((String)player.getName())) == null) {
            return 0.0;
        }
        Holdings holdings = account.getHoldings();
        if (!holdings.hasEnough(money)) {
            return holdings.balance();
        }
        holdings.subtract(money);
        return holdings.balance();
    }
}

