/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.ContainerBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class LWCPlayerListener
extends PlayerListener {
    private LWCPlugin plugin;

    public LWCPlayerListener(LWCPlugin plugin) {
        this.plugin = plugin;
    }

    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        Player player = event.getPlayer();
        Item item = event.getItemDrop();
        ItemStack itemStack = item.getItemStack();
        Module.Result result = this.plugin.getLWC().getModuleLoader().dispatchEvent(ModuleLoader.Event.DROP_ITEM, player, item, itemStack);
        LWCDropItemEvent evt = new LWCDropItemEvent(player, event);
        this.plugin.getLWC().getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled() || result == Module.Result.CANCEL) {
            event.setCancelled(true);
        }
    }

    public void onPlayerChat(PlayerChatEvent event) {
        if (!this.plugin.getLWC().getConfiguration().getBoolean("core.filterunlock", true)) {
            return;
        }
        String message = event.getMessage();
        if (message.startsWith("cunlock")) {
            event.setCancelled(true);
        }
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        Location location = clickedBlock.getLocation();
        CraftWorld craftWorld = (CraftWorld)clickedBlock.getWorld();
        CraftBlock block = new CraftBlock((CraftChunk)craftWorld.getChunkAt(location), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        block.setTypeId(craftWorld.getBlockTypeIdAt(location));
        Material material = block.getType();
        if (block.getState() instanceof ContainerBlock && !lwc.hasPermission(player, "lwc.protect") && lwc.hasPermission(player, "lwc.deny") && !lwc.isAdmin(player) && !lwc.isMod(player)) {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.blocked", new Object[0]);
            event.setCancelled(true);
            return;
        }
        try {
            boolean ignoreRightClick;
            boolean ignoreLeftClick;
            List<String> actions = lwc.getMemoryDatabase().getActions(player.getName());
            Protection protection = lwc.findProtection((Block)block);
            Module.Result result = Module.Result.CANCEL;
            boolean canAccess = lwc.canAccessProtection(player, protection);
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            if (event.getAction() == Action.LEFT_CLICK_BLOCK ? (ignoreLeftClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(material, "ignoreLeftClick"))) : event.getAction() == Action.RIGHT_CLICK_BLOCK && (ignoreRightClick = Boolean.parseBoolean(lwc.resolveProtectionConfiguration(material, "ignoreRightClick")))) {
                return;
            }
            if (protection != null) {
                result = lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.INTERACT_PROTECTION, player, protection, actions, canAccess, canAdmin);
                if (result == Module.Result.DEFAULT) {
                    LWCProtectionInteractEvent evt = new LWCProtectionInteractEvent(event, protection, actions, canAccess, canAdmin);
                    lwc.getModuleLoader().dispatchEvent(evt);
                    result = evt.getResult();
                }
            } else {
                result = lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.INTERACT_BLOCK, player, block, actions);
                if (result == Module.Result.DEFAULT) {
                    LWCBlockInteractEvent evt = new LWCBlockInteractEvent(event, (Block)block, actions);
                    lwc.getModuleLoader().dispatchEvent(evt);
                    result = evt.getResult();
                }
            }
            if (result == Module.Result.ALLOW) {
                return;
            }
            if (result == Module.Result.DEFAULT) {
                lwc.enforceAccess(player, (Block)(protection != null ? protection.getBlock() : block));
            }
            if (!canAccess || result == Module.Result.CANCEL) {
                event.setCancelled(true);
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        catch (Exception e) {
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "PLAYER_INTERACT");
            e.printStackTrace();
        }
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!LWC.ENABLED) {
            return;
        }
        LWC lwc = this.plugin.getLWC();
        String player = event.getPlayer().getName();
        lwc.getMemoryDatabase().unregisterPlayer(player);
        lwc.getMemoryDatabase().unregisterUnlock(player);
        lwc.getMemoryDatabase().unregisterPendingLock(player);
        lwc.getMemoryDatabase().unregisterAllActions(player);
        lwc.getMemoryDatabase().unregisterAllModes(player);
    }
}

