/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.migration;

import com.griefcraft.lwc.LWC;
import com.griefcraft.migration.MigrationUtility;
import com.griefcraft.model.AccessRight;
import com.griefcraft.model.History;
import com.griefcraft.model.Protection;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;

public class MySQLPost200
implements MigrationUtility {
    private static Logger logger = Logger.getLogger("Patcher");

    @Override
    public void run() {
        LWC lwc = LWC.getInstance();
        PhysDB physicalDatabase = lwc.getPhysicalDatabase();
        if (physicalDatabase.getType() != Database.Type.MySQL) {
            return;
        }
        String database = lwc.getConfiguration().getString("database.path");
        if (database == null || database.equals("")) {
            return;
        }
        File file = new File(database);
        if (!file.exists()) {
            return;
        }
        logger.info("######################################################");
        logger.info("######################################################");
        logger.info("SQLite to MySQL conversion required");
        logger.info("Loading SQLite");
        PhysDB sqliteDatabase = new PhysDB(Database.Type.SQLite);
        try {
            List<Object> tmp;
            sqliteDatabase.connect();
            sqliteDatabase.load();
            logger.info("SQLite is good to go");
            physicalDatabase.getConnection().setAutoCommit(false);
            logger.info("Preliminary scan...............");
            int startProtections = physicalDatabase.getProtectionCount();
            int protectionCount = sqliteDatabase.getProtectionCount();
            int rightsCount = sqliteDatabase.getRightsCount();
            int historyCount = sqliteDatabase.getHistoryCount();
            int expectedProtections = protectionCount + startProtections;
            logger.info("TO CONVERT:");
            logger.info("Protections:\t" + protectionCount);
            logger.info("Rights:\t\t" + rightsCount);
            logger.info("History:\t" + historyCount);
            logger.info("");
            if (protectionCount > 0) {
                logger.info("Converting: PROTECTIONS");
                tmp = sqliteDatabase.loadProtections();
                for (Protection protection : tmp) {
                    int x = protection.getX();
                    int y = protection.getY();
                    int z = protection.getZ();
                    physicalDatabase.registerProtection(protection.getBlockId(), protection.getType(), protection.getWorld(), protection.getOwner(), protection.getData(), x, y, z);
                    Protection registered = physicalDatabase.loadProtection(protection.getWorld(), x, y, z);
                    List<AccessRight> tmpRights = sqliteDatabase.loadRights(protection.getId());
                    for (AccessRight right : tmpRights) {
                        physicalDatabase.registerProtectionRights(registered.getId(), right.getName(), right.getRights(), right.getType());
                    }
                }
                logger.info("COMMITTING");
                physicalDatabase.getConnection().commit();
                logger.info("OK , expecting: " + expectedProtections);
                protectionCount = physicalDatabase.getProtectionCount();
                if (expectedProtections == protectionCount) {
                    logger.info("OK.");
                } else {
                    logger.info("Weird, only " + protectionCount + " protections are in the database? Continuing...");
                }
            }
            if (historyCount > 0) {
                logger.info("Converting: HISTORY");
                tmp = sqliteDatabase.loadHistory();
                for (History history : tmp) {
                    history.setExists(false);
                    history.sync();
                }
                logger.info("OK");
            }
            logger.info("Closing SQLite");
            sqliteDatabase.getConnection().close();
            logger.info("Renaming \"" + database + "\" to \"" + database + ".old\"");
            if (!file.renameTo(new File(database + ".old"))) {
                logger.info("NOTICE: FAILED TO RENAME lwc.db!! Please rename this manually!");
            }
            logger.info("SQLite to MySQL conversion is now complete!\n");
            logger.info("Thank you!");
        }
        catch (Exception e) {
            logger.info("#### SEVERE ERROR: Something bad happened when converting the database (Oops!)");
            e.printStackTrace();
        }
        try {
            physicalDatabase.getConnection().setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        logger.info("######################################################");
        logger.info("######################################################");
    }
}

