/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.create;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.AccessRight;
import com.griefcraft.model.Action;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.sql.MemDB;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("create")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        if (protection.getOwner().equals(player.getName())) {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.alreadyregistered", "block", LWC.materialToString(protection.getBlockId()));
        } else {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.notowner", "block", LWC.materialToString(protection.getBlockId()));
        }
        lwc.removeModes(player);
        event.setResult(Module.Result.CANCEL);
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("create")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!lwc.isProtectable(block)) {
            return;
        }
        PhysDB physDb = lwc.getPhysicalDatabase();
        MemDB memDb = lwc.getMemoryDatabase();
        Action action = memDb.getAction("create", player.getName());
        String actionData = action.getData();
        String[] split = actionData.split(" ");
        String protectionType = split[0].toLowerCase();
        String protectionData = StringUtils.join(split, 1);
        if (!lwc.hasPermission((CommandSender)player, "lwc.create." + protectionType, "lwc.create", "lwc.protect")) {
            lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
            lwc.removeModes(player);
            event.setResult(Module.Result.CANCEL);
            return;
        }
        String playerName = player.getName();
        String worldName = block.getWorld().getName();
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        lwc.removeModes(player);
        Module.Result registerProtection = lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.REGISTER_PROTECTION, player, block);
        LWCProtectionRegisterEvent evt = new LWCProtectionRegisterEvent(player, block);
        lwc.getModuleLoader().dispatchEvent(evt);
        if (evt.isCancelled() || registerProtection == Module.Result.CANCEL) {
            return;
        }
        Protection protection = null;
        if (protectionType.equals("public")) {
            protection = physDb.registerProtection(block.getTypeId(), 0, worldName, playerName, "", blockX, blockY, blockZ);
            lwc.sendLocale((CommandSender)player, "protection.interact.create.finalize", new Object[0]);
        } else if (protectionType.equals("password")) {
            String password = lwc.encrypt(protectionData);
            protection = physDb.registerProtection(block.getTypeId(), 1, worldName, playerName, password, blockX, blockY, blockZ);
            memDb.registerPlayer(playerName, protection.getId());
            lwc.sendLocale((CommandSender)player, "protection.interact.create.finalize", new Object[0]);
            lwc.sendLocale((CommandSender)player, "protection.interact.create.password", new Object[0]);
        } else if (protectionType.equals("private")) {
            String[] rights = protectionData.split(" ");
            protection = physDb.registerProtection(block.getTypeId(), 2, worldName, playerName, "", blockX, blockY, blockZ);
            lwc.sendLocale((CommandSender)player, "protection.interact.create.finalize", new Object[0]);
            for (String right : rights) {
                String lowered;
                boolean admin = false;
                int type = 1;
                if (right.isEmpty()) continue;
                if (right.startsWith("@")) {
                    admin = true;
                    right = right.substring(1);
                }
                if ((lowered = right.toLowerCase()).startsWith("g:")) {
                    type = 0;
                    right = right.substring(2);
                }
                if (lowered.startsWith("l:")) {
                    type = 2;
                    right = right.substring(2);
                }
                if (lowered.startsWith("list:")) {
                    type = 2;
                    right = right.substring(5);
                }
                String localeChild = AccessRight.typeToString(type).toLowerCase();
                physDb.registerProtectionRights(protection.getId(), right, admin ? 1 : 0, type);
                lwc.sendLocale((CommandSender)player, "protection.interact.rights.register." + localeChild, "name", right, "isadmin", admin ? "[\u00a74ADMIN\u00a76]" : "");
                protection.removeCache();
            }
        } else if (protectionType.equals("trap")) {
            String[] splitData = protectionData.split(" ");
            String type = splitData[0].toLowerCase();
            String reason = "";
            if (splitData.length > 1) {
                reason = StringUtils.join(splitData, 1);
            }
            int tmpType = 3;
            if (type.equals("ban")) {
                tmpType = 4;
            }
            protection = physDb.registerProtection(block.getTypeId(), tmpType, worldName, playerName, reason, blockX, blockY, blockZ);
            lwc.sendLocale((CommandSender)player, "protection.interact.create.finalize", new Object[0]);
        }
        if (protection != null) {
            lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.POST_REGISTRATION, protection);
            lwc.getModuleLoader().dispatchEvent(new LWCProtectionRegistrationPostEvent(protection));
        }
        event.setResult(Module.Result.CANCEL);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("c", "create")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!(sender instanceof Player)) {
            return;
        }
        if (args.length == 0) {
            lwc.sendLocale(sender, "help.creation", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        String full = StringUtils.join(args, 0);
        String type = args[0].toLowerCase();
        String data = StringUtils.join(args, 1);
        event.setCancelled(true);
        if (!lwc.hasPermission(sender, "lwc.create." + type, "lwc.create", "lwc.protect")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        if (type.equals("trap")) {
            if (!lwc.isAdmin(player)) {
                lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
                return;
            }
            if (args.length < 2) {
                lwc.sendSimpleUsage((CommandSender)player, "/lwc -c trap <kick/ban> [reason]");
                return;
            }
        } else if (type.equals("password")) {
            if (args.length < 2) {
                lwc.sendSimpleUsage((CommandSender)player, "/lwc -c password <Password>");
                return;
            }
            String hiddenPass = StringUtils.transform(data, '*');
            lwc.sendLocale((CommandSender)player, "protection.create.password", "password", hiddenPass);
        } else if (!type.equals("public") && !type.equals("private")) {
            lwc.sendLocale((CommandSender)player, "help.creation", new Object[0]);
            return;
        }
        MemDB db = lwc.getMemoryDatabase();
        db.unregisterAllActions(player.getName());
        db.registerAction("create", player.getName(), full);
        lwc.sendLocale((CommandSender)player, "protection.create.finalize", "type", lwc.getLocale(type, new Object[0]));
    }
}

