/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.doors;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.config.Configuration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.material.Door;
import org.bukkit.plugin.Plugin;

public class DoorsModule
extends JavaModule {
    private Configuration configuration;
    private LinkedList<DoorAction> doors;
    private Action action;
    private int interval;
    private boolean enabled;

    @Override
    public void load(LWC lwc) {
        this.configuration = Configuration.load("doors.yml");
        this.doors = new LinkedList();
        this.enabled = this.configuration.getBoolean("doors.enabled", true);
        String action = this.configuration.getString("doors.action");
        if (action == null) {
            this.action = Action.NULL;
            return;
        }
        if (action.equalsIgnoreCase("openAndClose")) {
            this.action = Action.OPEN_AND_CLOSE;
            this.interval = this.configuration.getInt("doors.interval", 3);
        } else if (action.equalsIgnoreCase("toggle")) {
            this.action = Action.TOGGLE;
        }
        DoorTask doorTask = new DoorTask();
        lwc.getPlugin().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)lwc.getPlugin(), (Runnable)doorTask, 20L, 20L);
    }

    private byte initializeDoorData(Door door) {
        byte data = 0;
        switch (door.getHingeCorner()) {
            case NORTH_EAST: {
                data = (byte)(data | 0);
                break;
            }
            case SOUTH_EAST: {
                data = (byte)(data | 1);
                break;
            }
            case SOUTH_WEST: {
                data = (byte)(data | 2);
                break;
            }
            case NORTH_WEST: {
                data = (byte)(data | 3);
            }
        }
        if (door.isTopHalf()) {
            data = (byte)(data | 8);
        }
        return data;
    }

    private boolean isDoorOpen(Door door) {
        switch (door.getHingeCorner()) {
            default: 
        }
        return door.isOpen();
    }

    private boolean isValid(Material material) {
        return material == Material.IRON_DOOR_BLOCK || material == Material.WOODEN_DOOR;
    }

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() == Module.Result.CANCEL) {
            return;
        }
        if (!this.enabled || this.action == Action.NULL) {
            return;
        }
        if (!event.canAccess()) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        List<Block> blocks = lwc.getProtectionSet(protection.getBukkitWorld(), protection.getX(), protection.getY(), protection.getZ());
        if (protection.getBlockId() == Material.WOODEN_DOOR.getId()) {
            blocks.clear();
        }
        boolean sentMessage = false;
        if (this.configuration.getBoolean("doors.doubleDoors", true)) {
            BlockFace[] faces;
            Block protectionBlock = protection.getBlock();
            for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
                Protection found;
                Block temp = protectionBlock.getRelative(face);
                if (!this.isValid(temp.getType()) || (found = lwc.findProtection(temp)) == null || !lwc.canAccessProtection(player, found)) continue;
                blocks.addAll(lwc.getProtectionSet(found.getBukkitWorld(), found.getX(), found.getY(), found.getZ()));
            }
        }
        for (Block block : blocks) {
            if (!this.isValid(block.getType())) continue;
            Door door = new Door(block.getType(), block.getData());
            byte data = this.initializeDoorData(door);
            switch (this.action) {
                case TOGGLE: {
                    if ((block.getData() & 4) != 4) {
                        data = (byte)(data | 4);
                    }
                    if (sentMessage) break;
                    sentMessage = true;
                    if (!this.isDoorOpen(door)) break;
                    break;
                }
                case OPEN_AND_CLOSE: {
                    if ((block.getData() & 4) != 4) {
                        data = (byte)(data | 4);
                    }
                    if (!sentMessage) {
                        sentMessage = true;
                        if (this.isDoorOpen(door)) {
                            // empty if block
                        }
                    }
                    if (this.isDoorOpen(door)) break;
                    Location location = new Location(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
                    DoorAction doorAction = new DoorAction();
                    doorAction.location = location;
                    doorAction.triggerTime = System.currentTimeMillis() + (long)this.interval * 1000L;
                    this.doors.push(doorAction);
                }
            }
            block.setData(data);
        }
    }

    private class DoorTask
    implements Runnable {
        private DoorTask() {
        }

        @Override
        public void run() {
            Iterator iter = DoorsModule.this.doors.iterator();
            while (iter.hasNext()) {
                DoorAction doorAction = (DoorAction)iter.next();
                Location location = doorAction.location;
                if (System.currentTimeMillis() <= doorAction.triggerTime) continue;
                Block block = location.getBlock();
                Door door = new Door(block.getType(), block.getData());
                byte data = DoorsModule.this.initializeDoorData(door);
                if (DoorsModule.this.isDoorOpen(door) && (block.getData() & 4) != 4) {
                    data = (byte)(data | 4);
                }
                block.setData(data);
                iter.remove();
            }
        }
    }

    static enum Action {
        OPEN_AND_CLOSE,
        TOGGLE,
        NULL;

    }

    class DoorAction {
        public Location location;
        public long triggerTime;

        DoorAction() {
        }
    }
}

