/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.ModuleException;
import com.griefcraft.sql.DriverStub;
import com.griefcraft.util.config.Configuration;
import com.mysql.jdbc.exceptions.jdbc4.CommunicationsException;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

public abstract class Database {
    public Type currentType;
    private Map<String, PreparedStatement> statementCache = new HashMap<String, PreparedStatement>();
    protected Connection connection = null;
    protected Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    public static Type DefaultType = Type.NONE;
    private boolean connected = false;
    protected boolean loaded = false;
    protected String prefix = "";

    public Database() {
        this.currentType = DefaultType;
        this.prefix = LWC.getInstance().getConfiguration().getString("database.prefix", "");
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    public Database(Type currentType) {
        this();
        this.currentType = currentType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected void printException(Exception exception) {
        if (exception instanceof CommunicationsException) {
            try {
                this.connect();
            }
            catch (Exception e) {
                throw new ModuleException(e);
            }
            return;
        }
        throw new ModuleException(exception);
    }

    public boolean connect() throws Exception {
        if (this.connection != null) {
            return true;
        }
        if (this.currentType == null || this.currentType == Type.NONE) {
            this.log("Invalid database engine");
            return false;
        }
        ClassLoader classLoader = this.currentType == Type.SQLite ? new URLClassLoader(new URL[]{new URL("jar:file:" + new File("plugins/LWC/lib/" + this.currentType.getDriver()).getPath() + "!/")}) : Bukkit.getServer().getClass().getClassLoader();
        String className = "";
        className = this.currentType == Type.MySQL ? "com.mysql.jdbc.Driver" : "org.sqlite.JDBC";
        Driver driver = (Driver)classLoader.loadClass(className).newInstance();
        DriverManager.registerDriver(new DriverStub(driver));
        Properties properties = new Properties();
        if (this.currentType == Type.MySQL) {
            LWC lwc = LWC.getInstance();
            properties.put("autoReconnect", "true");
            properties.put("user", lwc.getConfiguration().getString("database.username"));
            properties.put("password", lwc.getConfiguration().getString("database.password"));
        }
        this.connection = DriverManager.getConnection("jdbc:" + this.currentType.toString().toLowerCase() + ":" + this.getDatabasePath(), properties);
        this.connected = true;
        return true;
    }

    public void dispose() {
        this.statementCache.clear();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDatabasePath() {
        Configuration lwcConfiguration = LWC.getInstance().getConfiguration();
        if (this.currentType == Type.MySQL) {
            return "//" + lwcConfiguration.getString("database.host") + "/" + lwcConfiguration.getString("database.database");
        }
        return lwcConfiguration.getString("database.path");
    }

    public Type getType() {
        return this.currentType;
    }

    public abstract void load();

    public void log(String str) {
        this.logger.info("LWC: " + str);
    }

    protected void postPrepare() {
    }

    public PreparedStatement prepare(String sql) {
        return this.prepare(sql, false);
    }

    public PreparedStatement prepare(String sql, boolean returnGeneratedKeys) {
        if (this.connection == null) {
            return null;
        }
        if (this.statementCache.containsKey(sql)) {
            this.postPrepare();
            return this.statementCache.get(sql);
        }
        try {
            PreparedStatement preparedStatement = returnGeneratedKeys ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
            this.statementCache.put(sql, preparedStatement);
            this.postPrepare();
            return preparedStatement;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean addColumn(String table, String column, String type) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " ADD " + column + " " + type);
    }

    public boolean renameTable(String table, String newName) {
        return this.executeUpdateNoException("ALTER TABLE " + table + " RENAME TO " + newName);
    }

    public boolean dropTable(String table) {
        return this.executeUpdateNoException("DROP TABLE " + table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeUpdateNoException(String query) {
        Statement statement = null;
        boolean exception = false;
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            exception = true;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {}
        }
        return exception;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static enum Type {
        MySQL("mysql.jar"),
        SQLite("sqlite.jar"),
        NONE("nil");

        private String driver;

        private Type(String driver) {
            this.driver = driver;
        }

        public String getDriver() {
            return this.driver;
        }
    }
}

