/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LWCResourceBundle
extends ResourceBundle {
    private List<ResourceBundle> extensionBundles = new ArrayList<ResourceBundle>();

    public LWCResourceBundle(ResourceBundle parent) {
        this.parent = parent;
    }

    public void addExtensionBundle(ResourceBundle bundle) {
        if (bundle == null) {
            return;
        }
        this.extensionBundles.add(bundle);
    }

    @Override
    public Enumeration<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.parent.keySet());
        for (ResourceBundle bundle : this.extensionBundles) {
            keys.addAll(bundle.keySet());
        }
        return Collections.enumeration(keys);
    }

    private Object getObjectFromExtensionBundles(String key) {
        try {
            for (ResourceBundle bundle : this.extensionBundles) {
                Object object = bundle.getObject(key);
                if (object == null) continue;
                return object;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected Object handleGetObject(String key) {
        Object object = null;
        object = this.getObjectFromExtensionBundles(key);
        if (object != null) {
            return object;
        }
        return this.parent.getObject(key);
    }
}

