/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import java.security.MessageDigest;
import java.util.Formatter;

public class StringUtils {
    public static long parseTime(String time) {
        long seconds = 0L;
        String[] split = time.split(" ");
        for (int index = 0; index < split.length; ++index) {
            if (index == 0) continue;
            String sub = split[index].toLowerCase();
            int multiplier = 0;
            long unit = 0L;
            try {
                multiplier = Integer.parseInt(split[index - 1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (sub.startsWith("second")) {
                unit = 1L;
            } else if (sub.startsWith("minute")) {
                unit = 60L;
            } else if (sub.startsWith("hour")) {
                unit = 3600L;
            } else if (sub.startsWith("day")) {
                unit = 86400L;
            } else if (sub.startsWith("week")) {
                unit = 604800L;
            } else if (sub.startsWith("month")) {
                unit = 2629743L;
            } else if (sub.startsWith("year")) {
                unit = 31556926L;
            }
            seconds += (long)multiplier * unit;
        }
        return seconds;
    }

    public static String timeToString(long time) {
        String str = "";
        if (System.currentTimeMillis() / 1000L - time == 0L) {
            return "Not yet known";
        }
        long days = time / 86400L;
        long hours = (time -= days * 86400L) / 3600L;
        long minutes = (time -= hours * 3600L) / 60L;
        long seconds = time -= minutes * 60L;
        if (days > 0L) {
            str = str + days + " day" + (days == 1L ? "" : "s") + " ";
        }
        if (hours > 0L) {
            str = str + hours + " hour" + (hours == 1L ? "" : "s") + " ";
        }
        if (minutes > 0L) {
            str = str + minutes + " minute" + (minutes == 1L ? "" : "s") + " ";
        }
        if (seconds > 0L) {
            str = str + seconds + " second" + (seconds == 1L ? "" : "s") + " ";
        }
        return str.trim();
    }

    public static String capitalizeFirstLetter(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        char[] string = str.toLowerCase().toCharArray();
        string[0] = Character.toUpperCase(string[0]);
        for (int index = 0; index < string.length; ++index) {
            if (string[index] != ' ' || index == string.length) continue;
            string[index + 1] = Character.toUpperCase(string[index + 1]);
        }
        return new String(string);
    }

    public static String encrypt(String plaintext) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
            md.update(plaintext.getBytes("UTF-8"));
            byte[] raw = md.digest();
            return StringUtils.byteArray2Hex(raw);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean hasFlag(String[] args, String checkFlag) {
        String flag = args[0].toLowerCase();
        return flag.equals(checkFlag) || flag.equals("-" + checkFlag);
    }

    public static boolean hasFlag(String command, String checkFlag) {
        return command.equals(checkFlag) || command.equals("-" + checkFlag);
    }

    public static String join(String[] arr, int offset) {
        return StringUtils.join(arr, offset, " ");
    }

    public static String join(String[] arr, int offset, String delim) {
        String str = "";
        if (arr == null || arr.length == 0) {
            return str;
        }
        for (int i = offset; i < arr.length; ++i) {
            str = str + arr[i] + delim;
        }
        return str.trim();
    }

    public static String transform(String str, char chr) {
        char[] charArray = str.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = chr;
        }
        return new String(charArray);
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }
}

