/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class UpdateThread
implements Runnable {
    private Map<Integer, Protection> protectionUpdateQueue = Collections.synchronizedMap(new HashMap());
    private boolean flush = false;
    private long lastUpdate = -1L;
    private Logger logger = Logger.getLogger("Cache");
    private LWC lwc;
    private boolean running = false;
    private Thread thread;

    public UpdateThread(LWC lwc) {
        this.lwc = lwc;
        this.running = true;
        this.lastUpdate = System.currentTimeMillis();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void flush() {
        this._flush();
    }

    public int size() {
        return this.protectionUpdateQueue.size();
    }

    public void queueProtectionUpdate(Protection protection) {
        this.protectionUpdateQueue.put(protection.getId(), protection);
    }

    public void unqueueProtectionUpdate(Protection protection) {
        if (this.protectionUpdateQueue.containsKey(protection.getId())) {
            this.protectionUpdateQueue.remove(protection.getId());
        }
    }

    @Override
    public void run() {
        while (this.running) {
            long interval;
            if (this.flush) {
                this._flush();
                continue;
            }
            int flushInterval = this.lwc.getConfiguration().getInt("core.flushInterval", 5);
            long curr = System.currentTimeMillis();
            if (curr - this.lastUpdate > (interval = (long)flushInterval * 1000L)) {
                this.flush = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
    }

    public void stop() {
        this.running = false;
        this._flush();
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
    }

    private void _flush() {
        if (this.protectionUpdateQueue.size() > 0) {
            Connection connection = this.lwc.getPhysicalDatabase().getConnection();
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            for (Map.Entry<Integer, Protection> entry : this.protectionUpdateQueue.entrySet()) {
                Protection protection = entry.getValue();
                protection.saveNow();
            }
            this.protectionUpdateQueue.clear();
            try {
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.flush = false;
        this.lastUpdate = System.currentTimeMillis();
    }
}

