/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.util.BukkitUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import org.bukkit.Location;

public class BlockChange
implements LookupCacheElement {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
    public final long id;
    public final long date;
    public final Location loc;
    public final String playerName;
    public final int replaced;
    public final int type;
    public final byte data;
    public final String signtext;
    public final ChestAccess ca;

    public BlockChange(long l, Location location, String string, int n, int n2, byte by, String string2, ChestAccess chestAccess) {
        this.id = 0L;
        this.date = l;
        this.loc = location;
        this.playerName = string;
        this.replaced = n;
        this.type = n2;
        this.data = by;
        this.signtext = string2;
        this.ca = chestAccess;
    }

    public BlockChange(ResultSet resultSet, QueryParams queryParams) throws SQLException {
        this.id = queryParams.needId ? (long)resultSet.getInt("id") : 0L;
        this.date = queryParams.needDate ? resultSet.getTimestamp("date").getTime() : 0L;
        this.loc = queryParams.needCoords ? new Location(queryParams.world, (double)resultSet.getInt("x"), (double)resultSet.getInt("y"), (double)resultSet.getInt("z")) : null;
        this.playerName = queryParams.needPlayer ? resultSet.getString("playername") : null;
        this.replaced = queryParams.needType ? resultSet.getInt("replaced") : 0;
        this.type = queryParams.needType ? resultSet.getInt("type") : 0;
        this.data = queryParams.needData ? resultSet.getByte("data") : (byte)0;
        this.signtext = queryParams.needSignText ? resultSet.getString("signtext") : null;
        this.ca = queryParams.needChestAccess && resultSet.getShort("itemtype") != 0 && resultSet.getShort("itemamount") != 0 ? new ChestAccess(resultSet.getShort("itemtype"), resultSet.getShort("itemamount"), resultSet.getByte("itemdata")) : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.date > 0L) {
            stringBuilder.append(formatter.format(this.date) + " ");
        }
        if (this.playerName != null) {
            stringBuilder.append(this.playerName + " ");
        }
        if (this.signtext != null) {
            String string;
            String string2 = string = this.type == 0 ? "destroyed " : "created ";
            if (!this.signtext.contains("\u0000")) {
                stringBuilder.append(string + this.signtext);
            } else {
                stringBuilder.append(string + BukkitUtils.materialName(this.type != 0 ? this.type : this.replaced) + " [" + this.signtext.replace("\u0000", "] [") + "]");
            }
        } else if (this.type == this.replaced) {
            if (this.type == 0) {
                stringBuilder.append("did a unspecified action");
            } else if (this.ca != null) {
                if (this.ca.itemType == 0 || this.ca.itemAmount == 0) {
                    stringBuilder.append("looked inside " + BukkitUtils.materialName(this.type));
                } else if (this.ca.itemAmount < 0) {
                    stringBuilder.append("took " + -this.ca.itemAmount + "x " + BukkitUtils.materialName(this.ca.itemType, this.ca.itemData));
                } else {
                    stringBuilder.append("put in " + this.ca.itemAmount + "x " + BukkitUtils.materialName(this.ca.itemType, this.ca.itemData));
                }
            } else if (this.type == 23 || this.type == 54 || this.type == 61 || this.type == 62) {
                stringBuilder.append("opened " + BukkitUtils.materialName(this.type));
            } else if (this.type == 64 || this.type == 71 || this.type == 96 || this.type == 107) {
                stringBuilder.append((this.data == 0 ? "opened" : "closed") + " " + BukkitUtils.materialName(this.type));
            } else if (this.type == 69) {
                stringBuilder.append("swiched " + BukkitUtils.materialName(this.type));
            } else if (this.type == 77) {
                stringBuilder.append("pressed " + BukkitUtils.materialName(this.type));
            } else if (this.type == 92) {
                stringBuilder.append("ate a piece of " + BukkitUtils.materialName(this.type));
            }
        } else if (this.type == 0) {
            stringBuilder.append("destroyed " + BukkitUtils.materialName(this.replaced, this.data));
        } else if (this.replaced == 0) {
            stringBuilder.append("created " + BukkitUtils.materialName(this.type, this.data));
        } else {
            stringBuilder.append("replaced " + BukkitUtils.materialName(this.replaced, (byte)0) + " with " + BukkitUtils.materialName(this.type, this.data));
        }
        if (this.loc != null) {
            stringBuilder.append(" at " + this.loc.getBlockX() + ":" + this.loc.getBlockY() + ":" + this.loc.getBlockZ());
        }
        return stringBuilder.toString();
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

