/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.util.BukkitUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.getspout.spoutapi.event.inventory.InventoryCloseEvent;
import org.getspout.spoutapi.event.inventory.InventoryListener;
import org.getspout.spoutapi.event.inventory.InventoryOpenEvent;

class LBChestAccessListener
extends InventoryListener {
    private final Consumer consumer;
    private final Map<Integer, ItemStack[]> containers = new HashMap<Integer, ItemStack[]>();

    LBChestAccessListener(LogBlock logBlock) {
        this.consumer = logBlock.getConsumer();
    }

    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        if (!inventoryCloseEvent.isCancelled() && inventoryCloseEvent.getLocation() != null && this.containers.containsKey(inventoryCloseEvent.getPlayer().getName().hashCode())) {
            ItemStack[] itemStackArray;
            String string = inventoryCloseEvent.getPlayer().getName();
            Location location = inventoryCloseEvent.getLocation();
            ItemStack[] itemStackArray2 = this.containers.get(string.hashCode());
            ItemStack[] itemStackArray3 = BukkitUtils.compressInventory(inventoryCloseEvent.getInventory().getContents());
            for (ItemStack itemStack : itemStackArray = BukkitUtils.compareInventories(itemStackArray2, itemStackArray3)) {
                this.consumer.queueChestAccess(string, location, location.getWorld().getBlockTypeIdAt(location), (short)itemStack.getTypeId(), (short)itemStack.getAmount(), BukkitUtils.rawData(itemStack));
            }
            this.containers.remove(string.hashCode());
        }
    }

    public void onInventoryOpen(InventoryOpenEvent inventoryOpenEvent) {
        if (!inventoryOpenEvent.isCancelled() && inventoryOpenEvent.getLocation() != null && inventoryOpenEvent.getLocation().getBlock().getTypeId() != 58) {
            this.containers.put(inventoryOpenEvent.getPlayer().getName().hashCode(), BukkitUtils.compressInventory(inventoryOpenEvent.getInventory().getContents()));
        }
    }
}

