/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.WorldConfig;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerQuitEvent;

class LBPlayerListener
extends PlayerListener {
    private final Consumer consumer;
    private final Map<Integer, WorldConfig> worlds;

    LBPlayerListener(LogBlock logBlock) {
        this.consumer = logBlock.getConsumer();
        this.worlds = logBlock.getConfig().worlds;
    }

    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent playerBucketEmptyEvent) {
        WorldConfig worldConfig = this.worlds.get(playerBucketEmptyEvent.getPlayer().getWorld().getName().hashCode());
        if (!playerBucketEmptyEvent.isCancelled() && worldConfig != null && worldConfig.logBlockPlacings) {
            this.consumer.queueBlockPlace(playerBucketEmptyEvent.getPlayer().getName(), playerBucketEmptyEvent.getBlockClicked().getRelative(playerBucketEmptyEvent.getBlockFace()).getLocation(), playerBucketEmptyEvent.getBucket() == Material.WATER_BUCKET ? 9 : 11, (byte)0);
        }
    }

    public void onPlayerBucketFill(PlayerBucketFillEvent playerBucketFillEvent) {
        WorldConfig worldConfig = this.worlds.get(playerBucketFillEvent.getPlayer().getWorld().getName().hashCode());
        if (!playerBucketFillEvent.isCancelled() && worldConfig != null && worldConfig.logBlockBreaks) {
            this.consumer.queueBlockBreak(playerBucketFillEvent.getPlayer().getName(), playerBucketFillEvent.getBlockClicked().getState());
        }
    }

    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        WorldConfig worldConfig = this.worlds.get(playerInteractEvent.getPlayer().getWorld().getName().hashCode());
        if (!(playerInteractEvent.isCancelled() || worldConfig == null || playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK)) {
            int n = playerInteractEvent.getClickedBlock().getTypeId();
            if (worldConfig.logButtonsAndLevers && (n == 69 || n == 77)) {
                this.consumer.queueBlock(playerInteractEvent.getPlayer().getName(), playerInteractEvent.getClickedBlock().getLocation(), n, n, (byte)0);
            } else if (worldConfig.logDoors && (n == 64 || n == 96 || n == 107 && playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK)) {
                this.consumer.queueBlock(playerInteractEvent.getPlayer().getName(), playerInteractEvent.getClickedBlock().getLocation(), n, n, (byte)((playerInteractEvent.getClickedBlock().getData() & 4) / 4));
            } else if (worldConfig.logCakes && n == 92 && playerInteractEvent.getPlayer().getHealth() < 20) {
                this.consumer.queueBlock(playerInteractEvent.getPlayer().getName(), playerInteractEvent.getClickedBlock().getLocation(), n, n, (byte)0);
            }
        }
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        WorldConfig worldConfig = this.worlds.get(playerCommandPreprocessEvent.getPlayer().getWorld().getName().hashCode());
        if (worldConfig != null && worldConfig.logChat) {
            this.consumer.queueChat(playerCommandPreprocessEvent.getPlayer().getName(), playerCommandPreprocessEvent.getMessage());
        }
    }

    public void onPlayerChat(PlayerChatEvent playerChatEvent) {
        WorldConfig worldConfig = this.worlds.get(playerChatEvent.getPlayer().getWorld().getName().hashCode());
        if (worldConfig != null && worldConfig.logChat) {
            this.consumer.queueChat(playerChatEvent.getPlayer().getName(), playerChatEvent.getMessage());
        }
    }

    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        this.consumer.queueJoin(playerJoinEvent.getPlayer());
    }

    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        this.consumer.queueLeave(playerQuitEvent.getPlayer());
    }
}

