/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Session;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class QueryParams
implements Cloneable {
    private static final Set<Integer> keywords = new HashSet<Integer>(Arrays.asList("player".hashCode(), "area".hashCode(), "selection".hashCode(), "sel".hashCode(), "block".hashCode(), "type".hashCode(), "sum".hashCode(), "destroyed".hashCode(), "created".hashCode(), "chestaccess".hashCode(), "all".hashCode(), "time".hashCode(), "since".hashCode(), "before".hashCode(), "limit".hashCode(), "world".hashCode(), "asc".hashCode(), "desc".hashCode(), "last".hashCode(), "coords".hashCode(), "silent".hashCode(), "chat".hashCode(), "search".hashCode(), "match".hashCode()));
    public BlockChangeType bct = BlockChangeType.BOTH;
    public int limit = -1;
    public int before = 0;
    public int since = 0;
    public int radius = -1;
    public Location loc = null;
    public Order order = Order.DESC;
    public List<String> players = new ArrayList<String>();
    public boolean excludePlayersMode = false;
    public boolean prepareToolQuery = false;
    public boolean silent = false;
    public Selection sel = null;
    public SummarizationMode sum = SummarizationMode.NONE;
    public List<Integer> types = new ArrayList<Integer>();
    public World world = null;
    public String match = null;
    public boolean needId = false;
    public boolean needDate = false;
    public boolean needType = false;
    public boolean needData = false;
    public boolean needPlayer = false;
    public boolean needCoords = false;
    public boolean needSignText = false;
    public boolean needChestAccess = false;
    public boolean needMessage = false;
    private final LogBlock logblock;

    public QueryParams(LogBlock logBlock) {
        this.logblock = logBlock;
    }

    public QueryParams(LogBlock logBlock, CommandSender commandSender, List<String> list) throws IllegalArgumentException {
        this.logblock = logBlock;
        this.parseArgs(commandSender, list);
    }

    public static boolean isKeyWord(String string) {
        return keywords.contains(string.toLowerCase().hashCode());
    }

    public String getLimit() {
        return this.limit > 0 ? "LIMIT " + this.limit : "";
    }

    public String getQuery() {
        if (this.bct == BlockChangeType.CHAT) {
            String string = "SELECT ";
            String string2 = "FROM `lb-chat` ";
            if (this.needId) {
                string = string + "id, ";
            }
            if (this.needDate) {
                string = string + "date, ";
            }
            if (this.needPlayer) {
                string = string + "playername, ";
            }
            if (this.needPlayer || this.players.size() > 0) {
                string2 = string2 + "INNER JOIN `lb-players` USING (playerid) ";
            }
            if (this.needMessage) {
                string = string + "message, ";
            }
            return string.substring(0, string.length() - 2) + " " + string2 + this.getWhere() + "ORDER BY date " + (Object)((Object)this.order) + ", id " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        if (this.sum == SummarizationMode.NONE) {
            String string = "SELECT ";
            String string3 = "FROM `" + this.getTable() + "` ";
            if (this.needId) {
                string = string + "`" + this.getTable() + "`.id, ";
            }
            if (this.needDate) {
                string = string + "date, ";
            }
            if (this.needType) {
                string = string + "replaced, type, ";
            }
            if (this.needData) {
                string = string + "data, ";
            }
            if (this.needPlayer) {
                string = string + "playername, ";
            }
            if (this.needPlayer || this.players.size() > 0) {
                string3 = string3 + "INNER JOIN `lb-players` USING (playerid) ";
            }
            if (this.needCoords) {
                string = string + "x, y, z, ";
            }
            if (this.needSignText) {
                string = string + "signtext, ";
                string3 = string3 + "LEFT JOIN `" + this.getTable() + "-sign` USING (id) ";
            }
            if (this.needChestAccess) {
                string = string + "itemtype, itemamount, itemdata, ";
                string3 = string3 + "LEFT JOIN `" + this.getTable() + "-chest` USING (id) ";
            }
            return string.substring(0, string.length() - 2) + " " + string3 + this.getWhere() + "ORDER BY date " + (Object)((Object)this.order) + ", id " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        if (this.sum == SummarizationMode.TYPES) {
            return "SELECT type, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT type, count(type) AS created, 0 AS destroyed FROM `" + this.getTable() + "` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(BlockChangeType.CREATED) + "GROUP BY type) UNION (SELECT replaced AS type, 0 AS created, count(replaced) AS destroyed FROM `" + this.getTable() + "` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(BlockChangeType.DESTROYED) + "GROUP BY replaced)) AS t GROUP BY type ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        return "SELECT playername, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT playerid, count(type) AS created, 0 AS destroyed FROM `" + this.getTable() + "` " + this.getWhere(BlockChangeType.CREATED) + "GROUP BY playerid) UNION (SELECT playerid, 0 AS created, count(replaced) AS destroyed FROM `" + this.getTable() + "` " + this.getWhere(BlockChangeType.DESTROYED) + "GROUP BY playerid)) AS t INNER JOIN `lb-players` USING (playerid) GROUP BY playerid ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
    }

    public String getTable() {
        return this.logblock.getConfig().worlds.get((Object)Integer.valueOf((int)this.world.getName().hashCode())).table;
    }

    public String getTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.bct == BlockChangeType.CHESTACCESS) {
            stringBuilder.append("chest accesses ");
        } else if (this.bct == BlockChangeType.CHAT) {
            stringBuilder.append("chat messages ");
        } else {
            if (!this.types.isEmpty()) {
                String[] stringArray = new String[this.types.size()];
                for (int i = 0; i < this.types.size(); ++i) {
                    stringArray[i] = BukkitUtils.materialName(this.types.get(i));
                }
                stringBuilder.append(Utils.listing(stringArray, ", ", " and ") + " ");
            } else {
                stringBuilder.append("block ");
            }
            if (this.bct == BlockChangeType.CREATED) {
                stringBuilder.append("creations ");
            } else if (this.bct == BlockChangeType.DESTROYED) {
                stringBuilder.append("destructions ");
            } else {
                stringBuilder.append("changes ");
            }
        }
        if (this.players.size() > 10) {
            stringBuilder.append((this.excludePlayersMode ? "without" : "from") + " many players ");
        } else if (!this.players.isEmpty()) {
            stringBuilder.append((this.excludePlayersMode ? "without" : "from") + " player" + (this.players.size() != 1 ? "s" : "") + " " + Utils.listing(this.players.toArray(new String[this.players.size()]), ", ", " and ") + " ");
        }
        if (this.match != null && this.match.length() > 0) {
            stringBuilder.append("matching '" + this.match + "' ");
        }
        if (this.before > 0 && this.since > 0) {
            stringBuilder.append("between " + this.since + " and " + this.before + " minutes ago ");
        } else if (this.since > 0) {
            stringBuilder.append("in the last " + this.since + " minutes ");
        } else if (this.before > 0) {
            stringBuilder.append("more than " + this.before * -1 + " minutes ago ");
        }
        if (this.loc != null) {
            if (this.radius > 0) {
                stringBuilder.append("within " + this.radius + " blocks of " + (this.prepareToolQuery ? "clicked block" : "you") + " ");
            } else if (this.radius == 0) {
                stringBuilder.append("at " + this.loc.getBlockX() + ":" + this.loc.getBlockY() + ":" + this.loc.getBlockZ() + " ");
            }
        } else if (this.sel != null) {
            stringBuilder.append(this.prepareToolQuery ? "at double chest " : "inside selection ");
        } else if (this.prepareToolQuery) {
            if (this.radius > 0) {
                stringBuilder.append("within " + this.radius + " blocks of clicked block ");
            } else if (this.radius == 0) {
                stringBuilder.append("at clicked block ");
            }
        }
        if (!(this.world == null || this.sel != null && this.prepareToolQuery)) {
            stringBuilder.append("in " + BukkitUtils.friendlyWorldname(this.world.getName()) + " ");
        }
        if (this.sum != SummarizationMode.NONE) {
            stringBuilder.append("summed up by " + (this.sum == SummarizationMode.TYPES ? "blocks" : "players") + " ");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.setCharAt(0, String.valueOf(stringBuilder.charAt(0)).toUpperCase().toCharArray()[0]);
        return stringBuilder.toString();
    }

    public String getWhere() {
        return this.getWhere(this.bct);
    }

    public String getWhere(BlockChangeType blockChangeType) {
        StringBuilder stringBuilder = new StringBuilder("WHERE ");
        if (blockChangeType == BlockChangeType.CHAT) {
            if (this.match != null && this.match.length() > 0) {
                boolean bl = this.match.startsWith("-");
                if (this.match.length() > 3 && !bl || this.match.length() > 4) {
                    stringBuilder.append("MATCH (message) AGAINST ('" + this.match + "' IN BOOLEAN MODE) AND ");
                } else {
                    stringBuilder.append("message " + (bl ? "NOT " : "") + "LIKE '%" + (bl ? this.match.substring(1) : this.match) + "%' AND ");
                }
            }
        } else {
            switch (blockChangeType) {
                case ALL: {
                    if (this.types.isEmpty()) break;
                    stringBuilder.append('(');
                    for (int n : this.types) {
                        stringBuilder.append("type = " + n + " OR replaced = " + n + " OR ");
                    }
                    stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length() - 1);
                    stringBuilder.append(") AND ");
                    break;
                }
                case BOTH: {
                    stringBuilder.append("type <> replaced AND ");
                    if (this.types.isEmpty()) break;
                    stringBuilder.append('(');
                    for (int n : this.types) {
                        stringBuilder.append("type = " + n + " OR replaced = " + n + " OR ");
                    }
                    stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
                    stringBuilder.append(") AND ");
                    break;
                }
                case CREATED: {
                    stringBuilder.append("type <> replaced AND ");
                    if (!this.types.isEmpty()) {
                        stringBuilder.append('(');
                        for (int n : this.types) {
                            stringBuilder.append("type = " + n + " OR ");
                        }
                        stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
                        stringBuilder.append(") AND ");
                        break;
                    }
                    stringBuilder.append("type > 0 AND ");
                    break;
                }
                case DESTROYED: {
                    stringBuilder.append("type <> replaced AND ");
                    if (!this.types.isEmpty()) {
                        stringBuilder.append('(');
                        for (int n : this.types) {
                            stringBuilder.append("replaced = " + n + " OR ");
                        }
                        stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
                        stringBuilder.append(") AND ");
                        break;
                    }
                    stringBuilder.append("replaced > 0 AND ");
                    break;
                }
                case CHESTACCESS: {
                    stringBuilder.append("type = replaced AND (type = 23 OR type = 54 OR type = 61 OR type = 62) AND ");
                    if (this.types.isEmpty()) break;
                    stringBuilder.append('(');
                    for (int n : this.types) {
                        stringBuilder.append("itemtype = " + n + " OR ");
                    }
                    stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
                    stringBuilder.append(") AND ");
                }
            }
            if (this.loc != null) {
                if (this.radius == 0) {
                    stringBuilder.append("x = '" + this.loc.getBlockX() + "' AND y = '" + this.loc.getBlockY() + "' AND z = '" + this.loc.getBlockZ() + "' AND ");
                } else if (this.radius > 0) {
                    stringBuilder.append("x > '" + (this.loc.getBlockX() - this.radius) + "' AND x < '" + (this.loc.getBlockX() + this.radius) + "' AND z > '" + (this.loc.getBlockZ() - this.radius) + "' AND z < '" + (this.loc.getBlockZ() + this.radius) + "' AND ");
                }
            } else if (this.sel != null) {
                stringBuilder.append("x >= '" + this.sel.getMinimumPoint().getBlockX() + "' AND x <= '" + this.sel.getMaximumPoint().getBlockX() + "' AND y >= '" + this.sel.getMinimumPoint().getBlockY() + "' AND y <= '" + this.sel.getMaximumPoint().getBlockY() + "' AND z >= '" + this.sel.getMinimumPoint().getBlockZ() + "' AND z <= '" + this.sel.getMaximumPoint().getBlockZ() + "' AND ");
            }
        }
        if (!this.players.isEmpty() && this.sum != SummarizationMode.PLAYERS) {
            if (!this.excludePlayersMode) {
                stringBuilder.append('(');
                for (String string : this.players) {
                    stringBuilder.append("playername = '" + string + "' OR ");
                }
                stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
                stringBuilder.append(") AND ");
            } else {
                for (String string : this.players) {
                    stringBuilder.append("playername != '" + string + "' AND ");
                }
            }
        }
        if (this.since > 0) {
            stringBuilder.append("date > date_sub(now(), INTERVAL " + this.since + " MINUTE) AND ");
        }
        if (this.before > 0) {
            stringBuilder.append("date < date_sub(now(), INTERVAL " + this.before + " MINUTE) AND ");
        }
        if (stringBuilder.length() > 6) {
            stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
        } else {
            stringBuilder.delete(0, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseArgs(CommandSender commandSender, List<String> list) throws IllegalArgumentException {
        Session session;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        Session session2 = session = this.prepareToolQuery ? null : this.logblock.getSession(BukkitUtils.senderName(commandSender));
        if (player != null && this.world == null) {
            this.world = player.getWorld();
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            String string = list.get(i).toLowerCase();
            String[] stringArray = QueryParams.getValues(list, i + 1);
            if (string.equals("last")) {
                if (session.lastQuery == null) {
                    throw new IllegalArgumentException("This is your first command, you can't use last.");
                }
                this.merge(session.lastQuery);
            } else if (string.equals("player")) {
                if (stringArray == null || stringArray.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + string + "'");
                }
                for (String string2 : stringArray) {
                    if (string2.length() <= 0) continue;
                    if (string2.contains("!")) {
                        this.excludePlayersMode = true;
                    }
                    if (string2.contains("\"")) {
                        this.players.add(string2.replaceAll("[^a-zA-Z0-9_]", ""));
                        continue;
                    }
                    object2 = this.logblock.getServer().matchPlayer(string2);
                    if (object2.size() > 1) {
                        throw new IllegalArgumentException("Ambiguous playername '" + string + "'");
                    }
                    this.players.add(object2.size() == 1 ? ((Player)object2.get(0)).getName() : string2.replaceAll("[^a-zA-Z0-9_]", ""));
                }
            } else if (string.equals("block") || string.equals("type")) {
                if (stringArray == null || stringArray.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + string + "'");
                }
                for (String string3 : stringArray) {
                    object2 = Material.matchMaterial((String)string3);
                    if (object2 == null) {
                        throw new IllegalArgumentException("No material matching: '" + (String)string3 + "'");
                    }
                    this.types.add(object2.getId());
                }
            } else if (string.equals("area")) {
                if (player == null && !this.prepareToolQuery) {
                    throw new IllegalArgumentException("You have to ba a player to use area");
                }
                if (stringArray == null) {
                    this.radius = this.logblock.getConfig().defaultDist;
                    if (!this.prepareToolQuery) {
                        this.loc = player.getLocation();
                    }
                } else {
                    if (!Utils.isInt(stringArray[0])) {
                        throw new IllegalArgumentException("Not a number: '" + stringArray[0] + "'");
                    }
                    this.radius = Integer.parseInt(stringArray[0]);
                    if (!this.prepareToolQuery) {
                        this.loc = player.getLocation();
                    }
                }
            } else if (string.equals("selection") || string.equals("sel")) {
                if (player == null) {
                    throw new IllegalArgumentException("You have to ba a player to use selection");
                }
                object = player.getServer().getPluginManager().getPlugin("WorldEdit");
                if (object == null) {
                    throw new IllegalArgumentException("WorldEdit plugin not found");
                }
                Selection selection = ((WorldEditPlugin)((Object)object)).getSelection(player);
                if (selection == null) {
                    throw new IllegalArgumentException("No selection defined");
                }
                if (!(selection instanceof CuboidSelection)) {
                    throw new IllegalArgumentException("You have to define a cuboid selection");
                }
                this.setSelection(selection);
            } else if (string.equals("time") || string.equals("since")) {
                this.since = stringArray.length == 0 ? this.logblock.getConfig().defaultTime : Utils.parseTimeSpec(stringArray);
                if (this.since == -1) {
                    throw new IllegalArgumentException("Failed to parse time spec for '" + string + "'");
                }
            } else if (string.equals("before")) {
                this.before = stringArray.length == 0 ? this.logblock.getConfig().defaultTime : Utils.parseTimeSpec(stringArray);
                if (this.before == -1) {
                    throw new IllegalArgumentException("Faile to parse time spec for '" + string + "'");
                }
            } else if (string.equals("sum")) {
                if (stringArray == null || stringArray.length != 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + string + "'");
                }
                if (stringArray[0].startsWith("p")) {
                    this.sum = SummarizationMode.PLAYERS;
                } else if (stringArray[0].startsWith("b")) {
                    this.sum = SummarizationMode.TYPES;
                } else {
                    if (!stringArray[0].startsWith("n")) throw new IllegalArgumentException("Wrong summarization mode");
                    this.sum = SummarizationMode.NONE;
                }
            } else if (string.equals("created")) {
                this.bct = BlockChangeType.CREATED;
            } else if (string.equals("destroyed")) {
                this.bct = BlockChangeType.DESTROYED;
            } else if (string.equals("chestaccess")) {
                this.bct = BlockChangeType.CHESTACCESS;
            } else if (string.equals("chat")) {
                this.bct = BlockChangeType.CHAT;
            } else if (string.equals("all")) {
                this.bct = BlockChangeType.ALL;
            } else if (string.equals("limit")) {
                if (stringArray.length != 1) {
                    throw new IllegalArgumentException("Wrong count of arguments for '" + string + "'");
                }
                if (!Utils.isInt(stringArray[0])) {
                    throw new IllegalArgumentException("Not a number: '" + stringArray[0] + "'");
                }
                this.limit = Integer.parseInt(stringArray[0]);
            } else if (string.equals("world")) {
                if (stringArray.length != 1) {
                    throw new IllegalArgumentException("Wrong count of arguments for '" + string + "'");
                }
                object = commandSender.getServer().getWorld(stringArray[0].replace("\"", ""));
                if (object == null) {
                    throw new IllegalArgumentException("There is no world called '" + stringArray[0] + "'");
                }
                this.world = object;
            } else if (string.equals("asc")) {
                this.order = Order.ASC;
            } else if (string.equals("desc")) {
                this.order = Order.DESC;
            } else if (string.equals("coords")) {
                this.needCoords = true;
            } else if (string.equals("silent")) {
                this.silent = true;
            } else {
                if (!string.equals("search") && !string.equals("match")) throw new IllegalArgumentException("Not a valid argument: '" + string + "'");
                if (stringArray.length == 0) {
                    throw new IllegalArgumentException("No arguments for '" + string + "'");
                }
                this.match = Utils.join(stringArray, " ").replace("\\", "\\\\").replace("'", "\\'");
            }
            if (stringArray == null) continue;
            i += stringArray.length;
        }
        if (this.types.size() > 0) {
            for (Set<Integer> set : BukkitUtils.getBlockEquivalents()) {
                boolean bl = false;
                for (Integer n : this.types) {
                    if (!set.contains(n)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                for (Integer n : set) {
                    if (this.types.contains(n)) continue;
                    this.types.add(n);
                }
            }
        }
        if (!this.prepareToolQuery && this.bct != BlockChangeType.CHAT) {
            if (this.world == null) {
                throw new IllegalArgumentException("No world specified");
            }
            if (!this.logblock.getConfig().worlds.containsKey(this.world.getName().hashCode())) {
                throw new IllegalArgumentException("This world ('" + this.world.getName() + "') isn't logged");
            }
        }
        if (session == null) return;
        session.lastQuery = this.clone();
    }

    public void setLocation(Location location) {
        this.loc = location;
        this.world = location.getWorld();
    }

    public void setSelection(Selection selection) {
        this.sel = selection;
        this.world = selection.getWorld();
    }

    public void setPlayer(String string) {
        this.players.clear();
        this.players.add(string);
    }

    protected QueryParams clone() {
        try {
            QueryParams queryParams = (QueryParams)super.clone();
            queryParams.players = new ArrayList<String>(this.players);
            queryParams.types = new ArrayList<Integer>(this.types);
            return queryParams;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private static String[] getValues(List<String> list, int n) {
        int n2;
        for (n2 = n; n2 < list.size() && !QueryParams.isKeyWord(list.get(n2)); ++n2) {
        }
        if (n2 == n) {
            return new String[0];
        }
        String[] stringArray = new String[n2 - n];
        for (int i = n; i < n2; ++i) {
            stringArray[i - n] = list.get(i);
        }
        return stringArray;
    }

    public void merge(QueryParams queryParams) {
        this.players = queryParams.players;
        this.excludePlayersMode = queryParams.excludePlayersMode;
        this.types = queryParams.types;
        this.loc = queryParams.loc;
        this.radius = queryParams.radius;
        this.sel = queryParams.sel;
        if (queryParams.since != 0 || this.since != this.logblock.getConfig().defaultTime) {
            this.since = queryParams.since;
        }
        this.before = queryParams.before;
        this.sum = queryParams.sum;
        this.bct = queryParams.bct;
        this.limit = queryParams.limit;
        this.world = queryParams.world;
        this.order = queryParams.order;
        this.match = queryParams.match;
    }

    public static enum SummarizationMode {
        NONE,
        PLAYERS,
        TYPES;

    }

    public static enum Order {
        ASC,
        DESC;

    }

    public static enum BlockChangeType {
        ALL,
        BOTH,
        CHESTACCESS,
        CREATED,
        DESTROYED,
        CHAT;

    }
}

