/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.util.config.Configuration;

class Updater {
    private final Logger log;
    private final LogBlock logblock;

    Updater(LogBlock logBlock) {
        this.logblock = logBlock;
        this.log = logBlock.getServer().getLogger();
    }

    boolean update() {
        Object object3;
        Object object2;
        Configuration configuration = this.logblock.getConfiguration();
        configuration.load();
        if (configuration.getString("version").compareTo(this.logblock.getDescription().getVersion()) >= 0) {
            return false;
        }
        if (configuration.getString("version").compareTo("1.10") < 0) {
            this.log.info("[LogBlock] Updating config to 1.10 ...");
            object2 = configuration.getString("lookup.toolQuery");
            if (!((String)object2).contains("silent")) {
                configuration.setProperty("lookup.toolQuery", (Object)((String)object2 + " silent"));
            }
            if (!((String)(object2 = configuration.getString("lookup.toolBlockQuery"))).contains("silent")) {
                configuration.setProperty("lookup.toolBlockQuery", (Object)((String)object2 + " silent"));
            }
            configuration.setProperty("version", (Object)"1.10");
        }
        if (configuration.getString("version").compareTo("1.20") < 0) {
            this.log.info("[LogBlock] Updating tables to 1.20 ...");
            object2 = this.logblock.getConnection();
            try {
                object2.setAutoCommit(true);
                object3 = object2.createStatement();
                for (String[] stringArray2 : configuration.getStringList("tables", null)) {
                    object3.execute("ALTER TABLE `" + (String)stringArray2 + "-sign` MODIFY signtext VARCHAR(255) NOT NULL");
                }
                object3.close();
                object2.close();
            }
            catch (SQLException sQLException) {
                Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Updater] Error: ", sQLException);
                return false;
            }
            configuration.setProperty("version", (Object)"1.20");
        }
        if (configuration.getString("version").compareTo("1.23") < 0) {
            String[] stringArray2;
            this.log.info("[LogBlock] Updating tables to 1.23 ...");
            object2 = this.logblock.getConnection();
            try {
                object2.setAutoCommit(true);
                object3 = object2.createStatement();
                for (String[] stringArray2 : configuration.getStringList("tables", null)) {
                    if (object3.executeQuery("SELECT * FROM `" + (String)stringArray2 + "-chest` LIMIT 1").getMetaData().getColumnCount() == 4) continue;
                    object3.execute("DROP TABLE `" + (String)stringArray2 + "-chest`");
                }
                object3.close();
                object2.close();
            }
            catch (SQLException sQLException) {
                Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Updater] Error: ", sQLException);
                return false;
            }
            this.log.info("[LogBlock] Updating config to 1.23 ...");
            object3 = configuration.getStringList("loggedWorlds", null);
            List list = configuration.getStringList("tables", null);
            stringArray2 = new String[]{"BlockCreations", "BlockDestroyings", "SignTexts", "Explosions", "Fire", "LeavesDecay", "LavaFlow", "ChestAccess", "ButtonsAndLevers", "Kills", "Chat"};
            for (int i = 0; i < object3.size(); ++i) {
                Configuration configuration2 = new Configuration(new File("plugins/LogBlock/" + BukkitUtils.friendlyWorldname((String)object3.get(i)) + ".yml"));
                configuration2.load();
                configuration2.setProperty("table", list.get(i));
                for (String string : stringArray2) {
                    configuration2.setProperty("log" + string, (Object)configuration.getBoolean("logging.log" + string, true));
                }
                configuration2.save();
            }
            for (String string : stringArray2) {
                configuration.removeProperty("logging.log" + string);
            }
            configuration.removeProperty("tables");
            configuration.setProperty("version", (Object)"1.23");
        }
        if (configuration.getString("version").compareTo("1.27") < 0) {
            this.log.info("[LogBlock] Updating tables to 1.27 ...");
            object2 = this.logblock.getConnection();
            try {
                object2.setAutoCommit(true);
                object3 = object2.createStatement();
                object3.execute("ALTER TABLE `lb-chat` ENGINE = MyISAM, ADD FULLTEXT message (message)");
                object3.close();
                object2.close();
            }
            catch (SQLException sQLException) {
                Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Updater] Error: ", sQLException);
                return false;
            }
            configuration.setProperty("version", (Object)"1.27");
        }
        if (configuration.getString("version").compareTo("1.30") < 0) {
            this.log.info("[LogBlock] Updating config to 1.30 ...");
            for (Object object3 : configuration.getKeys("tools")) {
                if (configuration.getProperty("tools." + (String)object3 + ".permissionDefault") != null) continue;
                configuration.setProperty("tools." + (String)object3 + ".permissionDefault", (Object)"OP");
            }
            configuration.setProperty("version", (Object)"1.30");
        }
        if (configuration.getString("version").compareTo("1.31") < 0) {
            this.log.info("[LogBlock] Updating tables to 1.31 ...");
            object2 = this.logblock.getConnection();
            try {
                object2.setAutoCommit(true);
                object3 = object2.createStatement();
                object3.execute("ALTER TABLE `lb-players` ADD COLUMN lastlogin DATETIME NOT NULL, ADD COLUMN onlinetime TIME NOT NULL, ADD COLUMN ip VARCHAR(255) NOT NULL");
                object3.close();
                object2.close();
            }
            catch (SQLException sQLException) {
                Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Updater] Error: ", sQLException);
                return false;
            }
            configuration.setProperty("version", (Object)"1.31");
        }
        if (configuration.getString("version").compareTo("1.32") < 0) {
            this.log.info("[LogBlock] Updating tables to 1.32 ...");
            object2 = this.logblock.getConnection();
            try {
                object2.setAutoCommit(true);
                object3 = object2.createStatement();
                object3.execute("ALTER TABLE `lb-players` ADD COLUMN firstlogin DATETIME NOT NULL AFTER playername");
                object3.close();
                object2.close();
            }
            catch (SQLException sQLException) {
                Bukkit.getLogger().log(Level.SEVERE, "[LogBlock Updater] Error: ", sQLException);
                return false;
            }
            configuration.setProperty("version", (Object)"1.32");
        }
        configuration.save();
        return true;
    }

    void checkTables() throws SQLException {
        Connection connection = this.logblock.getConnection();
        if (connection == null) {
            throw new SQLException("No connection");
        }
        Statement statement = connection.createStatement();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        connection.setAutoCommit(true);
        this.createTable(databaseMetaData, statement, "lb-players", "(playerid SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT, playername varchar(32) NOT NULL, firstlogin DATETIME NOT NULL, lastlogin DATETIME NOT NULL, onlinetime TIME NOT NULL, ip varchar(255) NOT NULL, PRIMARY KEY (playerid), UNIQUE (playername))");
        if (this.logblock.getConfig().logChat) {
            this.createTable(databaseMetaData, statement, "lb-chat", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid SMALLINT UNSIGNED NOT NULL, message VARCHAR(255) NOT NULL, PRIMARY KEY (id), KEY playerid (playerid), FULLTEXT message (message)) ENGINE=MyISAM");
        }
        for (WorldConfig worldConfig : this.logblock.getConfig().worlds.values()) {
            this.createTable(databaseMetaData, statement, worldConfig.table, "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid SMALLINT UNSIGNED NOT NULL, replaced TINYINT UNSIGNED NOT NULL, type TINYINT UNSIGNED NOT NULL, data TINYINT UNSIGNED NOT NULL, x SMALLINT NOT NULL, y TINYINT UNSIGNED NOT NULL, z SMALLINT NOT NULL, PRIMARY KEY (id), KEY coords (x, z, y), KEY date (date), KEY playerid (playerid))");
            this.createTable(databaseMetaData, statement, worldConfig.table + "-sign", "(id INT UNSIGNED NOT NULL, signtext VARCHAR(255) NOT NULL, PRIMARY KEY (id))");
            this.createTable(databaseMetaData, statement, worldConfig.table + "-chest", "(id INT UNSIGNED NOT NULL, itemtype SMALLINT UNSIGNED NOT NULL, itemamount SMALLINT NOT NULL, itemdata TINYINT UNSIGNED NOT NULL, PRIMARY KEY (id))");
            if (!worldConfig.logKills) continue;
            this.createTable(databaseMetaData, statement, worldConfig.table + "-kills", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, killer SMALLINT UNSIGNED, victim SMALLINT UNSIGNED NOT NULL, weapon SMALLINT UNSIGNED NOT NULL, PRIMARY KEY (id))");
        }
        statement.close();
        connection.close();
    }

    private void createTable(DatabaseMetaData databaseMetaData, Statement statement, String string, String string2) throws SQLException {
        if (!databaseMetaData.getTables(null, null, string, null).next()) {
            this.log.log(Level.INFO, "[LogBlock] Creating table " + string + ".");
            statement.execute("CREATE TABLE `" + string + "` " + string2);
            if (!databaseMetaData.getTables(null, null, string, null).next()) {
                throw new SQLException("Table " + string + " not found and failed to create");
            }
        }
    }

    String checkVersion() {
        try {
            return Utils.readURL(new URL("http://diddiz.insane-architects.net/lbuptodate.php?v=" + this.logblock.getDescription().getVersion()));
        }
        catch (Exception exception) {
            return "Can't check version";
        }
    }
}

