/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.config.Configuration;

class WorldConfig {
    public final String table;
    public final boolean logBlockPlacings;
    public final boolean logBlockBreaks;
    public final boolean logSignTexts;
    public final boolean logExplosions;
    public final boolean logFire;
    public final boolean logLeavesDecay;
    public final boolean logLavaFlow;
    public final boolean logWaterFlow;
    public final boolean logChestAccess;
    public final boolean logButtonsAndLevers;
    public final boolean logKills;
    public final boolean logChat;
    public final boolean logSnowForm;
    public final boolean logSnowFade;
    public final boolean logDoors;
    public final boolean logCakes;
    public final boolean logEndermen;

    public WorldConfig(File file) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("table", "lb-" + file.getName().substring(0, file.getName().length() - 4));
        hashMap.put("logBlockCreations", true);
        hashMap.put("logBlockDestroyings", true);
        hashMap.put("logSignTexts", true);
        hashMap.put("logExplosions", true);
        hashMap.put("logFire", true);
        hashMap.put("logLeavesDecay", false);
        hashMap.put("logLavaFlow", false);
        hashMap.put("logWaterFlow", false);
        hashMap.put("logChestAccess", false);
        hashMap.put("logButtonsAndLevers", false);
        hashMap.put("logKills", false);
        hashMap.put("logChat", false);
        hashMap.put("logSnowForm", false);
        hashMap.put("logSnowFade", false);
        hashMap.put("logDoors", false);
        hashMap.put("logCakes", false);
        hashMap.put("logEndermen", false);
        Configuration configuration = new Configuration(file);
        configuration.load();
        for (Map.Entry entry : hashMap.entrySet()) {
            if (configuration.getProperty((String)entry.getKey()) != null) continue;
            configuration.setProperty((String)entry.getKey(), entry.getValue());
        }
        configuration.save();
        this.table = configuration.getString("table");
        this.logBlockPlacings = configuration.getBoolean("logBlockCreations", true);
        this.logBlockBreaks = configuration.getBoolean("logBlockDestroyings", true);
        this.logSignTexts = configuration.getBoolean("logSignTexts", false);
        this.logExplosions = configuration.getBoolean("logExplosions", false);
        this.logFire = configuration.getBoolean("logFire", false);
        this.logLeavesDecay = configuration.getBoolean("logLeavesDecay", false);
        this.logLavaFlow = configuration.getBoolean("logLavaFlow", false);
        this.logWaterFlow = configuration.getBoolean("logWaterFlow", false);
        this.logChestAccess = configuration.getBoolean("logChestAccess", false);
        this.logButtonsAndLevers = configuration.getBoolean("logButtonsAndLevers", false);
        this.logKills = configuration.getBoolean("logKills", false);
        this.logChat = configuration.getBoolean("logChat", false);
        this.logSnowForm = configuration.getBoolean("logSnowForm", false);
        this.logSnowFade = configuration.getBoolean("logSnowFade", false);
        this.logDoors = configuration.getBoolean("logDoors", false);
        this.logCakes = configuration.getBoolean("logCakes", false);
        this.logEndermen = configuration.getBoolean("logEndermen", false);
    }
}

